/*
 * Decompiled with CFR 0.152.
 */
package com.android.monkeyrunner;

import com.android.monkeyrunner.MonkeyRunner;
import com.android.monkeyrunner.doc.MonkeyRunnerExported;
import com.google.clearsilver.jsilver.JSilver;
import com.google.clearsilver.jsilver.data.Data;
import com.google.clearsilver.jsilver.resourceloader.ClassLoaderResourceLoader;
import com.google.clearsilver.jsilver.resourceloader.ResourceLoader;
import com.google.common.base.Function;
import com.google.common.base.Predicate;
import com.google.common.collect.Collections2;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import java.io.IOException;
import java.lang.reflect.AccessibleObject;
import java.lang.reflect.AnnotatedElement;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.Member;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashSet;
import java.util.Set;
import java.util.TreeSet;

public final class MonkeyRunnerHelp {
    private static final String HELP = "help";
    private static final String NAME = "name";
    private static final String DOC = "doc";
    private static final String ARGUMENT = "argument";
    private static final String RETURNS = "returns";
    private static final String TYPE = "type";
    private static Comparator<Member> MEMBER_SORTER = new Comparator<Member>(){

        @Override
        public int compare(Member o1, Member o2) {
            return o1.getName().compareTo(o2.getName());
        }
    };
    private static Comparator<Class<?>> CLASS_SORTER = new Comparator<Class<?>>(){

        @Override
        public int compare(Class<?> o1, Class<?> o2) {
            return o1.getName().compareTo(o2.getName());
        }
    };

    private MonkeyRunnerHelp() {
    }

    private static void getAllExportedClasses(Set<Field> fields, Set<Method> methods, Set<Constructor<?>> constructors, Set<Class<?>> enums) {
        final HashSet classesVisited = Sets.newHashSet();
        HashSet classesToVisit = Sets.newHashSet();
        classesToVisit.add(MonkeyRunner.class);
        Predicate haventSeen = new Predicate<Class<?>>(){

            public boolean apply(Class<?> clz) {
                return !classesVisited.contains(clz);
            }
        };
        while (!classesToVisit.isEmpty()) {
            classesVisited.addAll(classesToVisit);
            ArrayList newClasses = Lists.newArrayList();
            for (Class clz : classesToVisit) {
                if (clz.isEnum() && clz.isAnnotationPresent(MonkeyRunnerExported.class)) {
                    enums.add(clz);
                }
                for (Constructor<?> constructor : clz.getConstructors()) {
                    newClasses.addAll(Collections2.filter(Arrays.asList(constructor.getParameterTypes()), (Predicate)haventSeen));
                    if (!constructor.isAnnotationPresent(MonkeyRunnerExported.class)) continue;
                    constructors.add(constructor);
                }
                for (AccessibleObject accessibleObject : clz.getFields()) {
                    if (haventSeen.apply(accessibleObject.getClass())) {
                        newClasses.add(accessibleObject.getClass());
                    }
                    if (!accessibleObject.isAnnotationPresent(MonkeyRunnerExported.class)) continue;
                    fields.add((Field)accessibleObject);
                }
                for (AccessibleObject accessibleObject : clz.getMethods()) {
                    newClasses.addAll(Collections2.filter(Arrays.asList(((Method)accessibleObject).getParameterTypes()), (Predicate)haventSeen));
                    if (haventSeen.apply(((Method)accessibleObject).getReturnType())) {
                        newClasses.add(((Method)accessibleObject).getReturnType());
                    }
                    if (!accessibleObject.isAnnotationPresent(MonkeyRunnerExported.class)) continue;
                    methods.add((Method)accessibleObject);
                }
                for (AnnotatedElement annotatedElement : clz.getClasses()) {
                    if (!haventSeen.apply((Object)annotatedElement)) continue;
                    newClasses.add(annotatedElement);
                }
            }
            classesToVisit.clear();
            classesToVisit.addAll(newClasses);
        }
    }

    public static String helpString(String format) {
        ClassLoaderResourceLoader resourceLoader = new ClassLoaderResourceLoader(MonkeyRunner.class.getClassLoader(), "com/android/monkeyrunner");
        JSilver jsilver = new JSilver((ResourceLoader)resourceLoader);
        if ("html".equals(format) || "text".equals(format) || "sdk-docs".equals(format)) {
            try {
                Data hdf = MonkeyRunnerHelp.buildHelpHdf(jsilver);
                return jsilver.render(format + ".cs", hdf);
            }
            catch (IOException e) {
                return "";
            }
        }
        if ("hdf".equals(format)) {
            Data hdf = MonkeyRunnerHelp.buildHelpHdf(jsilver);
            return hdf.toString();
        }
        return "";
    }

    private static void paragraphsIntoHDF(String prefix, String value, Data hdf) {
        String[] paragraphs = value.split("\n");
        int x = 0;
        for (String para : paragraphs) {
            hdf.setValue(prefix + "." + x, para);
            ++x;
        }
    }

    private static Data buildHelpHdf(JSilver jsilver) {
        MonkeyRunnerExported annotation;
        String prefix;
        Data hdf = jsilver.createData();
        int outputItemCount = 0;
        TreeSet fields = Sets.newTreeSet(MEMBER_SORTER);
        TreeSet methods = Sets.newTreeSet(MEMBER_SORTER);
        TreeSet constructors = Sets.newTreeSet(MEMBER_SORTER);
        TreeSet classes = Sets.newTreeSet(CLASS_SORTER);
        MonkeyRunnerHelp.getAllExportedClasses(fields, methods, constructors, classes);
        for (Class clz : classes) {
            prefix = "help." + outputItemCount + ".";
            hdf.setValue(prefix + NAME, clz.getCanonicalName());
            annotation = clz.getAnnotation(MonkeyRunnerExported.class);
            MonkeyRunnerHelp.paragraphsIntoHDF(prefix + DOC, annotation.doc(), hdf);
            hdf.setValue(prefix + TYPE, Type.ENUM.name());
            T[] constants = clz.getEnumConstants();
            String[] argDocs = annotation.argDocs();
            if (constants.length > 0) {
                for (int x = 0; x < constants.length; ++x) {
                    String argPrefix = prefix + ARGUMENT + "." + x + ".";
                    hdf.setValue(argPrefix + NAME, constants[x].toString());
                    if (argDocs.length <= x) continue;
                    MonkeyRunnerHelp.paragraphsIntoHDF(argPrefix + DOC, argDocs[x], hdf);
                }
            }
            ++outputItemCount;
        }
        for (Method m : methods) {
            prefix = "help." + outputItemCount + ".";
            annotation = m.getAnnotation(MonkeyRunnerExported.class);
            String className = m.getDeclaringClass().getCanonicalName();
            String methodName = className + "." + m.getName();
            hdf.setValue(prefix + NAME, methodName);
            MonkeyRunnerHelp.paragraphsIntoHDF(prefix + DOC, annotation.doc(), hdf);
            if (annotation.args().length > 0) {
                String[] argDocs = annotation.argDocs();
                String[] aargs = annotation.args();
                for (int x = 0; x < aargs.length; ++x) {
                    String argPrefix = prefix + ARGUMENT + "." + x + ".";
                    hdf.setValue(argPrefix + NAME, aargs[x]);
                    if (argDocs.length <= x) continue;
                    MonkeyRunnerHelp.paragraphsIntoHDF(argPrefix + DOC, argDocs[x], hdf);
                }
            }
            if (!"".equals(annotation.returns())) {
                MonkeyRunnerHelp.paragraphsIntoHDF(prefix + RETURNS, annotation.returns(), hdf);
            }
            ++outputItemCount;
        }
        return hdf;
    }

    public static Collection<String> getAllDocumentedClasses() {
        TreeSet fields = Sets.newTreeSet(MEMBER_SORTER);
        TreeSet methods = Sets.newTreeSet(MEMBER_SORTER);
        TreeSet constructors = Sets.newTreeSet(MEMBER_SORTER);
        TreeSet classes = Sets.newTreeSet(CLASS_SORTER);
        MonkeyRunnerHelp.getAllExportedClasses(fields, methods, constructors, classes);
        HashSet allClasses = Sets.newHashSet();
        allClasses.addAll(classes);
        for (Field f : fields) {
            allClasses.add(f.getDeclaringClass());
        }
        for (Method m : methods) {
            allClasses.add(m.getDeclaringClass());
        }
        for (Constructor constructor : constructors) {
            allClasses.add(constructor.getDeclaringClass());
        }
        return Collections2.transform((Collection)allClasses, (Function)new Function<Class<?>, String>(){

            public String apply(Class<?> clz) {
                return clz.getName();
            }
        });
    }

    private static enum Type {
        ENUM,
        FIELD,
        METHOD;

    }
}

