/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.e4.core.internal.di.osgi;

import org.eclipse.osgi.framework.log.FrameworkLog;
import org.eclipse.osgi.service.debug.DebugOptions;
import org.osgi.framework.BundleActivator;
import org.osgi.framework.BundleContext;
import org.osgi.util.tracker.ServiceTracker;

public class DIActivator
implements BundleActivator {
    private static DIActivator defaultInstance;
    private BundleContext bundleContext;
    private ServiceTracker debugTracker = null;
    private ServiceTracker logTracker = null;

    public DIActivator() {
        defaultInstance = this;
    }

    public static DIActivator getDefault() {
        return defaultInstance;
    }

    public void start(BundleContext context) throws Exception {
        this.bundleContext = context;
    }

    public void stop(BundleContext context) throws Exception {
        if (this.debugTracker != null) {
            this.debugTracker.close();
            this.debugTracker = null;
        }
        if (this.logTracker != null) {
            this.logTracker.close();
            this.logTracker = null;
        }
        this.bundleContext = null;
    }

    public BundleContext getBundleContext() {
        return this.bundleContext;
    }

    public boolean getBooleanDebugOption(String option, boolean defaultValue) {
        String value;
        DebugOptions options;
        if (this.debugTracker == null) {
            this.debugTracker = new ServiceTracker(this.bundleContext, DebugOptions.class.getName(), null);
            this.debugTracker.open();
        }
        if ((options = (DebugOptions)this.debugTracker.getService()) != null && (value = options.getOption(option)) != null) {
            return value.equalsIgnoreCase("true");
        }
        return defaultValue;
    }

    public FrameworkLog getFrameworkLog() {
        if (this.logTracker == null) {
            if (this.bundleContext == null) {
                return null;
            }
            this.logTracker = new ServiceTracker(this.bundleContext, FrameworkLog.class.getName(), null);
            this.logTracker.open();
        }
        return (FrameworkLog)this.logTracker.getService();
    }
}

