/*
 * Decompiled with CFR 0.152.
 */
package com.android.ant;

import com.android.ant.InputPath;
import com.android.ant.SingleDependencyTask;
import com.android.ant.TaskHelper;
import com.android.sdklib.build.ApkBuilder;
import com.android.sdklib.build.ApkCreationException;
import com.android.sdklib.build.DuplicateFileException;
import com.android.sdklib.build.SealedApkException;
import java.io.File;
import java.io.FilenameFilter;
import java.util.ArrayList;
import java.util.List;
import java.util.regex.Pattern;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.types.Path;

public class ApkBuilderTask
extends SingleDependencyTask {
    private static final Pattern PATTERN_JAR_EXT = Pattern.compile("^.+\\.jar$", 2);
    private String mOutFolder;
    private String mApkFilepath;
    private String mResourceFile;
    private boolean mVerbose = false;
    private boolean mDebugPackaging = false;
    private boolean mDebugSigning = false;
    private boolean mHasCode = true;
    private Path mDexPath;
    private final ArrayList<Path> mZipList = new ArrayList();
    private final ArrayList<Path> mSourceList = new ArrayList();
    private final ArrayList<Path> mJarfolderList = new ArrayList();
    private final ArrayList<Path> mJarfileList = new ArrayList();
    private final ArrayList<Path> mNativeList = new ArrayList();

    public void setOutfolder(Path outFolder) {
        this.mOutFolder = TaskHelper.checkSinglePath("outfolder", outFolder);
    }

    public void setApkfilepath(String filepath) {
        this.mApkFilepath = filepath;
    }

    public void setResourcefile(String resourceFile) {
        this.mResourceFile = resourceFile;
    }

    public void setVerbose(boolean verbose) {
        this.mVerbose = verbose;
    }

    public void setDebug(boolean debug) {
        System.out.println("WARNNG: Using deprecated 'debug' attribute in ApkBuilderTask.Use 'debugpackaging' and 'debugsigning' instead.");
        this.mDebugPackaging = debug;
        this.mDebugSigning = debug;
    }

    public void setDebugpackaging(boolean debug) {
        this.mDebugPackaging = debug;
    }

    public void setDebugsigning(boolean debug) {
        this.mDebugSigning = debug;
    }

    public void setHascode(boolean hasCode) {
        this.mHasCode = hasCode;
    }

    public Object createZip() {
        Path path = new Path(this.getProject());
        this.mZipList.add(path);
        return path;
    }

    public Object createDex() {
        if (this.mDexPath == null) {
            this.mDexPath = new Path(this.getProject());
            return this.mDexPath;
        }
        throw new BuildException("Only one <dex> inner element can be provided");
    }

    public Object createSourcefolder() {
        Path path = new Path(this.getProject());
        this.mSourceList.add(path);
        return path;
    }

    public Object createJarfolder() {
        Path path = new Path(this.getProject());
        this.mJarfolderList.add(path);
        return path;
    }

    public Object createJarfile() {
        Path path = new Path(this.getProject());
        this.mJarfileList.add(path);
        return path;
    }

    public Object createNativefolder() {
        Path path = new Path(this.getProject());
        this.mNativeList.add(path);
        return path;
    }

    public void execute() throws BuildException {
        if (this.mApkFilepath == null) {
            throw new BuildException("missing attribute 'apkFilepath'");
        }
        File outputFile = new File(this.mApkFilepath);
        if (this.mResourceFile == null) {
            throw new BuildException("missing attribute 'resourcefile'");
        }
        if (this.mOutFolder == null) {
            throw new BuildException("missing attribute 'outfolder'");
        }
        File dexFile = null;
        if (this.mHasCode) {
            String[] dexFiles = this.mDexPath.list();
            if (dexFiles.length != 1) {
                throw new BuildException(String.format("Expected one dex file but path value resolve to %d files.", dexFiles.length));
            }
            dexFile = new File(dexFiles[0]);
        }
        try {
            ArrayList<InputPath> inputPaths = new ArrayList<InputPath>();
            InputPath resourceInputPath = new InputPath(new File(this.mOutFolder, this.mResourceFile));
            inputPaths.add(resourceInputPath);
            if (dexFile != null) {
                inputPaths.add(new InputPath(dexFile));
            }
            ArrayList<File> zipFiles = new ArrayList<File>();
            for (Path pathList : this.mZipList) {
                for (String path : pathList.list()) {
                    File f = new File(path);
                    zipFiles.add(f);
                    inputPaths.add(new InputPath(f));
                }
            }
            ArrayList<File> sourceFolderList = new ArrayList<File>();
            if (this.mHasCode) {
                for (Path pathList : this.mSourceList) {
                    for (String path : pathList.list()) {
                        File f = new File(path);
                        sourceFolderList.add(f);
                        inputPaths.add(new SourceFolderInputPath(f));
                    }
                }
            }
            ArrayList<File> jarFileList = new ArrayList<File>();
            for (Path pathList : this.mJarfolderList) {
                for (String path : pathList.list()) {
                    String[] filenames;
                    File folder = new File(path);
                    if (!folder.isDirectory()) continue;
                    for (String filename : filenames = folder.list(new FilenameFilter(){

                        @Override
                        public boolean accept(File dir, String name) {
                            return PATTERN_JAR_EXT.matcher(name).matches();
                        }
                    })) {
                        File f = new File(folder, filename);
                        jarFileList.add(f);
                        inputPaths.add(new InputPath(f));
                    }
                }
            }
            for (Path pathList : this.mJarfileList) {
                for (String path : pathList.list()) {
                    File f = new File(path);
                    jarFileList.add(f);
                    inputPaths.add(new InputPath(f));
                }
            }
            ArrayList<ApkBuilder.FileEntry> nativeFileList = new ArrayList<ApkBuilder.FileEntry>();
            for (Path pathList : this.mNativeList) {
                for (String path : pathList.list()) {
                    File folder = new File(path);
                    if (!folder.isDirectory()) continue;
                    List<ApkBuilder.FileEntry> entries = ApkBuilder.getNativeFiles(folder, this.mDebugPackaging);
                    nativeFileList.addAll(entries);
                    for (ApkBuilder.FileEntry entry : entries) {
                        inputPaths.add(new InputPath(entry.mFile));
                    }
                }
            }
            String depFile = outputFile.getAbsolutePath() + ".d";
            if (this.initDependencies(depFile, inputPaths) && !this.dependenciesHaveChanged()) {
                System.out.println("No changes. No need to create apk.");
                return;
            }
            if (this.mDebugSigning) {
                System.out.println(String.format("Creating %s and signing it with a debug key...", outputFile.getName()));
            } else {
                System.out.println(String.format("Creating %s for release...", outputFile.getName()));
            }
            ApkBuilder apkBuilder = new ApkBuilder(outputFile, resourceInputPath.getFile(), dexFile, this.mDebugSigning ? ApkBuilder.getDebugKeystore() : null, this.mVerbose ? System.out : null);
            apkBuilder.setDebugMode(this.mDebugPackaging);
            for (File f : zipFiles) {
                if (this.mVerbose) {
                    System.out.println("Zip Input: " + f.getAbsolutePath());
                }
                apkBuilder.addZipFile(f);
            }
            for (File f : sourceFolderList) {
                if (this.mVerbose) {
                    System.out.println("Source Folder Input: " + f.getAbsolutePath());
                }
                apkBuilder.addSourceFolder(f);
            }
            for (File f : jarFileList) {
                if (this.mVerbose) {
                    System.out.println("Jar Input: " + f.getAbsolutePath());
                }
                apkBuilder.addResourcesFromJar(f);
            }
            apkBuilder.addNativeLibraries(nativeFileList);
            apkBuilder.sealApk();
            this.generateDependencyFile(depFile, inputPaths, outputFile.getAbsolutePath());
        }
        catch (DuplicateFileException e) {
            System.err.println(String.format("Found duplicate file for APK: %1$s\nOrigin 1: %2$s\nOrigin 2: %3$s", e.getArchivePath(), e.getFile1(), e.getFile2()));
            throw new BuildException((Throwable)e);
        }
        catch (ApkCreationException e) {
            throw new BuildException((Throwable)e);
        }
        catch (SealedApkException e) {
            throw new BuildException((Throwable)e);
        }
        catch (IllegalArgumentException e) {
            throw new BuildException((Throwable)e);
        }
    }

    @Override
    protected String getExecTaskName() {
        return "apkbuilder";
    }

    private static class SourceFolderInputPath
    extends InputPath {
        public SourceFolderInputPath(File file) {
            super(file);
        }

        @Override
        public boolean ignores(File file) {
            if (file.isDirectory()) {
                return !ApkBuilder.checkFolderForPackaging(file.getName());
            }
            return !ApkBuilder.checkFileForPackaging(file.getName());
        }
    }
}

