/*
 * Decompiled with CFR 0.152.
 */
package com.android.ant;

import com.android.annotations.NonNull;
import com.android.ant.InputPath;
import com.android.ant.SingleDependencyTask;
import com.android.ant.TaskHelper;
import com.android.manifmerger.ICallback;
import com.android.manifmerger.ManifestMerger;
import com.android.manifmerger.MergerLog;
import com.android.sdklib.AndroidTargetHash;
import com.android.sdklib.AndroidVersion;
import com.android.sdklib.IAndroidTarget;
import com.android.sdklib.SdkManager;
import com.android.sdklib.io.FileOp;
import com.android.utils.StdLogger;
import com.google.common.collect.Lists;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.types.Path;

public class ManifestMergerTask
extends SingleDependencyTask {
    private String mAppManifest;
    private String mOutManifest;
    private ArrayList<Path> mLibraryPaths;
    private boolean mEnabled = false;

    public void setAppManifest(Path appManifest) {
        this.mAppManifest = TaskHelper.checkSinglePath("appManifest", appManifest);
    }

    public void setOutManifest(Path outManifest) {
        this.mOutManifest = TaskHelper.checkSinglePath("outManifest", outManifest);
    }

    public void setEnabled(boolean enabled) {
        this.mEnabled = enabled;
    }

    public Object createLibrary() {
        if (this.mLibraryPaths == null) {
            this.mLibraryPaths = new ArrayList();
        }
        Path path = new Path(this.getProject());
        this.mLibraryPaths.add(path);
        return path;
    }

    public void execute() throws BuildException {
        List<InputPath> inputPaths;
        String depFile;
        if (this.mAppManifest == null) {
            throw new BuildException("Missing attribute appManifest");
        }
        if (this.mOutManifest == null) {
            throw new BuildException("Missing attribute outManifest");
        }
        ArrayList libraries = Lists.newArrayList();
        if (this.mLibraryPaths != null) {
            for (Path pathList : this.mLibraryPaths) {
                for (String path : pathList.list()) {
                    libraries.add(new File(path));
                }
            }
        }
        ArrayList allInputs = Lists.newArrayListWithCapacity((int)(libraries.size() + 1));
        File appManifestFile = new File(this.mAppManifest);
        allInputs.add(appManifestFile);
        if (this.mEnabled) {
            allInputs.addAll(libraries);
        }
        if (this.initDependencies(depFile = this.mOutManifest + ".d", inputPaths = ManifestMergerTask.getInputPaths(allInputs, null, null)) && !this.dependenciesHaveChanged()) {
            System.out.println("No changes in the AndroidManifest files.");
            return;
        }
        System.out.println("Merging AndroidManifest files into one.");
        if (!this.mEnabled || libraries.isEmpty()) {
            if (!this.mEnabled) {
                System.out.println("Manifest merger disabled. Using project manifest only.");
            } else {
                System.out.println("No libraries. Using project manifest only.");
            }
            try {
                new FileOp().copyFile(appManifestFile, new File(this.mOutManifest));
            }
            catch (IOException e) {
                throw new BuildException((Throwable)e);
            }
        } else {
            System.out.println(String.format("Merging manifests from project and %d libraries.", libraries.size()));
            ManifestMerger merger = new ManifestMerger(MergerLog.wrapSdkLog(new StdLogger(StdLogger.Level.VERBOSE)), new ICallback(){
                SdkManager mManager;

                @Override
                public int queryCodenameApiLevel(@NonNull String codename) {
                    if (this.mManager == null) {
                        File sdkDir = TaskHelper.getSdkLocation(ManifestMergerTask.this.getProject());
                        this.mManager = SdkManager.createManager(sdkDir.getPath(), new StdLogger(StdLogger.Level.VERBOSE));
                    }
                    if (this.mManager != null) {
                        try {
                            AndroidVersion version = new AndroidVersion(codename);
                            IAndroidTarget t = this.mManager.getTargetFromHashString(AndroidTargetHash.getPlatformHashString(version));
                            if (t != null) {
                                return t.getVersion().getApiLevel();
                            }
                        }
                        catch (AndroidVersion.AndroidVersionException androidVersionException) {
                            // empty catch block
                        }
                    }
                    return 0;
                }
            });
            if (!merger.process(new File(this.mOutManifest), appManifestFile, libraries.toArray(new File[libraries.size()]), null, null)) {
                throw new BuildException();
            }
        }
        this.generateDependencyFile(depFile, inputPaths, this.mOutManifest);
    }

    @Override
    protected String getExecTaskName() {
        return "ManifestMerger";
    }
}

