/*
 * Decompiled with CFR 0.152.
 */
package com.android.ant;

import com.android.xml.AndroidXPathFactory;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import javax.xml.xpath.XPath;
import javax.xml.xpath.XPathExpressionException;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.Task;
import org.apache.tools.ant.types.Path;
import org.xml.sax.InputSource;

public class XPathTask
extends Task {
    private Path mManifestFile;
    private String mProperty;
    private String mExpression;
    private String mDefault;

    public void setInput(Path manifestFile) {
        this.mManifestFile = manifestFile;
    }

    public void setOutput(String property) {
        this.mProperty = property;
    }

    public void setExpression(String expression) {
        this.mExpression = expression;
    }

    public void setDefault(String defaultValue) {
        this.mDefault = defaultValue;
    }

    public void execute() throws BuildException {
        try {
            String file;
            if (this.mManifestFile == null || this.mManifestFile.list().length == 0) {
                throw new BuildException("input attribute is missing!");
            }
            if (this.mProperty == null) {
                throw new BuildException("output attribute is missing!");
            }
            if (this.mExpression == null) {
                throw new BuildException("expression attribute is missing!");
            }
            XPath xpath = AndroidXPathFactory.newXPath();
            String result = xpath.evaluate(this.mExpression, new InputSource(new FileInputStream(file = this.mManifestFile.list()[0])));
            if (result.length() == 0 && this.mDefault != null) {
                result = this.mDefault;
            }
            this.getProject().setProperty(this.mProperty, result);
        }
        catch (XPathExpressionException e) {
            throw new BuildException((Throwable)e);
        }
        catch (FileNotFoundException e) {
            throw new BuildException((Throwable)e);
        }
    }
}

