/*
 * Decompiled with CFR 0.152.
 */
package com.android.ide.common.rendering;

import com.android.annotations.NonNull;
import com.android.annotations.Nullable;

public class RenderSecurityException
extends SecurityException {
    private final String myMessage;

    private RenderSecurityException(@NonNull String message) {
        super(message);
        this.myMessage = message;
    }

    @Override
    public String getMessage() {
        return this.myMessage;
    }

    @Override
    public String toString() {
        return this.getMessage();
    }

    @NonNull
    public static RenderSecurityException create(@NonNull String resource, @Nullable String context) {
        return new RenderSecurityException(RenderSecurityException.computeLabel(resource, context));
    }

    @NonNull
    public static RenderSecurityException create(@NonNull String message) {
        return new RenderSecurityException(message);
    }

    private static String computeLabel(@NonNull String resource, @Nullable String context) {
        StringBuilder sb = new StringBuilder(40);
        sb.append(resource);
        sb.append(" access not allowed during rendering");
        if (context != null) {
            sb.append(" (").append(context).append(")");
        }
        return sb.toString();
    }
}

