/*
 * Decompiled with CFR 0.152.
 */
package com.android.ide.common.res2;

import com.android.annotations.NonNull;
import com.android.annotations.Nullable;
import java.io.File;

public class MergingException
extends Exception {
    private String mMessage;
    private File mFile;
    private int mLine = -1;
    private int mColumn = -1;

    public MergingException(@NonNull String message, @Nullable Throwable cause) {
        super(message, cause);
        this.mMessage = message;
    }

    public MergingException(@NonNull String message) {
        this(message, null);
    }

    public MergingException(@NonNull Throwable cause) {
        this(cause.getLocalizedMessage(), cause);
    }

    public MergingException setFile(@NonNull File file) {
        this.mFile = file;
        return this;
    }

    public MergingException setCause(@NonNull Throwable cause) {
        this.initCause(cause);
        return this;
    }

    public MergingException setLine(int line) {
        this.mLine = line;
        return this;
    }

    public MergingException setColumn(int column) {
        this.mColumn = column;
        return this;
    }

    @Override
    public String getMessage() {
        StringBuilder sb = new StringBuilder();
        String path = null;
        if (this.mFile != null) {
            path = this.mFile.getAbsolutePath();
            sb.append(path);
            if (this.mLine >= 0) {
                sb.append(':');
                sb.append(Integer.toString(this.mLine));
                if (this.mColumn >= 0) {
                    sb.append(':');
                    sb.append(Integer.toString(this.mColumn));
                }
            }
        }
        if (sb.length() > 0) {
            sb.append(':').append(' ');
            if (!this.mMessage.startsWith("Error: ")) {
                sb.append("Error: ");
            }
        } else if (!this.mMessage.contains("Error: ")) {
            sb.append("Error: ");
        }
        String message = this.mMessage;
        if (path != null && message.startsWith(path)) {
            int stripStart = path.length();
            if (message.length() > stripStart && message.charAt(stripStart) == ':') {
                ++stripStart;
            }
            if (message.length() > stripStart && message.charAt(stripStart) == ' ') {
                ++stripStart;
            }
            message = message.substring(stripStart);
        }
        sb.append(message);
        return sb.toString();
    }

    @Override
    public String toString() {
        return this.getMessage();
    }

    @Nullable
    public File getFile() {
        return this.mFile;
    }

    public int getLine() {
        return this.mLine;
    }

    public int getColumn() {
        return this.mColumn;
    }
}

