/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.lint.client.api;

import com.android.annotations.NonNull;
import com.android.tools.lint.client.api.IssueRegistry;
import com.android.tools.lint.detector.api.Issue;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.List;

class CompositeIssueRegistry
extends IssueRegistry {
    private final List<IssueRegistry> myRegistries;
    private List<Issue> myIssues;

    public CompositeIssueRegistry(@NonNull List<IssueRegistry> registries) {
        this.myRegistries = registries;
    }

    @Override
    @NonNull
    public List<Issue> getIssues() {
        if (this.myIssues == null) {
            ArrayList issues = Lists.newArrayListWithExpectedSize((int)200);
            for (IssueRegistry registry : this.myRegistries) {
                issues.addAll(registry.getIssues());
            }
            this.myIssues = issues;
        }
        return this.myIssues;
    }
}

