/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.lint.client.api;

import com.android.annotations.NonNull;
import com.android.tools.lint.client.api.IssueRegistry;
import com.android.tools.lint.client.api.LintClient;
import com.android.tools.lint.detector.api.Issue;
import com.android.tools.lint.detector.api.Severity;
import com.android.utils.SdkUtils;
import com.google.common.collect.Lists;
import java.io.File;
import java.io.IOException;
import java.lang.ref.SoftReference;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.jar.Attributes;
import java.util.jar.JarFile;
import java.util.jar.Manifest;

class JarFileIssueRegistry
extends IssueRegistry {
    private static final String MF_LINT_REGISTRY = "Lint-Registry";
    private static Map<File, SoftReference<JarFileIssueRegistry>> sCache;
    private final List<Issue> myIssues = Lists.newArrayList();

    @NonNull
    static IssueRegistry get(@NonNull LintClient client, @NonNull File jarFile) throws IOException, ClassNotFoundException, IllegalAccessException, InstantiationException {
        if (sCache == null) {
            sCache = new HashMap<File, SoftReference<JarFileIssueRegistry>>();
        } else {
            JarFileIssueRegistry registry;
            SoftReference<JarFileIssueRegistry> reference = sCache.get(jarFile);
            if (reference != null && (registry = reference.get()) != null) {
                return registry;
            }
        }
        JarFileIssueRegistry registry = new JarFileIssueRegistry(client, jarFile);
        sCache.put(jarFile, new SoftReference<JarFileIssueRegistry>(registry));
        return registry;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private JarFileIssueRegistry(@NonNull LintClient client, @NonNull File file) throws IOException, ClassNotFoundException, IllegalAccessException, InstantiationException {
        JarFile jarFile = null;
        try {
            jarFile = new JarFile(file);
            Manifest manifest = jarFile.getManifest();
            Attributes attrs = manifest.getMainAttributes();
            Object object = attrs.get(new Attributes.Name(MF_LINT_REGISTRY));
            if (object instanceof String) {
                String className = (String)object;
                URL url = SdkUtils.fileToUrl((File)file);
                URLClassLoader loader = new URLClassLoader(new URL[]{url}, JarFileIssueRegistry.class.getClassLoader());
                Class<?> registryClass = Class.forName(className, true, loader);
                IssueRegistry registry = (IssueRegistry)registryClass.newInstance();
                this.myIssues.addAll(registry.getIssues());
            } else {
                client.log(Severity.ERROR, null, "Custom lint rule jar %1$s does not contain a valid registry manifest key (%2$s).\nEither the custom jar is invalid, or it uses an outdated API not supported this lint client", file.getPath(), MF_LINT_REGISTRY);
            }
        }
        finally {
            if (jarFile != null) {
                jarFile.close();
            }
        }
    }

    @Override
    @NonNull
    public List<Issue> getIssues() {
        return this.myIssues;
    }
}

