/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.lint.client.api;

import com.android.annotations.NonNull;
import com.android.annotations.Nullable;
import com.android.ide.common.res2.AbstractResourceRepository;
import com.android.ide.common.res2.ResourceItem;
import com.android.resources.ResourceFolderType;
import com.android.sdklib.IAndroidTarget;
import com.android.sdklib.repository.local.LocalSdk;
import com.android.tools.lint.client.api.AsmVisitor;
import com.android.tools.lint.client.api.CircularDependencyException;
import com.android.tools.lint.client.api.CompositeIssueRegistry;
import com.android.tools.lint.client.api.Configuration;
import com.android.tools.lint.client.api.IssueRegistry;
import com.android.tools.lint.client.api.JarFileIssueRegistry;
import com.android.tools.lint.client.api.JavaParser;
import com.android.tools.lint.client.api.JavaVisitor;
import com.android.tools.lint.client.api.LintClient;
import com.android.tools.lint.client.api.LintListener;
import com.android.tools.lint.client.api.LintRequest;
import com.android.tools.lint.client.api.OtherFileVisitor;
import com.android.tools.lint.client.api.ResourceVisitor;
import com.android.tools.lint.client.api.SdkInfo;
import com.android.tools.lint.client.api.XmlParser;
import com.android.tools.lint.detector.api.ClassContext;
import com.android.tools.lint.detector.api.Context;
import com.android.tools.lint.detector.api.Detector;
import com.android.tools.lint.detector.api.Issue;
import com.android.tools.lint.detector.api.JavaContext;
import com.android.tools.lint.detector.api.LintUtils;
import com.android.tools.lint.detector.api.Location;
import com.android.tools.lint.detector.api.Project;
import com.android.tools.lint.detector.api.ResourceContext;
import com.android.tools.lint.detector.api.ResourceXmlDetector;
import com.android.tools.lint.detector.api.Scope;
import com.android.tools.lint.detector.api.Severity;
import com.android.tools.lint.detector.api.XmlContext;
import com.google.common.annotations.Beta;
import com.google.common.base.Objects;
import com.google.common.collect.ArrayListMultimap;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import com.google.common.io.ByteStreams;
import com.google.common.io.Closeables;
import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.net.URLConnection;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Deque;
import java.util.EnumMap;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.HashSet;
import java.util.IdentityHashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.zip.ZipInputStream;
import lombok.ast.Annotation;
import lombok.ast.AnnotationElement;
import lombok.ast.AnnotationValue;
import lombok.ast.ArrayInitializer;
import lombok.ast.ClassDeclaration;
import lombok.ast.ConstructorDeclaration;
import lombok.ast.Expression;
import lombok.ast.MethodDeclaration;
import lombok.ast.Modifiers;
import lombok.ast.Node;
import lombok.ast.StrictListAccessor;
import lombok.ast.StringLiteral;
import lombok.ast.TypeReference;
import lombok.ast.VariableDefinition;
import org.objectweb.asm.ClassReader;
import org.objectweb.asm.ClassVisitor;
import org.objectweb.asm.tree.AbstractInsnNode;
import org.objectweb.asm.tree.AnnotationNode;
import org.objectweb.asm.tree.ClassNode;
import org.objectweb.asm.tree.FieldInsnNode;
import org.objectweb.asm.tree.FieldNode;
import org.objectweb.asm.tree.InsnList;
import org.objectweb.asm.tree.MethodInsnNode;
import org.objectweb.asm.tree.MethodNode;
import org.w3c.dom.Attr;
import org.w3c.dom.Element;

@Beta
public class LintDriver {
    private static final int MAX_PHASES = 3;
    private static final String SUPPRESS_LINT_VMSIG = "/SuppressLint;";
    private static final String STUDIO_ID_PREFIX = "AndroidLint";
    private final LintClient mClient;
    private LintRequest mRequest;
    private IssueRegistry mRegistry;
    private volatile boolean mCanceled;
    private EnumSet<Scope> mScope;
    private List<? extends Detector> mApplicableDetectors;
    private Map<Scope, List<Detector>> mScopeDetectors;
    private List<LintListener> mListeners;
    private int mPhase;
    private List<Detector> mRepeatingDetectors;
    private EnumSet<Scope> mRepeatScope;
    private Project[] mCurrentProjects;
    private Project mCurrentProject;
    private boolean mAbbreviating = true;
    private boolean mParserErrors;
    private Map<Object, Object> mProperties;
    private Map<String, String> mSuperClassMap;
    private Deque<ClassNode> mOuterClasses;
    private ResourceFolderType mCurrentFolderType;
    private List<ResourceXmlDetector> mCurrentXmlDetectors;
    private List<Detector> mCurrentBinaryDetectors;
    private ResourceVisitor mCurrentVisitor;

    public LintDriver(@NonNull IssueRegistry registry, @NonNull LintClient client) {
        this.mRegistry = registry;
        this.mClient = new LintClientWrapper(client);
    }

    public void cancel() {
        this.mCanceled = true;
    }

    @NonNull
    public EnumSet<Scope> getScope() {
        return this.mScope;
    }

    public void setScope(@NonNull EnumSet<Scope> scope) {
        this.mScope = scope;
    }

    @NonNull
    public LintClient getClient() {
        return this.mClient;
    }

    @NonNull
    public LintRequest getRequest() {
        return this.mRequest;
    }

    public void putProperty(@NonNull Object key, @Nullable Object value) {
        if (this.mProperties == null) {
            this.mProperties = Maps.newHashMap();
        }
        if (value == null) {
            this.mProperties.remove(key);
        } else {
            this.mProperties.put(key, value);
        }
    }

    @Nullable
    public Object getProperty(@NonNull Object key) {
        if (this.mProperties != null) {
            return this.mProperties.get(key);
        }
        return null;
    }

    public int getPhase() {
        return this.mPhase;
    }

    @NonNull
    public IssueRegistry getRegistry() {
        return this.mRegistry;
    }

    @Nullable
    public Project findProjectFor(@NonNull File file) {
        if (this.mCurrentProjects != null) {
            if (this.mCurrentProjects.length == 1) {
                return this.mCurrentProjects[0];
            }
            String path = file.getPath();
            for (Project project : this.mCurrentProjects) {
                if (!path.startsWith(project.getDir().getPath())) continue;
                return project;
            }
        }
        return null;
    }

    public void setAbbreviating(boolean abbreviating) {
        this.mAbbreviating = abbreviating;
    }

    public boolean isAbbreviating() {
        return this.mAbbreviating;
    }

    public boolean hasParserErrors() {
        return this.mParserErrors;
    }

    public void setHasParserErrors(boolean hasErrors) {
        this.mParserErrors = hasErrors;
    }

    @NonNull
    public List<Project> getProjects() {
        if (this.mCurrentProjects != null) {
            return Arrays.asList(this.mCurrentProjects);
        }
        return Collections.emptyList();
    }

    @Deprecated
    public void analyze(@NonNull List<File> files, @Nullable EnumSet<Scope> scope) {
        this.analyze(new LintRequest(this.mClient, files).setScope(scope));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void analyze(@NonNull LintRequest request) {
        try {
            this.mRequest = request;
            this.analyze();
        }
        finally {
            this.mRequest = null;
        }
    }

    private void analyze() {
        Collection<Project> projects;
        this.mCanceled = false;
        this.mScope = this.mRequest.getScope();
        assert (this.mScope == null || !this.mScope.contains((Object)Scope.ALL_RESOURCE_FILES) || this.mScope.contains((Object)Scope.RESOURCE_FILE));
        try {
            projects = this.mRequest.getProjects();
            if (projects == null) {
                projects = this.computeProjects(this.mRequest.getFiles());
            }
        }
        catch (CircularDependencyException e) {
            this.mCurrentProject = e.getProject();
            if (this.mCurrentProject != null) {
                Location location = e.getLocation();
                File file = location != null ? location.getFile() : this.mCurrentProject.getDir();
                Context context = new Context(this, this.mCurrentProject, null, file);
                context.report(IssueRegistry.LINT_ERROR, e.getLocation(), e.getMessage(), null);
                this.mCurrentProject = null;
            }
            return;
        }
        if (projects.isEmpty()) {
            this.mClient.log(null, "No projects found for %1$s", this.mRequest.getFiles().toString());
            return;
        }
        if (this.mCanceled) {
            return;
        }
        this.registerCustomRules(projects);
        if (this.mScope == null) {
            this.mScope = Scope.infer(projects);
        }
        this.fireEvent(LintListener.EventType.STARTING, null);
        for (Project project : projects) {
            this.mPhase = 1;
            this.computeDetectors(project);
            if (this.mApplicableDetectors.isEmpty()) continue;
            this.checkProject(project);
            if (this.mCanceled) break;
            this.runExtraPhases(project);
        }
        this.fireEvent(this.mCanceled ? LintListener.EventType.CANCELED : LintListener.EventType.COMPLETED, null);
    }

    private void registerCustomRules(Collection<Project> projects) {
        HashSet jarFiles = Sets.newHashSet();
        for (Project project : projects) {
            jarFiles.addAll(this.mClient.findRuleJars(project));
        }
        jarFiles.addAll(this.mClient.findGlobalRuleJars());
        if (!jarFiles.isEmpty()) {
            ArrayList registries = Lists.newArrayListWithExpectedSize((int)jarFiles.size());
            registries.add(this.mRegistry);
            for (File jarFile : jarFiles) {
                try {
                    registries.add(JarFileIssueRegistry.get(this.mClient, jarFile));
                }
                catch (Throwable e) {
                    this.mClient.log(e, "Could not load custom rule jar file %1$s", jarFile);
                }
            }
            if (registries.size() > 1) {
                this.mRegistry = new CompositeIssueRegistry(registries);
            }
        }
    }

    private void runExtraPhases(Project project) {
        if (this.mRepeatingDetectors != null) {
            EnumSet<Scope> oldScope = this.mScope;
            do {
                ++this.mPhase;
                this.fireEvent(LintListener.EventType.NEW_PHASE, new Context(this, project, null, project.getDir()));
                if (this.mRepeatScope == null) {
                    this.mRepeatScope = Scope.ALL;
                }
                this.mScope = Scope.intersect(this.mScope, this.mRepeatScope);
                if (this.mScope.isEmpty()) break;
                this.computeRepeatingDetectors(this.mRepeatingDetectors, project);
                if (this.mApplicableDetectors.isEmpty()) continue;
                this.checkProject(project);
                if (this.mCanceled) break;
            } while (this.mPhase < 3 && this.mRepeatingDetectors != null);
            this.mScope = oldScope;
        }
    }

    private void computeRepeatingDetectors(List<Detector> detectors, Project project) {
        this.mCurrentFolderType = null;
        this.mCurrentVisitor = null;
        this.mCurrentXmlDetectors = null;
        this.mCurrentBinaryDetectors = null;
        List<Issue> issues = this.mRegistry.getIssues();
        ArrayListMultimap issueMap = ArrayListMultimap.create((int)issues.size(), (int)3);
        for (Issue issue : issues) {
            issueMap.put(issue.getImplementation().getDetectorClass(), (Object)issue);
        }
        HashMap detectorToScope = new HashMap();
        EnumMap<Scope, List<Detector>> scopeToDetectors = new EnumMap<Scope, List<Detector>>(Scope.class);
        ArrayList<? extends Detector> detectorList = new ArrayList<Detector>();
        Configuration configuration = project.getConfiguration();
        for (Detector detector : detectors) {
            Class<?> detectorClass = detector.getClass();
            Collection detectorIssues = issueMap.get(detectorClass);
            if (detectorIssues == null) continue;
            boolean add = false;
            for (Issue issue : detectorIssues) {
                if (!configuration.isEnabled(issue)) continue;
                add = true;
                Object s = (EnumSet)detectorToScope.get(detectorClass);
                EnumSet<Scope> issueScope = issue.getImplementation().getScope();
                if (s == null) {
                    detectorToScope.put(detectorClass, issueScope);
                    continue;
                }
                if (s.containsAll(issueScope)) continue;
                EnumSet<Scope> union = EnumSet.copyOf(s);
                union.addAll(issueScope);
                detectorToScope.put(detectorClass, union);
            }
            if (!add) continue;
            detectorList.add(detector);
            EnumSet union = (EnumSet)detectorToScope.get(detector.getClass());
            for (Object s : union) {
                ArrayList<Detector> list = (ArrayList<Detector>)scopeToDetectors.get(s);
                if (list == null) {
                    list = new ArrayList<Detector>();
                    scopeToDetectors.put((Scope)((Object)s), list);
                }
                list.add(detector);
            }
        }
        this.mApplicableDetectors = detectorList;
        this.mScopeDetectors = scopeToDetectors;
        this.mRepeatingDetectors = null;
        this.mRepeatScope = null;
        this.validateScopeList();
    }

    private void computeDetectors(@NonNull Project project) {
        this.mCurrentFolderType = null;
        this.mCurrentVisitor = null;
        Configuration configuration = project.getConfiguration();
        this.mScopeDetectors = new EnumMap<Scope, List<Detector>>(Scope.class);
        this.mApplicableDetectors = this.mRegistry.createDetectors(this.mClient, configuration, this.mScope, this.mScopeDetectors);
        this.validateScopeList();
    }

    private void validateScopeList() {
        boolean assertionsEnabled = false;
        if (!$assertionsDisabled) {
            assertionsEnabled = true;
            if (!true) {
                throw new AssertionError();
            }
        }
        if (assertionsEnabled) {
            List<Detector> binaryDetectors;
            List<Detector> dirDetectors;
            List<Detector> otherDetectors;
            List<Detector> gradleDetectors;
            List<Detector> classCodeDetectors;
            List<Detector> classDetectors;
            List<Detector> javaFileDetectors;
            List<Detector> javaCodeDetectors;
            List<Detector> manifestDetectors;
            List<Detector> resourceFileDetectors = this.mScopeDetectors.get((Object)Scope.RESOURCE_FILE);
            if (resourceFileDetectors != null) {
                for (Detector detector : resourceFileDetectors) {
                    assert (detector instanceof ResourceXmlDetector) : detector;
                }
            }
            if ((manifestDetectors = this.mScopeDetectors.get((Object)Scope.MANIFEST)) != null) {
                for (Detector detector : manifestDetectors) {
                    assert (detector instanceof Detector.XmlScanner) : detector;
                }
            }
            if ((javaCodeDetectors = this.mScopeDetectors.get((Object)Scope.ALL_JAVA_FILES)) != null) {
                for (Detector detector : javaCodeDetectors) {
                    assert (detector instanceof Detector.JavaScanner) : detector;
                }
            }
            if ((javaFileDetectors = this.mScopeDetectors.get((Object)Scope.JAVA_FILE)) != null) {
                for (Detector detector : javaFileDetectors) {
                    assert (detector instanceof Detector.JavaScanner) : detector;
                }
            }
            if ((classDetectors = this.mScopeDetectors.get((Object)Scope.CLASS_FILE)) != null) {
                for (Detector detector : classDetectors) {
                    assert (detector instanceof Detector.ClassScanner) : detector;
                }
            }
            if ((classCodeDetectors = this.mScopeDetectors.get((Object)Scope.ALL_CLASS_FILES)) != null) {
                for (Detector detector : classCodeDetectors) {
                    assert (detector instanceof Detector.ClassScanner) : detector;
                }
            }
            if ((gradleDetectors = this.mScopeDetectors.get((Object)Scope.GRADLE_FILE)) != null) {
                for (Detector detector : gradleDetectors) {
                    assert (detector instanceof Detector.GradleScanner) : detector;
                }
            }
            if ((otherDetectors = this.mScopeDetectors.get((Object)Scope.OTHER)) != null) {
                for (Detector detector : otherDetectors) {
                    assert (detector instanceof Detector.OtherFileScanner) : detector;
                }
            }
            if ((dirDetectors = this.mScopeDetectors.get((Object)Scope.RESOURCE_FOLDER)) != null) {
                for (Detector detector : dirDetectors) {
                    assert (detector instanceof Detector.ResourceFolderScanner) : detector;
                }
            }
            if ((binaryDetectors = this.mScopeDetectors.get((Object)Scope.BINARY_RESOURCE_FILE)) != null) {
                for (Detector detector : binaryDetectors) {
                    assert (detector instanceof Detector.BinaryResourceScanner) : detector;
                }
            }
        }
    }

    private void registerProjectFile(@NonNull Map<File, Project> fileToProject, @NonNull File file, @NonNull File projectDir, @NonNull File rootDir) {
        fileToProject.put(file, this.mClient.getProject(projectDir, rootDir));
    }

    private Collection<Project> computeProjects(@NonNull List<File> files) {
        LinkedHashMap<File, Project> fileToProject = new LinkedHashMap<File, Project>();
        File sharedRoot = null;
        if (files.size() > 1) {
            ArrayList<File> absolute = new ArrayList<File>(files.size());
            for (File file : files) {
                absolute.add(file.getAbsoluteFile());
            }
            files = absolute;
            sharedRoot = LintUtils.getCommonParent(files);
            if (sharedRoot != null && sharedRoot.getParentFile() == null) {
                sharedRoot = null;
            }
        }
        for (File file : files) {
            if (file.isDirectory()) {
                File rootDir = sharedRoot;
                if (rootDir == null) {
                    rootDir = file;
                    if (files.size() > 1 && (rootDir = file.getParentFile()) == null) {
                        rootDir = file;
                    }
                }
                if (this.mClient.isProjectDirectory(file)) {
                    this.registerProjectFile(fileToProject, file, file, rootDir);
                    continue;
                }
                File parent = file.getParentFile();
                if (parent != null) {
                    if (this.mClient.isProjectDirectory(parent)) {
                        this.registerProjectFile(fileToProject, file, parent, parent);
                        continue;
                    }
                    if ((parent = parent.getParentFile()) != null && this.mClient.isProjectDirectory(parent)) {
                        this.registerProjectFile(fileToProject, file, parent, parent);
                        continue;
                    }
                }
                this.addProjects(file, fileToProject, rootDir);
            } else {
                for (File parent = file.getParentFile(); parent != null; parent = parent.getParentFile()) {
                    if (!this.mClient.isProjectDirectory(parent)) continue;
                    this.registerProjectFile(fileToProject, file, parent, parent);
                    break;
                }
            }
            if (!this.mCanceled) continue;
            return Collections.emptySet();
        }
        for (Map.Entry entry : fileToProject.entrySet()) {
            Project project;
            File file;
            file = (File)entry.getKey();
            if (file.equals((project = (Project)entry.getValue()).getDir())) continue;
            if (file.isDirectory()) {
                try {
                    File dir = file.getCanonicalFile();
                    if (dir.equals(project.getDir())) {
                        continue;
                    }
                }
                catch (IOException ioe) {
                    // empty catch block
                }
            }
            project.addFile(file);
        }
        Collection allProjects = fileToProject.values();
        HashSet<Project> hashSet = new HashSet<Project>(allProjects);
        for (Project project : allProjects) {
            hashSet.removeAll(project.getAllLibraries());
        }
        for (Project project : allProjects) {
            project.setReportIssues(true);
        }
        if (LintUtils.assertionsEnabled()) {
            IdentityHashMap<Project, Project> projects = new IdentityHashMap<Project, Project>();
            for (Project project : hashSet) {
                projects.put(project, project);
                for (Project library : project.getAllLibraries()) {
                    projects.put(library, library);
                }
            }
            HashSet<File> dirs = new HashSet<File>();
            for (Project project : projects.keySet()) {
                assert (!dirs.contains(project.getDir()));
                dirs.add(project.getDir());
            }
        }
        return hashSet;
    }

    private void addProjects(@NonNull File dir, @NonNull Map<File, Project> fileToProject, @NonNull File rootDir) {
        if (this.mCanceled) {
            return;
        }
        if (this.mClient.isProjectDirectory(dir)) {
            this.registerProjectFile(fileToProject, dir, dir, rootDir);
        } else {
            File[] files = dir.listFiles();
            if (files != null) {
                for (File file : files) {
                    if (!file.isDirectory()) continue;
                    this.addProjects(file, fileToProject, rootDir);
                }
            }
        }
    }

    private void checkProject(@NonNull Project project) {
        File projectDir = project.getDir();
        Context projectContext = new Context(this, project, null, projectDir);
        this.fireEvent(LintListener.EventType.SCANNING_PROJECT, projectContext);
        List<Project> allLibraries = project.getAllLibraries();
        HashSet<Project> allProjects = new HashSet<Project>(allLibraries.size() + 1);
        allProjects.add(project);
        allProjects.addAll(allLibraries);
        this.mCurrentProjects = allProjects.toArray(new Project[allProjects.size()]);
        this.mCurrentProject = project;
        for (Detector detector : this.mApplicableDetectors) {
            detector.beforeCheckProject(projectContext);
            if (!this.mCanceled) continue;
            return;
        }
        assert (this.mCurrentProject == project);
        this.runFileDetectors(project, project);
        if (!Scope.checkSingleFile(this.mScope)) {
            List<Project> libraries = project.getAllLibraries();
            for (Project library : libraries) {
                Context libraryContext = new Context(this, library, project, projectDir);
                this.fireEvent(LintListener.EventType.SCANNING_LIBRARY_PROJECT, libraryContext);
                this.mCurrentProject = library;
                for (Detector detector : this.mApplicableDetectors) {
                    detector.beforeCheckLibraryProject(libraryContext);
                    if (!this.mCanceled) continue;
                    return;
                }
                assert (this.mCurrentProject == library);
                this.runFileDetectors(library, project);
                if (this.mCanceled) {
                    return;
                }
                assert (this.mCurrentProject == library);
                for (Detector detector : this.mApplicableDetectors) {
                    detector.afterCheckLibraryProject(libraryContext);
                    if (!this.mCanceled) continue;
                    return;
                }
            }
        }
        this.mCurrentProject = project;
        for (Detector detector : this.mApplicableDetectors) {
            detector.afterCheckProject(projectContext);
            if (!this.mCanceled) continue;
            return;
        }
        if (this.mCanceled) {
            this.mClient.report(projectContext, IssueRegistry.CANCELLED, Severity.INFORMATIONAL, null, "Lint canceled by user", null);
        }
        this.mCurrentProjects = null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void runFileDetectors(@NonNull Project project, @Nullable Project main) {
        List<Detector> checks;
        if (project.isAndroidProject()) {
            for (File manifestFile : project.getManifestFiles()) {
                XmlParser parser = this.mClient.getXmlParser();
                if (parser == null) continue;
                XmlContext context = new XmlContext(this, project, main, manifestFile, null, parser);
                context.document = parser.parseXml(context);
                if (context.document == null) continue;
                try {
                    List<Detector> detectors;
                    project.readManifest(context.document);
                    if (project.isLibrary() && (main == null || !main.isMergingManifests()) || !this.mScope.contains((Object)Scope.MANIFEST) || (detectors = this.mScopeDetectors.get((Object)Scope.MANIFEST)) == null) continue;
                    ResourceVisitor v = new ResourceVisitor(parser, detectors, null);
                    this.fireEvent(LintListener.EventType.SCANNING_FILE, context);
                    v.visitFile(context, manifestFile);
                }
                finally {
                    if (context.document == null) continue;
                    parser.dispose(context, context.document);
                }
            }
            if (this.mScope.contains((Object)Scope.ALL_RESOURCE_FILES) || this.mScope.contains((Object)Scope.RESOURCE_FILE) || this.mScope.contains((Object)Scope.RESOURCE_FOLDER) || this.mScope.contains((Object)Scope.BINARY_RESOURCE_FILE)) {
                List<ResourceXmlDetector> xmlDetectors;
                boolean haveXmlChecks;
                List<Detector> dirChecks = this.mScopeDetectors.get((Object)Scope.RESOURCE_FOLDER);
                List<Detector> binaryChecks = this.mScopeDetectors.get((Object)Scope.BINARY_RESOURCE_FILE);
                List<Detector> checks2 = LintDriver.union(this.mScopeDetectors.get((Object)Scope.RESOURCE_FILE), this.mScopeDetectors.get((Object)Scope.ALL_RESOURCE_FILES));
                boolean bl = haveXmlChecks = checks2 != null && !checks2.isEmpty();
                if (haveXmlChecks) {
                    xmlDetectors = new ArrayList(checks2.size());
                    for (Detector detector : checks2) {
                        if (!(detector instanceof ResourceXmlDetector)) continue;
                        xmlDetectors.add((ResourceXmlDetector)detector);
                    }
                    haveXmlChecks = !xmlDetectors.isEmpty();
                } else {
                    xmlDetectors = Collections.emptyList();
                }
                if (haveXmlChecks || dirChecks != null && !dirChecks.isEmpty() || binaryChecks != null && !binaryChecks.isEmpty()) {
                    List<File> files = project.getSubset();
                    if (files != null) {
                        this.checkIndividualResources(project, main, xmlDetectors, dirChecks, binaryChecks, files);
                    } else {
                        List<File> resourceFolders = project.getResourceFolders();
                        if (!resourceFolders.isEmpty()) {
                            for (File res : resourceFolders) {
                                this.checkResFolder(project, main, res, xmlDetectors, dirChecks, binaryChecks);
                            }
                        }
                    }
                }
            }
            if (this.mCanceled) {
                return;
            }
        }
        if ((this.mScope.contains((Object)Scope.JAVA_FILE) || this.mScope.contains((Object)Scope.ALL_JAVA_FILES)) && (checks = LintDriver.union(this.mScopeDetectors.get((Object)Scope.JAVA_FILE), this.mScopeDetectors.get((Object)Scope.ALL_JAVA_FILES))) != null && !checks.isEmpty()) {
            List<File> files = project.getSubset();
            if (files != null) {
                this.checkIndividualJavaFiles(project, main, checks, files);
            } else {
                List<File> sourceFolders = project.getJavaSourceFolders();
                this.checkJava(project, main, sourceFolders, checks);
            }
        }
        if (this.mCanceled) {
            return;
        }
        if (this.mScope.contains((Object)Scope.CLASS_FILE) || this.mScope.contains((Object)Scope.ALL_CLASS_FILES) || this.mScope.contains((Object)Scope.JAVA_LIBRARIES)) {
            this.checkClasses(project, main);
        }
        if (this.mCanceled) {
            return;
        }
        if (this.mScope.contains((Object)Scope.GRADLE_FILE)) {
            this.checkBuildScripts(project, main);
        }
        if (this.mCanceled) {
            return;
        }
        if (this.mScope.contains((Object)Scope.OTHER) && (checks = this.mScopeDetectors.get((Object)Scope.OTHER)) != null) {
            OtherFileVisitor visitor = new OtherFileVisitor(checks);
            visitor.scan(this, project, main);
        }
        if (this.mCanceled) {
            return;
        }
        if (project == main && this.mScope.contains((Object)Scope.PROGUARD_FILE) && project.isAndroidProject()) {
            this.checkProGuard(project, main);
        }
        if (project == main && this.mScope.contains((Object)Scope.PROPERTY_FILE) && project.isAndroidProject()) {
            this.checkProperties(project, main);
        }
    }

    private void checkBuildScripts(Project project, Project main) {
        List<Detector> detectors = this.mScopeDetectors.get((Object)Scope.GRADLE_FILE);
        if (detectors != null) {
            List<File> files = project.getSubset();
            if (files == null) {
                files = project.getGradleBuildScripts();
            }
            for (File file : files) {
                Context context = new Context(this, project, main, file);
                this.fireEvent(LintListener.EventType.SCANNING_FILE, context);
                for (Detector detector : detectors) {
                    if (!detector.appliesTo(context, file)) continue;
                    detector.beforeCheckFile(context);
                    detector.visitBuildScript(context, Maps.newHashMap());
                    detector.afterCheckFile(context);
                }
            }
        }
    }

    private void checkProGuard(Project project, Project main) {
        List<Detector> detectors = this.mScopeDetectors.get((Object)Scope.PROGUARD_FILE);
        if (detectors != null) {
            List<File> files = project.getProguardFiles();
            for (File file : files) {
                Context context = new Context(this, project, main, file);
                this.fireEvent(LintListener.EventType.SCANNING_FILE, context);
                for (Detector detector : detectors) {
                    if (!detector.appliesTo(context, file)) continue;
                    detector.beforeCheckFile(context);
                    detector.run(context);
                    detector.afterCheckFile(context);
                }
            }
        }
    }

    private void checkProperties(Project project, Project main) {
        File file;
        List<Detector> detectors = this.mScopeDetectors.get((Object)Scope.PROPERTY_FILE);
        if (detectors != null && (file = new File(project.getDir(), "local.properties")).exists()) {
            Context context = new Context(this, project, main, file);
            this.fireEvent(LintListener.EventType.SCANNING_FILE, context);
            for (Detector detector : detectors) {
                if (!detector.appliesTo(context, file)) continue;
                detector.beforeCheckFile(context);
                detector.run(context);
                detector.afterCheckFile(context);
            }
        }
    }

    boolean isCanceled() {
        return this.mCanceled;
    }

    @Nullable
    public String getSuperClass(@NonNull String name) {
        if (this.mSuperClassMap == null) {
            throw new IllegalStateException("Only callable during ClassScanner#checkClass");
        }
        assert (name.indexOf(46) == -1) : "Use VM signatures, e.g. java/lang/Integer";
        String superClass = this.mSuperClassMap.get(name);
        if (superClass == null && this.mCurrentProject != null) {
            if ("java/lang/Object".equals(name)) {
                return null;
            }
            superClass = this.mClient.getSuperClass(this.mCurrentProject, name);
            if (superClass != null) {
                this.mSuperClassMap.put(name, superClass);
            }
        }
        return superClass;
    }

    public boolean isSubclassOf(@NonNull ClassNode classNode, @NonNull String superClassName) {
        Boolean isSub;
        if (superClassName.equals(classNode.superName)) {
            return true;
        }
        if (this.mCurrentProject != null && (isSub = this.mClient.isSubclassOf(this.mCurrentProject, classNode.name, superClassName)) != null) {
            return isSub;
        }
        String className = classNode.name;
        while (className != null) {
            if (className.equals(superClassName)) {
                return true;
            }
            className = this.getSuperClass(className);
        }
        return false;
    }

    @Nullable
    private static List<Detector> union(@Nullable List<Detector> list1, @Nullable List<Detector> list2) {
        if (list1 == null) {
            return list2;
        }
        if (list2 == null) {
            return list1;
        }
        HashSet<Detector> set = new HashSet<Detector>(list1.size() + list2.size());
        set.addAll(list1);
        set.addAll(list2);
        return new ArrayList<Detector>(set);
    }

    private void checkClasses(Project project, Project main) {
        List<ClassEntry> classEntries;
        List<ClassEntry> libraryEntries;
        List<File> files = project.getSubset();
        if (files != null) {
            this.checkIndividualClassFiles(project, main, files);
            return;
        }
        List<File> libraries = project.getJavaLibraries();
        if (!libraries.isEmpty()) {
            libraryEntries = new ArrayList(64);
            this.findClasses(libraryEntries, libraries);
            Collections.sort(libraryEntries);
        } else {
            libraryEntries = Collections.emptyList();
        }
        List<File> classFolders = project.getJavaClassFolders();
        if (classFolders.isEmpty()) {
            String message = String.format("No .class files were found in project \"%1$s\", so none of the classfile based checks could be run. Does the project need to be built first?", project.getName());
            Location location = Location.create(project.getDir());
            this.mClient.report(new Context(this, project, main, project.getDir()), IssueRegistry.LINT_ERROR, project.getConfiguration().getSeverity(IssueRegistry.LINT_ERROR), location, message, null);
            classEntries = Collections.emptyList();
        } else {
            classEntries = new ArrayList<ClassEntry>(64);
            this.findClasses(classEntries, classFolders);
            Collections.sort(classEntries);
        }
        if (this.getPhase() == 1) {
            this.mSuperClassMap = this.getSuperMap(libraryEntries, classEntries);
        }
        this.runClassDetectors(Scope.JAVA_LIBRARIES, libraryEntries, project, main);
        if (this.mCanceled) {
            return;
        }
        this.runClassDetectors(Scope.CLASS_FILE, classEntries, project, main);
        this.runClassDetectors(Scope.ALL_CLASS_FILES, classEntries, project, main);
    }

    private void checkIndividualClassFiles(@NonNull Project project, @Nullable Project main, @NonNull List<File> files) {
        ArrayList<ClassEntry> entries = new ArrayList<ClassEntry>(files.size());
        List<File> classFolders = project.getJavaClassFolders();
        if (!classFolders.isEmpty()) {
            for (File file : files) {
                String path = file.getPath();
                if (!file.isFile() || !path.endsWith(".class")) continue;
                try {
                    byte[] bytes = this.mClient.readBytes(file);
                    for (File dir : classFolders) {
                        if (!path.startsWith(dir.getPath())) continue;
                        entries.add(new ClassEntry(file, null, dir, bytes));
                        break;
                    }
                }
                catch (IOException e) {
                    this.mClient.log(e, null, new Object[0]);
                    continue;
                }
                if (!this.mCanceled) continue;
                return;
            }
            if (!entries.isEmpty()) {
                Collections.sort(entries);
                this.mSuperClassMap = Maps.newHashMap();
                this.runClassDetectors(Scope.CLASS_FILE, entries, project, main);
            }
        }
    }

    private void runClassDetectors(Scope scope, List<ClassEntry> entries, Project project, Project main) {
        List<Detector> classDetectors;
        if (this.mScope.contains((Object)scope) && (classDetectors = this.mScopeDetectors.get((Object)scope)) != null && !classDetectors.isEmpty() && !entries.isEmpty()) {
            AsmVisitor visitor = new AsmVisitor(this.mClient, classDetectors);
            String sourceContents = null;
            String sourceName = "";
            this.mOuterClasses = new ArrayDeque<ClassNode>();
            ClassEntry prev = null;
            for (ClassEntry entry : entries) {
                ClassNode peek;
                ClassNode classNode;
                if (prev != null && prev.compareTo(entry) == 0) continue;
                prev = entry;
                try {
                    ClassReader reader = new ClassReader(entry.bytes);
                    classNode = new ClassNode();
                    reader.accept((ClassVisitor)classNode, 0);
                }
                catch (Throwable t) {
                    this.mClient.log(null, "Error processing %1$s: broken class file?", entry.path());
                    continue;
                }
                while ((peek = this.mOuterClasses.peek()) != null && !classNode.name.startsWith(peek.name)) {
                    this.mOuterClasses.pop();
                }
                this.mOuterClasses.push(classNode);
                if (this.isSuppressed(null, classNode)) continue;
                if (sourceContents != null) {
                    int oldRootLength;
                    String newName = classNode.name;
                    int newRootLength = newName.indexOf(36);
                    if (newRootLength == -1) {
                        newRootLength = newName.length();
                    }
                    if ((oldRootLength = sourceName.indexOf(36)) == -1) {
                        oldRootLength = sourceName.length();
                    }
                    if (newRootLength != oldRootLength || !sourceName.regionMatches(0, newName, 0, newRootLength)) {
                        sourceContents = null;
                    }
                }
                ClassContext context = new ClassContext(this, project, main, entry.file, entry.jarFile, entry.binDir, entry.bytes, classNode, scope == Scope.JAVA_LIBRARIES, sourceContents);
                try {
                    visitor.runClassDetectors(context);
                }
                catch (Exception e) {
                    this.mClient.log(e, null, new Object[0]);
                }
                if (this.mCanceled) {
                    return;
                }
                sourceContents = context.getSourceContents(false);
                sourceName = classNode.name;
            }
            this.mOuterClasses = null;
        }
    }

    public ClassNode getOuterClassNode(@NonNull ClassNode classNode) {
        String outerName = classNode.outerClass;
        Iterator<ClassNode> iterator = this.mOuterClasses.iterator();
        while (iterator.hasNext()) {
            ClassNode node = iterator.next();
            if (outerName != null) {
                if (!node.name.equals(outerName)) continue;
                return node;
            }
            if (node != classNode) continue;
            return iterator.hasNext() ? iterator.next() : null;
        }
        return null;
    }

    private Map<String, String> getSuperMap(List<ClassEntry> libraryEntries, List<ClassEntry> classEntries) {
        int size = libraryEntries.size() + classEntries.size();
        HashMap<String, String> map = new HashMap<String, String>(size);
        SuperclassVisitor visitor = new SuperclassVisitor(map);
        this.addSuperClasses(visitor, libraryEntries);
        this.addSuperClasses(visitor, classEntries);
        return map;
    }

    private void addSuperClasses(SuperclassVisitor visitor, List<ClassEntry> entries) {
        for (ClassEntry entry : entries) {
            try {
                ClassReader reader = new ClassReader(entry.bytes);
                int flags = 7;
                reader.accept((ClassVisitor)visitor, flags);
            }
            catch (Throwable t) {
                this.mClient.log(null, "Error processing %1$s: broken class file?", entry.path());
            }
        }
    }

    @Nullable
    public ClassNode findClass(@NonNull ClassContext context, @NonNull String type, int flags) {
        String relative = type.replace('/', File.separatorChar) + ".class";
        File classFile = this.findClassFile(context.getProject(), relative);
        if (classFile != null) {
            if (classFile.getPath().endsWith(".jar")) {
                return null;
            }
            try {
                byte[] bytes = this.mClient.readBytes(classFile);
                ClassReader reader = new ClassReader(bytes);
                ClassNode classNode = new ClassNode();
                reader.accept((ClassVisitor)classNode, flags);
                return classNode;
            }
            catch (Throwable t) {
                this.mClient.log(null, "Error processing %1$s: broken class file?", classFile.getPath());
            }
        }
        return null;
    }

    @Nullable
    private File findClassFile(@NonNull Project project, String relativePath) {
        File path;
        for (File root : this.mClient.getJavaClassFolders(project)) {
            path = new File(root, relativePath);
            if (!path.exists()) continue;
            return path;
        }
        for (File root : this.mClient.getJavaLibraries(project)) {
            path = new File(root, relativePath);
            if (!path.exists()) continue;
            return path;
        }
        for (Project library : project.getDirectLibraries()) {
            path = this.findClassFile(library, relativePath);
            if (path == null) continue;
            return path;
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void findClasses(@NonNull List<ClassEntry> entries, @NonNull List<File> classPath) {
        i$ = classPath.iterator();
        block9: while (true) {
            block16: {
                if (!i$.hasNext()) {
                    return;
                }
                classPathEntry = i$.next();
                if (!classPathEntry.getName().endsWith(".jar")) break block16;
                jarFile = classPathEntry;
                if (!jarFile.exists()) continue;
                zis = null;
                try {
                    fis = new FileInputStream(jarFile);
                    zis = new ZipInputStream(fis);
                    entry = zis.getNextEntry();
lbl14:
                    // 3 sources

                    while (entry != null) {
                        block15: {
                            name = entry.getName();
                            if (name.endsWith(".class")) {
                                try {
                                    bytes = ByteStreams.toByteArray((InputStream)zis);
                                    if (bytes == null) break block15;
                                    file = new File(entry.getName());
                                    entries.add(new ClassEntry(file, jarFile, jarFile, bytes));
                                }
                                catch (Exception e) {
                                    this.mClient.log(e, null, new Object[0]);
                                    continue;
                                }
                            }
                        }
                        if (!this.mCanceled) ** GOTO lbl-1000
                        ** GOTO lbl38
                    }
                    ** GOTO lbl42
                }
                catch (IOException e) {
                    try {
                        this.mClient.log(e, "Could not read jar file contents from %1$s", new Object[]{jarFile});
                    }
                    catch (Throwable var12_15) {
                        Closeables.closeQuietly(zis);
                        throw var12_15;
                    }
lbl38:
                    // 1 sources

                    Closeables.closeQuietly((Closeable)zis);
                    return;
lbl-1000:
                    // 1 sources

                    {
                        entry = zis.getNextEntry();
                        ** GOTO lbl14
                    }
lbl42:
                    // 1 sources

                    Closeables.closeQuietly((Closeable)zis);
                    continue;
                    Closeables.closeQuietly((Closeable)zis);
                    continue;
                }
            }
            if (classPathEntry.isDirectory()) {
                binDir = classPathEntry;
                classFiles = new ArrayList<File>();
                LintDriver.addClassFiles(binDir, classFiles);
                i$ = classFiles.iterator();
                while (true) {
                    if (!i$.hasNext()) continue block9;
                    file = (File)i$.next();
                    try {
                        bytes = this.mClient.readBytes(file);
                        entries.add(new ClassEntry(file, null, binDir, bytes));
                    }
                    catch (IOException e) {
                        this.mClient.log(e, null, new Object[0]);
                        continue;
                    }
                    if (this.mCanceled) break;
                }
                return;
            }
            this.mClient.log(null, "Ignoring class path entry %1$s", new Object[]{classPathEntry});
        }
    }

    private static void addClassFiles(@NonNull File dir, @NonNull List<File> classFiles) {
        File[] files = dir.listFiles();
        if (files != null && files.length > 0) {
            for (File file : files) {
                if (file.isFile() && file.getName().endsWith(".class")) {
                    classFiles.add(file);
                    continue;
                }
                if (!file.isDirectory()) continue;
                LintDriver.addClassFiles(file, classFiles);
            }
        }
    }

    private void checkJava(@NonNull Project project, @Nullable Project main, @NonNull List<File> sourceFolders, @NonNull List<Detector> checks) {
        JavaParser javaParser = this.mClient.getJavaParser(project);
        if (javaParser == null) {
            this.mClient.log(null, "No java parser provided to lint: not running Java checks", new Object[0]);
            return;
        }
        assert (!checks.isEmpty());
        ArrayList<File> sources = new ArrayList<File>(100);
        for (File folder : sourceFolders) {
            LintDriver.gatherJavaFiles(folder, sources);
        }
        if (!sources.isEmpty()) {
            JavaVisitor visitor = new JavaVisitor(javaParser, checks);
            ArrayList contexts = Lists.newArrayListWithExpectedSize((int)sources.size());
            for (File file : sources) {
                JavaContext context = new JavaContext(this, project, main, file, javaParser);
                contexts.add(context);
            }
            visitor.prepare(contexts);
            for (JavaContext context : contexts) {
                this.fireEvent(LintListener.EventType.SCANNING_FILE, context);
                visitor.visitFile(context);
                if (!this.mCanceled) continue;
                return;
            }
        }
    }

    private void checkIndividualJavaFiles(@NonNull Project project, @Nullable Project main, @NonNull List<Detector> checks, @NonNull List<File> files) {
        JavaParser javaParser = this.mClient.getJavaParser(project);
        if (javaParser == null) {
            this.mClient.log(null, "No java parser provided to lint: not running Java checks", new Object[0]);
            return;
        }
        JavaVisitor visitor = new JavaVisitor(javaParser, checks);
        ArrayList contexts = Lists.newArrayListWithExpectedSize((int)files.size());
        for (File file : files) {
            if (!file.isFile() || !file.getPath().endsWith(".java")) continue;
            contexts.add(new JavaContext(this, project, main, file, javaParser));
        }
        if (contexts.isEmpty()) {
            return;
        }
        visitor.prepare(contexts);
        if (this.mCanceled) {
            return;
        }
        for (JavaContext context : contexts) {
            this.fireEvent(LintListener.EventType.SCANNING_FILE, context);
            visitor.visitFile(context);
            if (!this.mCanceled) continue;
            return;
        }
    }

    private static void gatherJavaFiles(@NonNull File dir, @NonNull List<File> result) {
        File[] files = dir.listFiles();
        if (files != null) {
            for (File file : files) {
                if (file.isFile() && file.getName().endsWith(".java")) {
                    result.add(file);
                    continue;
                }
                if (!file.isDirectory()) continue;
                LintDriver.gatherJavaFiles(file, result);
            }
        }
    }

    @Nullable
    private ResourceVisitor getVisitor(@NonNull ResourceFolderType type, @NonNull List<ResourceXmlDetector> checks, @Nullable List<Detector> binaryChecks) {
        if (type != this.mCurrentFolderType) {
            this.mCurrentFolderType = type;
            ArrayList<ResourceXmlDetector> applicableXmlChecks = new ArrayList<ResourceXmlDetector>(checks.size());
            for (ResourceXmlDetector check : checks) {
                if (!check.appliesTo(type)) continue;
                applicableXmlChecks.add(check);
            }
            ArrayList<Detector> applicableBinaryChecks = null;
            if (binaryChecks != null) {
                applicableBinaryChecks = new ArrayList<Detector>(binaryChecks.size());
                for (Detector check : binaryChecks) {
                    if (!check.appliesTo(type)) continue;
                    applicableBinaryChecks.add(check);
                }
            }
            if (this.mCurrentXmlDetectors != null && ((Object)this.mCurrentXmlDetectors).equals(applicableXmlChecks) && Objects.equal(this.mCurrentBinaryDetectors, applicableBinaryChecks)) {
                return this.mCurrentVisitor;
            }
            this.mCurrentXmlDetectors = applicableXmlChecks;
            this.mCurrentBinaryDetectors = applicableBinaryChecks;
            if (applicableXmlChecks.isEmpty() && (applicableBinaryChecks == null || applicableBinaryChecks.isEmpty())) {
                this.mCurrentVisitor = null;
                return null;
            }
            XmlParser parser = this.mClient.getXmlParser();
            this.mCurrentVisitor = parser != null ? new ResourceVisitor(parser, applicableXmlChecks, applicableBinaryChecks) : null;
        }
        return this.mCurrentVisitor;
    }

    private void checkResFolder(@NonNull Project project, @Nullable Project main, @NonNull File res, @NonNull List<ResourceXmlDetector> xmlChecks, @Nullable List<Detector> dirChecks, @Nullable List<Detector> binaryChecks) {
        assert (res.isDirectory()) : res;
        Object[] resourceDirs = res.listFiles();
        if (resourceDirs == null) {
            return;
        }
        Arrays.sort(resourceDirs);
        for (Object dir : resourceDirs) {
            ResourceFolderType type = ResourceFolderType.getFolderType((String)((File)dir).getName());
            if (type != null) {
                this.checkResourceFolder(project, main, (File)dir, type, xmlChecks, dirChecks, binaryChecks);
            }
            if (!this.mCanceled) continue;
            return;
        }
    }

    private void checkResourceFolder(@NonNull Project project, @Nullable Project main, @NonNull File dir, @NonNull ResourceFolderType type, @NonNull List<ResourceXmlDetector> xmlChecks, @Nullable List<Detector> dirChecks, @Nullable List<Detector> binaryChecks) {
        Object[] files;
        if (dirChecks != null && !dirChecks.isEmpty()) {
            ResourceContext context = new ResourceContext(this, project, main, dir, type);
            String folderName = dir.getName();
            this.fireEvent(LintListener.EventType.SCANNING_FILE, context);
            for (Detector check : dirChecks) {
                if (!check.appliesTo(type)) continue;
                check.beforeCheckFile(context);
                check.checkFolder(context, folderName);
                check.afterCheckFile(context);
            }
            if (binaryChecks == null && xmlChecks.isEmpty()) {
                return;
            }
        }
        if ((files = dir.listFiles()) == null || files.length <= 0) {
            return;
        }
        ResourceVisitor visitor = this.getVisitor(type, xmlChecks, binaryChecks);
        if (visitor != null) {
            Arrays.sort(files);
            for (Object file : files) {
                ResourceContext context;
                if (LintUtils.isXmlFile((File)file)) {
                    context = new XmlContext(this, project, main, (File)file, type, visitor.getParser());
                    this.fireEvent(LintListener.EventType.SCANNING_FILE, context);
                    visitor.visitFile((XmlContext)context, (File)file);
                } else if (binaryChecks != null && LintUtils.isBitmapFile((File)file)) {
                    context = new ResourceContext(this, project, main, (File)file, type);
                    this.fireEvent(LintListener.EventType.SCANNING_FILE, context);
                    visitor.visitBinaryResource(context);
                }
                if (!this.mCanceled) continue;
                return;
            }
        }
    }

    private void checkIndividualResources(@NonNull Project project, @Nullable Project main, @NonNull List<ResourceXmlDetector> xmlDetectors, @Nullable List<Detector> dirChecks, @Nullable List<Detector> binaryChecks, @NonNull List<File> files) {
        for (File file : files) {
            ResourceContext context;
            ResourceVisitor visitor;
            ResourceFolderType type;
            String folderName;
            if (file.isDirectory()) {
                ResourceFolderType type2 = ResourceFolderType.getFolderType((String)file.getName());
                if (type2 != null && new File(file.getParentFile(), "res").exists()) {
                    this.checkResourceFolder(project, main, file, type2, xmlDetectors, dirChecks, binaryChecks);
                    continue;
                }
                if (file.getName().equals("res")) {
                    this.checkResFolder(project, main, file, xmlDetectors, dirChecks, binaryChecks);
                    continue;
                }
                this.mClient.log(null, "Unexpected folder %1$s; should be project, \"res\" folder or resource folder", file.getPath());
                continue;
            }
            if (file.isFile() && LintUtils.isXmlFile(file)) {
                folderName = file.getParentFile().getName();
                type = ResourceFolderType.getFolderType((String)folderName);
                if (type == null || (visitor = this.getVisitor(type, xmlDetectors, binaryChecks)) == null) continue;
                context = new XmlContext(this, project, main, file, type, visitor.getParser());
                this.fireEvent(LintListener.EventType.SCANNING_FILE, context);
                visitor.visitFile((XmlContext)context, file);
                continue;
            }
            if (binaryChecks == null || !file.isFile() || !LintUtils.isBitmapFile(file) || (type = ResourceFolderType.getFolderType((String)(folderName = file.getParentFile().getName()))) == null || (visitor = this.getVisitor(type, xmlDetectors, binaryChecks)) == null) continue;
            context = new ResourceContext(this, project, main, file, type);
            this.fireEvent(LintListener.EventType.SCANNING_FILE, context);
            visitor.visitBinaryResource(context);
            if (!this.mCanceled) continue;
            return;
        }
    }

    public void addLintListener(@NonNull LintListener listener) {
        if (this.mListeners == null) {
            this.mListeners = new ArrayList<LintListener>(1);
        }
        this.mListeners.add(listener);
    }

    public void removeLintListener(@NonNull LintListener listener) {
        this.mListeners.remove(listener);
        if (this.mListeners.isEmpty()) {
            this.mListeners = null;
        }
    }

    private void fireEvent(@NonNull LintListener.EventType type, @Nullable Context context) {
        if (this.mListeners != null) {
            for (LintListener listener : this.mListeners) {
                listener.update(this, type, context);
            }
        }
    }

    public void requestRepeat(@NonNull Detector detector, @Nullable EnumSet<Scope> scope) {
        if (this.mRepeatingDetectors == null) {
            this.mRepeatingDetectors = new ArrayList<Detector>();
        }
        this.mRepeatingDetectors.add(detector);
        if (scope != null) {
            if (this.mRepeatScope == null) {
                this.mRepeatScope = scope;
            } else {
                this.mRepeatScope = EnumSet.copyOf(this.mRepeatScope);
                this.mRepeatScope.addAll(scope);
            }
        } else {
            this.mRepeatScope = Scope.ALL;
        }
    }

    public boolean isSuppressed(@Nullable Issue issue, @NonNull ClassNode classNode, @NonNull MethodNode method, @Nullable AbstractInsnNode instruction) {
        if (method.invisibleAnnotations != null) {
            List annotations = method.invisibleAnnotations;
            return LintDriver.isSuppressed(issue, annotations);
        }
        if (instruction != null && method.name.charAt(0) == '<') {
            AbstractInsnNode next = LintUtils.getNextInstruction(instruction);
            if (next != null && next.getType() == 4) {
                FieldInsnNode fieldRef = (FieldInsnNode)next;
                FieldNode field = this.findField(classNode, fieldRef.owner, fieldRef.name);
                if (field != null && this.isSuppressed(issue, field)) {
                    return true;
                }
            } else if (classNode.outerClass != null && classNode.outerMethod == null && LintUtils.isAnonymousClass(classNode) && this.isSuppressed(issue, classNode)) {
                return true;
            }
        }
        return false;
    }

    @Nullable
    private static MethodInsnNode findConstructorInvocation(@NonNull MethodNode method, @NonNull String className) {
        InsnList nodes = method.instructions;
        int n = nodes.size();
        for (int i = 0; i < n; ++i) {
            AbstractInsnNode instruction = nodes.get(i);
            if (instruction.getOpcode() != 183) continue;
            MethodInsnNode call = (MethodInsnNode)instruction;
            if (!className.equals(call.owner)) continue;
            return call;
        }
        return null;
    }

    @Nullable
    private FieldNode findField(@NonNull ClassNode classNode, @NonNull String owner, @NonNull String name) {
        ClassNode current = classNode;
        while (current != null) {
            if (owner.equals(current.name)) {
                List fieldList = current.fields;
                for (Object f : fieldList) {
                    FieldNode field = (FieldNode)f;
                    if (!field.name.equals(name)) continue;
                    return field;
                }
                return null;
            }
            current = this.getOuterClassNode(current);
        }
        return null;
    }

    @Nullable
    private MethodNode findMethod(@NonNull ClassNode classNode, @NonNull String name, boolean includeInherited) {
        ClassNode current = classNode;
        while (current != null) {
            List methodList = current.methods;
            for (Object f : methodList) {
                MethodNode method = (MethodNode)f;
                if (!method.name.equals(name)) continue;
                return method;
            }
            if (!includeInherited) break;
            current = this.getOuterClassNode(current);
        }
        return null;
    }

    public boolean isSuppressed(@Nullable Issue issue, @NonNull FieldNode field) {
        if (field.invisibleAnnotations != null) {
            List annotations = field.invisibleAnnotations;
            return LintDriver.isSuppressed(issue, annotations);
        }
        return false;
    }

    public boolean isSuppressed(@Nullable Issue issue, @NonNull ClassNode classNode) {
        ClassNode outer;
        if (classNode.invisibleAnnotations != null) {
            List annotations = classNode.invisibleAnnotations;
            return LintDriver.isSuppressed(issue, annotations);
        }
        if (classNode.outerClass != null && classNode.outerMethod == null && LintUtils.isAnonymousClass(classNode) && (outer = this.getOuterClassNode(classNode)) != null) {
            MethodInsnNode call;
            MethodNode m = this.findMethod(outer, "<init>", false);
            if (m != null && (call = LintDriver.findConstructorInvocation(m, classNode.name)) != null && this.isSuppressed(issue, outer, m, (AbstractInsnNode)call)) {
                return true;
            }
            m = this.findMethod(outer, "<clinit>", false);
            if (m != null && (call = LintDriver.findConstructorInvocation(m, classNode.name)) != null && this.isSuppressed(issue, outer, m, (AbstractInsnNode)call)) {
                return true;
            }
        }
        return false;
    }

    private static boolean isSuppressed(@Nullable Issue issue, List<AnnotationNode> annotations) {
        for (AnnotationNode annotation : annotations) {
            String desc = annotation.desc;
            if (!desc.endsWith(SUPPRESS_LINT_VMSIG) || annotation.values == null) continue;
            int n = annotation.values.size();
            for (int i = 0; i < n; i += 2) {
                String key = (String)annotation.values.get(i);
                if (!key.equals("value")) continue;
                Object value = annotation.values.get(i + 1);
                if (value instanceof String) {
                    String id = (String)value;
                    if (!LintDriver.matches(issue, id)) continue;
                    return true;
                }
                if (!(value instanceof List)) continue;
                List list = (List)value;
                for (Object v : list) {
                    String id;
                    if (!(v instanceof String) || !LintDriver.matches(issue, id = (String)v)) continue;
                    return true;
                }
            }
        }
        return false;
    }

    private static boolean matches(@Nullable Issue issue, @NonNull String id) {
        if (id.equalsIgnoreCase("all")) {
            return true;
        }
        if (issue != null) {
            String issueId = issue.getId();
            if (id.equalsIgnoreCase(issueId)) {
                return true;
            }
            if (id.startsWith(STUDIO_ID_PREFIX) && id.regionMatches(true, STUDIO_ID_PREFIX.length(), issueId, 0, issueId.length()) && id.substring(STUDIO_ID_PREFIX.length()).equalsIgnoreCase(issueId)) {
                return true;
            }
        }
        return false;
    }

    public boolean isSuppressed(@Nullable JavaContext context, @NonNull Issue issue, @Nullable Node scope) {
        boolean checkComments;
        boolean bl = checkComments = this.mClient.checkForSuppressComments() && context != null && context.containsCommentSuppress();
        while (scope != null) {
            VariableDefinition declaration;
            Class<?> type = scope.getClass();
            if (type == VariableDefinition.class ? LintDriver.isSuppressed(issue, (declaration = (VariableDefinition)scope).astModifiers()) : (type == MethodDeclaration.class ? LintDriver.isSuppressed(issue, (declaration = (MethodDeclaration)scope).astModifiers()) : (type == ConstructorDeclaration.class ? LintDriver.isSuppressed(issue, (declaration = (ConstructorDeclaration)scope).astModifiers()) : type == ClassDeclaration.class && LintDriver.isSuppressed(issue, (declaration = (ClassDeclaration)scope).astModifiers())))) {
                return true;
            }
            if (checkComments && context.isSuppressedWithComment(scope, issue)) {
                return true;
            }
            scope = scope.getParent();
        }
        return false;
    }

    private static boolean isSuppressed(@Nullable Issue issue, @Nullable Modifiers modifiers) {
        if (modifiers == null) {
            return false;
        }
        StrictListAccessor annotations = modifiers.astAnnotations();
        if (annotations == null) {
            return false;
        }
        for (Annotation annotation : annotations) {
            StrictListAccessor values;
            TypeReference t = annotation.astAnnotationTypeReference();
            String typeName = t.getTypeName();
            if (!typeName.endsWith("SuppressLint") && !typeName.endsWith("SuppressWarnings") || (values = annotation.astElements()) == null) continue;
            for (AnnotationElement element : values) {
                ArrayInitializer array;
                StrictListAccessor expressions;
                AnnotationValue valueNode = element.astValue();
                if (valueNode == null) continue;
                if (valueNode instanceof StringLiteral) {
                    StringLiteral literal = (StringLiteral)valueNode;
                    String value = literal.astValue();
                    if (!LintDriver.matches(issue, value)) continue;
                    return true;
                }
                if (!(valueNode instanceof ArrayInitializer) || (expressions = (array = (ArrayInitializer)valueNode).astExpressions()) == null) continue;
                for (Expression arrayElement : expressions) {
                    String value;
                    if (!(arrayElement instanceof StringLiteral) || !LintDriver.matches(issue, value = ((StringLiteral)arrayElement).astValue())) continue;
                    return true;
                }
            }
        }
        return false;
    }

    public boolean isSuppressed(@Nullable XmlContext context, @NonNull Issue issue, @Nullable org.w3c.dom.Node node) {
        boolean checkComments;
        if (node instanceof Attr) {
            node = ((Attr)node).getOwnerElement();
        }
        boolean bl = checkComments = this.mClient.checkForSuppressComments() && context != null && context.containsCommentSuppress();
        while (node != null) {
            if (node.getNodeType() == 1) {
                Element element = (Element)node;
                if (element.hasAttributeNS("http://schemas.android.com/tools", "ignore")) {
                    String ignore = element.getAttributeNS("http://schemas.android.com/tools", "ignore");
                    if (ignore.indexOf(44) == -1) {
                        if (LintDriver.matches(issue, ignore)) {
                            return true;
                        }
                    } else {
                        for (String id : ignore.split(",")) {
                            if (!LintDriver.matches(issue, id)) continue;
                            return true;
                        }
                    }
                } else if (checkComments && context.isSuppressedWithComment(node, issue)) {
                    return true;
                }
            }
            node = node.getParentNode();
        }
        return false;
    }

    static class ClassEntry
    implements Comparable<ClassEntry> {
        public final File file;
        public final File jarFile;
        public final File binDir;
        public final byte[] bytes;

        public ClassEntry(File file, File jarFile, File binDir, byte[] bytes) {
            this.file = file;
            this.jarFile = jarFile;
            this.binDir = binDir;
            this.bytes = bytes;
        }

        public String path() {
            if (this.jarFile != null) {
                return this.jarFile.getPath() + ':' + this.file.getPath();
            }
            return this.file.getPath();
        }

        @Override
        public int compareTo(@NonNull ClassEntry other) {
            int m2;
            String p1 = this.file.getPath();
            String p2 = other.file.getPath();
            int m1 = p1.length();
            if (m1 == (m2 = p2.length()) && p1.equals(p2)) {
                return 0;
            }
            int m = Math.min(m1, m2);
            for (int i = 0; i < m; ++i) {
                char c2;
                char c1 = p1.charAt(i);
                if (c1 == (c2 = p2.charAt(i))) continue;
                if (c1 == '.' && c2 == '$') {
                    return -1;
                }
                if (c1 == '$' && c2 == '.') {
                    return 1;
                }
                return c1 - c2;
            }
            return m == m1 ? -1 : 1;
        }

        public String toString() {
            return this.file.getPath();
        }
    }

    private class LintClientWrapper
    extends LintClient {
        @NonNull
        private final LintClient mDelegate;

        public LintClientWrapper(LintClient delegate) {
            this.mDelegate = delegate;
        }

        @Override
        public void report(@NonNull Context context, @NonNull Issue issue, @NonNull Severity severity, @Nullable Location location, @NonNull String message, @Nullable Object data) {
            assert (LintDriver.this.mCurrentProject != null);
            if (!LintDriver.this.mCurrentProject.getReportIssues()) {
                return;
            }
            Configuration configuration = context.getConfiguration();
            if (!configuration.isEnabled(issue)) {
                if (issue != IssueRegistry.PARSER_ERROR && issue != IssueRegistry.LINT_ERROR) {
                    this.mDelegate.log(null, "Incorrect detector reported disabled issue %1$s", issue.toString());
                }
                return;
            }
            if (configuration.isIgnored(context, issue, location, message, data)) {
                return;
            }
            if (severity == Severity.IGNORE) {
                return;
            }
            this.mDelegate.report(context, issue, severity, location, message, data);
        }

        @Override
        @NonNull
        public Configuration getConfiguration(@NonNull Project project) {
            return this.mDelegate.getConfiguration(project);
        }

        @Override
        public void log(@NonNull Severity severity, @Nullable Throwable exception, @Nullable String format, Object ... args) {
            this.mDelegate.log(exception, format, args);
        }

        @Override
        @NonNull
        public String readFile(@NonNull File file) {
            return this.mDelegate.readFile(file);
        }

        @Override
        @NonNull
        public byte[] readBytes(@NonNull File file) throws IOException {
            return this.mDelegate.readBytes(file);
        }

        @Override
        @NonNull
        public List<File> getJavaSourceFolders(@NonNull Project project) {
            return this.mDelegate.getJavaSourceFolders(project);
        }

        @Override
        @NonNull
        public List<File> getJavaClassFolders(@NonNull Project project) {
            return this.mDelegate.getJavaClassFolders(project);
        }

        @Override
        @NonNull
        public List<File> getJavaLibraries(@NonNull Project project) {
            return this.mDelegate.getJavaLibraries(project);
        }

        @Override
        @NonNull
        public List<File> getResourceFolders(@NonNull Project project) {
            return this.mDelegate.getResourceFolders(project);
        }

        @Override
        @Nullable
        public XmlParser getXmlParser() {
            return this.mDelegate.getXmlParser();
        }

        @Override
        @NonNull
        public Class<? extends Detector> replaceDetector(@NonNull Class<? extends Detector> detectorClass) {
            return this.mDelegate.replaceDetector(detectorClass);
        }

        @Override
        @NonNull
        public SdkInfo getSdkInfo(@NonNull Project project) {
            return this.mDelegate.getSdkInfo(project);
        }

        @Override
        @NonNull
        public Project getProject(@NonNull File dir, @NonNull File referenceDir) {
            return this.mDelegate.getProject(dir, referenceDir);
        }

        @Override
        @Nullable
        public JavaParser getJavaParser(@Nullable Project project) {
            return this.mDelegate.getJavaParser(project);
        }

        @Override
        public File findResource(@NonNull String relativePath) {
            return this.mDelegate.findResource(relativePath);
        }

        @Override
        @Nullable
        public File getCacheDir(boolean create) {
            return this.mDelegate.getCacheDir(create);
        }

        @Override
        @NonNull
        protected LintClient.ClassPathInfo getClassPath(@NonNull Project project) {
            return this.mDelegate.getClassPath(project);
        }

        @Override
        public void log(@Nullable Throwable exception, @Nullable String format, Object ... args) {
            this.mDelegate.log(exception, format, args);
        }

        @Override
        @Nullable
        public File getSdkHome() {
            return this.mDelegate.getSdkHome();
        }

        @Override
        @NonNull
        public IAndroidTarget[] getTargets() {
            return this.mDelegate.getTargets();
        }

        @Override
        @Nullable
        public LocalSdk getSdk() {
            return this.mDelegate.getSdk();
        }

        @Override
        @Nullable
        public IAndroidTarget getCompileTarget(@NonNull Project project) {
            return this.mDelegate.getCompileTarget(project);
        }

        @Override
        public int getHighestKnownApiLevel() {
            return this.mDelegate.getHighestKnownApiLevel();
        }

        @Override
        @Nullable
        public String getSuperClass(@NonNull Project project, @NonNull String name) {
            return this.mDelegate.getSuperClass(project, name);
        }

        @Override
        @Nullable
        public Boolean isSubclassOf(@NonNull Project project, @NonNull String name, @NonNull String superClassName) {
            return this.mDelegate.isSubclassOf(project, name, superClassName);
        }

        @Override
        @NonNull
        public String getProjectName(@NonNull Project project) {
            return this.mDelegate.getProjectName(project);
        }

        @Override
        public boolean isGradleProject(Project project) {
            return this.mDelegate.isGradleProject(project);
        }

        @Override
        @NonNull
        protected Project createProject(@NonNull File dir, @NonNull File referenceDir) {
            return this.mDelegate.createProject(dir, referenceDir);
        }

        @Override
        @NonNull
        public List<File> findGlobalRuleJars() {
            return this.mDelegate.findGlobalRuleJars();
        }

        @Override
        @NonNull
        public List<File> findRuleJars(@NonNull Project project) {
            return this.mDelegate.findRuleJars(project);
        }

        @Override
        public boolean isProjectDirectory(@NonNull File dir) {
            return this.mDelegate.isProjectDirectory(dir);
        }

        @Override
        public void registerProject(@NonNull File dir, @NonNull Project project) {
            this.log(Severity.WARNING, null, "Too late to register projects", new Object[0]);
            this.mDelegate.registerProject(dir, project);
        }

        @Override
        public IssueRegistry addCustomLintRules(@NonNull IssueRegistry registry) {
            return this.mDelegate.addCustomLintRules(registry);
        }

        @Override
        public boolean checkForSuppressComments() {
            return this.mDelegate.checkForSuppressComments();
        }

        @Override
        public boolean supportsProjectResources() {
            return this.mDelegate.supportsProjectResources();
        }

        @Override
        @Nullable
        public AbstractResourceRepository getProjectResources(Project project, boolean includeDependencies) {
            return this.mDelegate.getProjectResources(project, includeDependencies);
        }

        @Override
        @NonNull
        public Location.Handle createResourceItemHandle(@NonNull ResourceItem item) {
            return this.mDelegate.createResourceItemHandle(item);
        }

        @Override
        @Nullable
        public URLConnection openConnection(@NonNull URL url) throws IOException {
            return this.mDelegate.openConnection(url);
        }

        @Override
        public void closeConnection(@NonNull URLConnection connection) throws IOException {
            this.mDelegate.closeConnection(connection);
        }
    }

    private static class SuperclassVisitor
    extends ClassVisitor {
        private final Map<String, String> mMap;

        public SuperclassVisitor(Map<String, String> map) {
            super(262144);
            this.mMap = map;
        }

        public void visit(int version, int access, String name, String signature, String superName, String[] interfaces) {
            if (superName != null) {
                this.mMap.put(name, superName);
            }
        }
    }
}

