/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.lint.detector.api;

import com.android.annotations.NonNull;
import com.android.annotations.Nullable;
import com.android.resources.ResourceFolderType;
import com.android.tools.lint.client.api.LintDriver;
import com.android.tools.lint.detector.api.Context;
import com.android.tools.lint.detector.api.Project;
import com.google.common.annotations.Beta;
import com.google.common.base.Splitter;
import java.io.File;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

@Beta
public class ResourceContext
extends Context {
    private final ResourceFolderType mFolderType;
    private static final Pattern VERSION_PATTERN = Pattern.compile("^v(\\d+)$");
    private static File sCachedFolder = null;
    private static int sCachedFolderVersion = -1;

    public ResourceContext(@NonNull LintDriver driver, @NonNull Project project, @Nullable Project main, @NonNull File file, @Nullable ResourceFolderType folderType) {
        super(driver, project, main, file);
        this.mFolderType = folderType;
    }

    @Nullable
    public ResourceFolderType getResourceFolderType() {
        return this.mFolderType;
    }

    public int getFolderVersion() {
        return ResourceContext.getFolderVersion(this.file);
    }

    public static int getFolderVersion(File file) {
        File parent = file.getParentFile();
        if (parent.equals(sCachedFolder)) {
            return sCachedFolderVersion;
        }
        sCachedFolder = parent;
        sCachedFolderVersion = -1;
        for (String qualifier : Splitter.on((char)'-').split((CharSequence)parent.getName())) {
            Matcher matcher = VERSION_PATTERN.matcher(qualifier);
            if (!matcher.matches()) continue;
            sCachedFolderVersion = Integer.parseInt(matcher.group(1));
            break;
        }
        return sCachedFolderVersion;
    }
}

