/*
 * Decompiled with CFR 0.152.
 */
package org.python.objectweb.asm.commons;

import org.python.objectweb.asm.commons.Remapper;
import org.python.objectweb.asm.signature.SignatureVisitor;

public class RemappingSignatureAdapter
implements SignatureVisitor {
    private final SignatureVisitor v;
    private final Remapper remapper;
    private String className;

    public RemappingSignatureAdapter(SignatureVisitor signatureVisitor, Remapper remapper) {
        this.v = signatureVisitor;
        this.remapper = remapper;
    }

    public void visitClassType(String string2) {
        this.className = string2;
        this.v.visitClassType(this.remapper.mapType(string2));
    }

    public void visitInnerClassType(String string2) {
        this.className = this.className + '$' + string2;
        String string3 = this.remapper.mapType(this.className);
        this.v.visitInnerClassType(string3.substring(string3.lastIndexOf(36) + 1));
    }

    public void visitFormalTypeParameter(String string2) {
        this.v.visitFormalTypeParameter(string2);
    }

    public void visitTypeVariable(String string2) {
        this.v.visitTypeVariable(string2);
    }

    public SignatureVisitor visitArrayType() {
        this.v.visitArrayType();
        return this;
    }

    public void visitBaseType(char c) {
        this.v.visitBaseType(c);
    }

    public SignatureVisitor visitClassBound() {
        this.v.visitClassBound();
        return this;
    }

    public SignatureVisitor visitExceptionType() {
        this.v.visitExceptionType();
        return this;
    }

    public SignatureVisitor visitInterface() {
        this.v.visitInterface();
        return this;
    }

    public SignatureVisitor visitInterfaceBound() {
        this.v.visitInterfaceBound();
        return this;
    }

    public SignatureVisitor visitParameterType() {
        this.v.visitParameterType();
        return this;
    }

    public SignatureVisitor visitReturnType() {
        this.v.visitReturnType();
        return this;
    }

    public SignatureVisitor visitSuperclass() {
        this.v.visitSuperclass();
        return this;
    }

    public void visitTypeArgument() {
        this.v.visitTypeArgument();
    }

    public SignatureVisitor visitTypeArgument(char c) {
        this.v.visitTypeArgument(c);
        return this;
    }

    public void visitEnd() {
        this.v.visitEnd();
    }
}

