/*
 * Decompiled with CFR 0.152.
 */
package com.android.sdkuilib.internal.repository.ui;

import com.android.prefs.AndroidLocation;
import com.android.sdklib.devices.DeviceManager;
import com.android.sdklib.internal.avd.AvdInfo;
import com.android.sdklib.internal.avd.AvdManager;
import com.android.sdklib.repository.ISdkChangeListener;
import com.android.sdkuilib.internal.repository.SwtUpdaterData;
import com.android.sdkuilib.internal.widgets.AvdSelector;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;

public class AvdManagerPage
extends Composite
implements ISdkChangeListener,
DeviceManager.DevicesChangedListener,
DisposeListener {
    private AvdSelector mAvdSelector;
    private final SwtUpdaterData mSwtUpdaterData;
    private final DeviceManager mDeviceManager;

    public AvdManagerPage(Composite parent, int swtStyle, SwtUpdaterData swtUpdaterData, DeviceManager deviceManager) {
        super(parent, swtStyle);
        this.mSwtUpdaterData = swtUpdaterData;
        this.mSwtUpdaterData.addListeners(this);
        this.mDeviceManager = deviceManager;
        this.mDeviceManager.registerListener(this);
        this.createContents(this);
        this.postCreate();
    }

    private void createContents(Composite parent) {
        parent.setLayout((Layout)new GridLayout(1, false));
        Label label = new Label(parent, 0);
        label.setLayoutData((Object)new GridData());
        try {
            if (this.mSwtUpdaterData != null && this.mSwtUpdaterData.getAvdManager() != null) {
                label.setText(String.format("List of existing Android Virtual Devices located at %s", this.mSwtUpdaterData.getAvdManager().getBaseAvdFolder()));
            } else {
                label.setText("Error: cannot find the AVD folder location.\r\n Please set the 'ANDROID_SDK_HOME' env variable.");
            }
        }
        catch (AndroidLocation.AndroidLocationException e) {
            label.setText(e.getMessage());
        }
        this.mAvdSelector = new AvdSelector(parent, this.mSwtUpdaterData.getOsSdkRoot(), this.mSwtUpdaterData.getAvdManager(), AvdSelector.DisplayMode.MANAGER, this.mSwtUpdaterData.getSdkLog());
        this.mAvdSelector.setSettingsController(this.mSwtUpdaterData.getSettingsController());
    }

    public void widgetDisposed(DisposeEvent e) {
        this.dispose();
    }

    public void dispose() {
        this.mSwtUpdaterData.removeListener(this);
        this.mDeviceManager.unregisterListener(this);
        super.dispose();
    }

    protected void checkSubclass() {
    }

    public void selectAvd(AvdInfo avdInfo, boolean reloadAvdList) {
        if (reloadAvdList) {
            this.mAvdSelector.refresh(true);
            AvdManager am = this.mSwtUpdaterData.getAvdManager();
            avdInfo = am.getAvd(avdInfo.getName(), false);
        }
        this.mAvdSelector.setSelection(avdInfo);
    }

    private void postCreate() {
    }

    @Override
    public void onSdkLoaded() {
        this.onSdkReload();
    }

    @Override
    public void onSdkReload() {
        this.mAvdSelector.refresh(false);
    }

    @Override
    public void preInstallHook() {
    }

    @Override
    public void postInstallHook() {
    }

    @Override
    public void onDevicesChanged() {
        this.mAvdSelector.refresh(false);
    }
}

