/*
 * Decompiled with CFR 0.152.
 */
package com.android.sdkuilib.internal.repository.ui;

import com.android.SdkConstants;
import com.android.sdklib.internal.repository.ITaskFactory;
import com.android.sdklib.internal.repository.sources.SdkSourceProperties;
import com.android.sdklib.internal.repository.updater.SettingsController;
import com.android.sdklib.repository.ISdkChangeListener;
import com.android.sdkuilib.internal.repository.AboutDialog;
import com.android.sdkuilib.internal.repository.ISdkUpdaterWindow;
import com.android.sdkuilib.internal.repository.MenuBarWrapper;
import com.android.sdkuilib.internal.repository.SettingsDialog;
import com.android.sdkuilib.internal.repository.SwtUpdaterData;
import com.android.sdkuilib.internal.repository.icons.ImageFactory;
import com.android.sdkuilib.internal.repository.ui.AvdManagerWindowImpl1;
import com.android.sdkuilib.internal.repository.ui.LogWindow;
import com.android.sdkuilib.internal.repository.ui.PackagesPage;
import com.android.sdkuilib.internal.repository.ui.ShellSizeAndPos;
import com.android.sdkuilib.internal.tasks.ILogUiProvider;
import com.android.sdkuilib.internal.tasks.ProgressView;
import com.android.sdkuilib.internal.tasks.ProgressViewFactory;
import com.android.sdkuilib.internal.widgets.ImgDisabledButton;
import com.android.sdkuilib.internal.widgets.ToggleButton;
import com.android.sdkuilib.repository.AvdManagerWindow;
import com.android.sdkuilib.repository.SdkUpdaterWindow;
import com.android.utils.ILogger;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Decorations;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.MenuItem;
import org.eclipse.swt.widgets.ProgressBar;
import org.eclipse.swt.widgets.Shell;

public class SdkUpdaterWindowImpl2
implements ISdkUpdaterWindow {
    public static final String APP_NAME = "Android SDK Manager";
    private static final String SIZE_POS_PREFIX = "sdkman2";
    private final Shell mParentShell;
    private final SdkUpdaterWindow.SdkInvocationContext mContext;
    private final SwtUpdaterData mSwtUpdaterData;
    protected Shell mShell;
    private PackagesPage mPkgPage;
    private ProgressBar mProgressBar;
    private Label mStatusText;
    private ImgDisabledButton mButtonStop;
    private ToggleButton mButtonShowLog;
    private SettingsController mSettingsController;
    private LogWindow mLogWindow;

    public SdkUpdaterWindowImpl2(Shell parentShell, ILogger sdkLog, String osSdkRoot, SdkUpdaterWindow.SdkInvocationContext context) {
        this.mParentShell = parentShell;
        this.mContext = context;
        this.mSwtUpdaterData = new SwtUpdaterData(osSdkRoot, sdkLog);
    }

    public SdkUpdaterWindowImpl2(Shell parentShell, SwtUpdaterData swtUpdaterData, SdkUpdaterWindow.SdkInvocationContext context) {
        this.mParentShell = parentShell;
        this.mContext = context;
        this.mSwtUpdaterData = swtUpdaterData;
    }

    @Override
    public void open() {
        if (this.mParentShell == null) {
            Display.setAppName((String)APP_NAME);
        }
        this.createShell();
        this.preCreateContent();
        this.createContents();
        this.createMenuBar();
        this.createLogWindow();
        this.mShell.open();
        this.mShell.layout();
        if (this.postCreateContent()) {
            Display display = Display.getDefault();
            while (!this.mShell.isDisposed()) {
                if (display.readAndDispatch()) continue;
                display.sleep();
            }
        }
        SdkSourceProperties p = new SdkSourceProperties();
        p.save();
        this.dispose();
    }

    private void createShell() {
        int style = 1264;
        if (this.mContext != SdkUpdaterWindow.SdkInvocationContext.STANDALONE) {
            style |= 0x10000;
        }
        this.mShell = new Shell(this.mParentShell, style);
        this.mShell.addDisposeListener(new DisposeListener(){

            public void widgetDisposed(DisposeEvent e) {
                ShellSizeAndPos.saveSizeAndPos(SdkUpdaterWindowImpl2.this.mShell, SdkUpdaterWindowImpl2.SIZE_POS_PREFIX);
                SdkUpdaterWindowImpl2.this.onAndroidSdkUpdaterDispose();
            }
        });
        GridLayout glShell = new GridLayout(2, false);
        glShell.verticalSpacing = 0;
        glShell.horizontalSpacing = 0;
        glShell.marginWidth = 0;
        glShell.marginHeight = 0;
        this.mShell.setLayout((Layout)glShell);
        this.mShell.setMinimumSize(new Point(600, 300));
        this.mShell.setSize(700, 500);
        this.mShell.setText(APP_NAME);
        ShellSizeAndPos.loadSizeAndPos(this.mShell, SIZE_POS_PREFIX);
    }

    private void createContents() {
        this.mPkgPage = new PackagesPage((Composite)this.mShell, 0, this.mSwtUpdaterData, this.mContext);
        this.mPkgPage.setLayoutData(new GridData(4, 4, true, true, 2, 1));
        Composite composite1 = new Composite((Composite)this.mShell, 0);
        composite1.setLayout((Layout)new GridLayout(1, false));
        composite1.setLayoutData((Object)new GridData(4, 0x1000000, true, false, 1, 1));
        this.mProgressBar = new ProgressBar(composite1, 0);
        this.mProgressBar.setLayoutData((Object)new GridData(4, 0x1000000, true, false, 1, 1));
        this.mStatusText = new Label(composite1, 0);
        this.mStatusText.setText("Status Placeholder");
        this.mStatusText.setLayoutData((Object)new GridData(4, 0x1000000, true, false, 1, 1));
        Composite composite2 = new Composite((Composite)this.mShell, 0);
        composite2.setLayout((Layout)new GridLayout(2, false));
        this.mButtonStop = new ImgDisabledButton(composite2, 0, this.getImage("stop_enabled_16.png"), this.getImage("stop_disabled_16.png"), "Click to abort the current task", "");
        this.mButtonStop.addListener(13, new Listener(){

            public void handleEvent(Event event) {
                SdkUpdaterWindowImpl2.this.onStopSelected();
            }
        });
        this.mButtonShowLog = new ToggleButton(composite2, 0, this.getImage("log_off_16.png"), this.getImage("log_on_16.png"), "Click to show the log window", "Click to hide the log window");
        this.mButtonShowLog.addListener(13, new Listener(){

            public void handleEvent(Event event) {
                SdkUpdaterWindowImpl2.this.onToggleLogWindow();
            }
        });
    }

    private void createMenuBar() {
        Menu menuBar = new Menu((Decorations)this.mShell, 2);
        this.mShell.setMenuBar(menuBar);
        MenuItem menuBarPackages = new MenuItem(menuBar, 64);
        menuBarPackages.setText("Packages");
        Menu menuPkgs = new Menu(menuBarPackages);
        menuBarPackages.setMenu(menuPkgs);
        MenuItem showUpdatesNew = new MenuItem(menuPkgs, PackagesPage.MenuAction.TOGGLE_SHOW_UPDATE_NEW_PKG.getMenuStyle());
        showUpdatesNew.setText(PackagesPage.MenuAction.TOGGLE_SHOW_UPDATE_NEW_PKG.getMenuTitle());
        this.mPkgPage.registerMenuAction(PackagesPage.MenuAction.TOGGLE_SHOW_UPDATE_NEW_PKG, showUpdatesNew);
        MenuItem showInstalled = new MenuItem(menuPkgs, PackagesPage.MenuAction.TOGGLE_SHOW_INSTALLED_PKG.getMenuStyle());
        showInstalled.setText(PackagesPage.MenuAction.TOGGLE_SHOW_INSTALLED_PKG.getMenuTitle());
        this.mPkgPage.registerMenuAction(PackagesPage.MenuAction.TOGGLE_SHOW_INSTALLED_PKG, showInstalled);
        MenuItem showObsoletePackages = new MenuItem(menuPkgs, PackagesPage.MenuAction.TOGGLE_SHOW_OBSOLETE_PKG.getMenuStyle());
        showObsoletePackages.setText(PackagesPage.MenuAction.TOGGLE_SHOW_OBSOLETE_PKG.getMenuTitle());
        this.mPkgPage.registerMenuAction(PackagesPage.MenuAction.TOGGLE_SHOW_OBSOLETE_PKG, showObsoletePackages);
        MenuItem showArchives = new MenuItem(menuPkgs, PackagesPage.MenuAction.TOGGLE_SHOW_ARCHIVES.getMenuStyle());
        showArchives.setText(PackagesPage.MenuAction.TOGGLE_SHOW_ARCHIVES.getMenuTitle());
        this.mPkgPage.registerMenuAction(PackagesPage.MenuAction.TOGGLE_SHOW_ARCHIVES, showArchives);
        new MenuItem(menuPkgs, 2);
        MenuItem sortByApi = new MenuItem(menuPkgs, PackagesPage.MenuAction.SORT_API_LEVEL.getMenuStyle());
        sortByApi.setText(PackagesPage.MenuAction.SORT_API_LEVEL.getMenuTitle());
        this.mPkgPage.registerMenuAction(PackagesPage.MenuAction.SORT_API_LEVEL, sortByApi);
        MenuItem sortBySource = new MenuItem(menuPkgs, PackagesPage.MenuAction.SORT_SOURCE.getMenuStyle());
        sortBySource.setText(PackagesPage.MenuAction.SORT_SOURCE.getMenuTitle());
        this.mPkgPage.registerMenuAction(PackagesPage.MenuAction.SORT_SOURCE, sortBySource);
        new MenuItem(menuPkgs, 2);
        MenuItem reload = new MenuItem(menuPkgs, PackagesPage.MenuAction.RELOAD.getMenuStyle());
        reload.setText(PackagesPage.MenuAction.RELOAD.getMenuTitle());
        this.mPkgPage.registerMenuAction(PackagesPage.MenuAction.RELOAD, reload);
        MenuItem menuBarTools = new MenuItem(menuBar, 64);
        menuBarTools.setText("Tools");
        Menu menuTools = new Menu(menuBarTools);
        menuBarTools.setMenu(menuTools);
        if (this.mContext == SdkUpdaterWindow.SdkInvocationContext.STANDALONE) {
            MenuItem manageAvds = new MenuItem(menuTools, 0);
            manageAvds.setText("Manage AVDs...");
            manageAvds.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent event) {
                    SdkUpdaterWindowImpl2.this.onAvdManager();
                }
            });
        }
        MenuItem manageSources = new MenuItem(menuTools, PackagesPage.MenuAction.SHOW_ADDON_SITES.getMenuStyle());
        manageSources.setText(PackagesPage.MenuAction.SHOW_ADDON_SITES.getMenuTitle());
        this.mPkgPage.registerMenuAction(PackagesPage.MenuAction.SHOW_ADDON_SITES, manageSources);
        if (this.mContext == SdkUpdaterWindow.SdkInvocationContext.STANDALONE || this.mContext == SdkUpdaterWindow.SdkInvocationContext.IDE) {
            try {
                new MenuBarWrapper(APP_NAME, menuTools){

                    @Override
                    public void onPreferencesMenuSelected() {
                        SettingsController.Settings settings1 = new SettingsController.Settings(SdkUpdaterWindowImpl2.this.mSettingsController.getSettings());
                        SettingsDialog sd = new SettingsDialog(SdkUpdaterWindowImpl2.this.mShell, SdkUpdaterWindowImpl2.this.mSwtUpdaterData);
                        sd.open();
                        SettingsController.Settings settings2 = SdkUpdaterWindowImpl2.this.mSettingsController.getSettings();
                        if (settings1.getForceHttp() != settings2.getForceHttp() || settings1.getEnablePreviews() != settings2.getEnablePreviews()) {
                            SdkUpdaterWindowImpl2.this.mPkgPage.onSdkReload();
                        }
                    }

                    @Override
                    public void onAboutMenuSelected() {
                        AboutDialog ad = new AboutDialog(SdkUpdaterWindowImpl2.this.mShell, SdkUpdaterWindowImpl2.this.mSwtUpdaterData);
                        ad.open();
                    }

                    @Override
                    public void printError(String format, Object ... args) {
                        if (SdkUpdaterWindowImpl2.this.mSwtUpdaterData != null) {
                            SdkUpdaterWindowImpl2.this.mSwtUpdaterData.getSdkLog().error(null, format, args);
                        }
                    }
                };
            }
            catch (Throwable e) {
                this.mSwtUpdaterData.getSdkLog().error(e, "Failed to setup menu bar", new Object[0]);
                e.printStackTrace();
            }
        }
    }

    private Image getImage(String filename) {
        ImageFactory imgFactory;
        if (this.mSwtUpdaterData != null && (imgFactory = this.mSwtUpdaterData.getImageFactory()) != null) {
            return imgFactory.getImageByName(filename);
        }
        return null;
    }

    private void createLogWindow() {
        this.mLogWindow = new LogWindow(this.mShell, this.mContext == SdkUpdaterWindow.SdkInvocationContext.IDE ? this.mSwtUpdaterData.getSdkLog() : null);
        this.mLogWindow.open();
    }

    @Override
    public void addListener(ISdkChangeListener listener) {
        this.mSwtUpdaterData.addListeners(listener);
    }

    @Override
    public void removeListener(ISdkChangeListener listener) {
        this.mSwtUpdaterData.removeListener(listener);
    }

    private void preCreateContent() {
        this.mSwtUpdaterData.setWindowShell(this.mShell);
        this.mSwtUpdaterData.setImageFactory(new ImageFactory(this.mShell.getDisplay()));
    }

    private boolean postCreateContent() {
        ProgressViewFactory factory = new ProgressViewFactory();
        ILogUiProvider logAdapter = new ILogUiProvider(){

            @Override
            public void setDescription(String description) {
                SdkUpdaterWindowImpl2.this.mLogWindow.setDescription(description);
            }

            @Override
            public void log(String log) {
                SdkUpdaterWindowImpl2.this.mLogWindow.log(log);
            }

            @Override
            public void logVerbose(String log) {
                SdkUpdaterWindowImpl2.this.mLogWindow.logVerbose(log);
            }

            @Override
            public void logError(String log) {
                SdkUpdaterWindowImpl2.this.mLogWindow.logError(log);
                if (SdkUpdaterWindowImpl2.this.mShell != null && !SdkUpdaterWindowImpl2.this.mShell.isDisposed()) {
                    SdkUpdaterWindowImpl2.this.mShell.getDisplay().syncExec(new Runnable(){

                        @Override
                        public void run() {
                            if (!SdkUpdaterWindowImpl2.this.mLogWindow.isVisible()) {
                                SdkUpdaterWindowImpl2.this.onToggleLogWindow();
                            }
                        }
                    });
                }
            }
        };
        factory.setProgressView(new ProgressView(this.mStatusText, this.mProgressBar, (Control)this.mButtonStop, logAdapter));
        this.mSwtUpdaterData.setTaskFactory(factory);
        this.setWindowImage(this.mShell);
        this.setupSources();
        this.initializeSettings();
        if (this.mSwtUpdaterData.checkIfInitFailed()) {
            return false;
        }
        this.mSwtUpdaterData.broadcastOnSdkLoaded();
        this.mPkgPage.performFirstLoad();
        return true;
    }

    private void setWindowImage(Shell shell) {
        ImageFactory imgFactory;
        String imageName = "android_icon_16.png";
        if (SdkConstants.currentPlatform() == 3) {
            imageName = "android_icon_128.png";
        }
        if (this.mSwtUpdaterData != null && (imgFactory = this.mSwtUpdaterData.getImageFactory()) != null) {
            shell.setImage(imgFactory.getImageByName(imageName));
        }
    }

    private void dispose() {
        this.mLogWindow.close();
        this.mSwtUpdaterData.getSources().saveUserAddons(this.mSwtUpdaterData.getSdkLog());
    }

    private void onAndroidSdkUpdaterDispose() {
        ImageFactory imgFactory;
        if (this.mSwtUpdaterData != null && (imgFactory = this.mSwtUpdaterData.getImageFactory()) != null) {
            imgFactory.dispose();
        }
    }

    private void setupSources() {
        this.mSwtUpdaterData.setupDefaultSources();
    }

    private void initializeSettings() {
        this.mSettingsController = this.mSwtUpdaterData.getSettingsController();
        this.mSettingsController.loadSettings();
        this.mSettingsController.applySettings();
    }

    private void onToggleLogWindow() {
        if (!this.mButtonShowLog.isDisposed()) {
            this.mLogWindow.setVisible(!this.mLogWindow.isVisible());
            this.mButtonShowLog.setState(this.mLogWindow.isVisible() ? 1 : 0);
        }
    }

    private void onStopSelected() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void onAvdManager() {
        ITaskFactory oldFactory = this.mSwtUpdaterData.getTaskFactory();
        try {
            AvdManagerWindowImpl1 win = new AvdManagerWindowImpl1(this.mShell, this.mSwtUpdaterData, AvdManagerWindow.AvdInvocationContext.DIALOG);
            win.open();
        }
        catch (Exception e) {
            this.mSwtUpdaterData.getSdkLog().error((Throwable)e, "AVD Manager window error", new Object[0]);
        }
        finally {
            this.mSwtUpdaterData.setTaskFactory(oldFactory);
        }
    }
}

