/*
 * Decompiled with CFR 0.152.
 */
package com.android.ide.eclipse.monitor;

import com.android.ide.eclipse.monitor.SdkToolsLocator;
import com.android.ide.eclipse.monitor.SwtUtils;
import java.io.File;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.DirectoryDialog;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;

public class SdkLocationChooserDialog
extends Dialog {
    private static final String TITLE = "Android Device Monitor";
    private static final String DEFAULT_MESSAGE = "Provide the path to the Android SDK";
    private Label mStatusLabel;
    private Text mTextBox;
    private String mPath;

    public SdkLocationChooserDialog(Shell parentShell) {
        super(parentShell);
    }

    protected Control createDialogArea(Composite parent) {
        this.getShell().setText(TITLE);
        Composite c = new Composite((Composite)super.createDialogArea(parent), 0);
        c.setLayout((Layout)new GridLayout(2, false));
        c.setLayoutData((Object)new GridData(1808));
        Label l = new Label(c, 0);
        l.setText(DEFAULT_MESSAGE);
        GridDataFactory.fillDefaults().span(2, 1).applyTo((Control)l);
        this.mTextBox = new Text(c, 2048);
        this.mTextBox.setLayoutData((Object)new GridData(768));
        GridDataFactory.fillDefaults().hint(SwtUtils.getFontWidth((Control)this.mTextBox) * 80, -1).applyTo((Control)this.mTextBox);
        this.mTextBox.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                SdkLocationChooserDialog.this.validateInstall();
            }
        });
        Button browse = new Button(c, 8);
        browse.setText("Browse");
        browse.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                DirectoryDialog dlg = new DirectoryDialog(SdkLocationChooserDialog.this.getShell(), 4096);
                dlg.setText("Android SDK location");
                String dir = dlg.open();
                if (dir != null) {
                    SdkLocationChooserDialog.this.mTextBox.setText(dir);
                    SdkLocationChooserDialog.this.validateInstall();
                }
            }
        });
        this.mStatusLabel = new Label(c, 64);
        this.mStatusLabel.setText("");
        this.mStatusLabel.setForeground(this.getShell().getDisplay().getSystemColor(3));
        GridDataFactory.fillDefaults().span(2, 1).applyTo((Control)this.mStatusLabel);
        return super.createDialogArea(parent);
    }

    private void validateInstall() {
        SdkToolsLocator locator = new SdkToolsLocator(new File(this.mTextBox.getText()));
        SdkToolsLocator.SdkInstallStatus status = locator.isValidInstallation();
        if (status.isValid()) {
            this.mStatusLabel.setText("");
            this.getButton(0).setEnabled(true);
        } else {
            this.mStatusLabel.setText(status.getErrorMessage());
            this.mStatusLabel.pack();
            this.getButton(0).setEnabled(false);
        }
    }

    public boolean close() {
        this.mPath = this.mTextBox.getText();
        return super.close();
    }

    public String getPath() {
        return this.mPath;
    }
}

