/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.cluster.impl.operations;

import com.hazelcast.cluster.impl.ClusterServiceImpl;
import com.hazelcast.cluster.impl.operations.AbstractClusterOperation;
import com.hazelcast.cluster.impl.operations.MemberRemoveOperation;
import com.hazelcast.instance.MemberImpl;
import com.hazelcast.logging.ILogger;
import com.hazelcast.nio.Address;
import com.hazelcast.nio.ObjectDataInput;
import com.hazelcast.nio.ObjectDataOutput;
import com.hazelcast.spi.OperationService;
import com.hazelcast.spi.impl.AllowedDuringPassiveState;
import java.io.IOException;

public class MasterConfirmationOperation
extends AbstractClusterOperation
implements AllowedDuringPassiveState {
    private long timestamp;

    public MasterConfirmationOperation() {
    }

    public MasterConfirmationOperation(long timestamp) {
        this.timestamp = timestamp;
    }

    @Override
    public void run() {
        Address endpoint = this.getCallerAddress();
        if (endpoint == null) {
            return;
        }
        ClusterServiceImpl clusterService = (ClusterServiceImpl)this.getService();
        ILogger logger = this.getLogger();
        MemberImpl member = clusterService.getMember(endpoint);
        if (member == null) {
            logger.warning("MasterConfirmation has been received from " + endpoint + ", but it is not a member of this cluster!");
            OperationService operationService = this.getNodeEngine().getOperationService();
            operationService.send(new MemberRemoveOperation(clusterService.getThisAddress()), endpoint);
        } else if (clusterService.isMaster()) {
            clusterService.getClusterHeartbeatManager().acceptMasterConfirmation(member, this.timestamp);
        } else {
            logger.warning(endpoint + " has sent MasterConfirmation, but this node is not master!");
        }
    }

    @Override
    protected void writeInternal(ObjectDataOutput out) throws IOException {
        super.writeInternal(out);
        out.writeLong(this.timestamp);
    }

    @Override
    protected void readInternal(ObjectDataInput in) throws IOException {
        super.readInternal(in);
        this.timestamp = in.readLong();
    }
}

