/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.topic.impl.client;

import com.hazelcast.client.ClientEndpoint;
import com.hazelcast.client.impl.client.BaseClientAddListenerRequest;
import com.hazelcast.core.Message;
import com.hazelcast.core.MessageListener;
import com.hazelcast.nio.serialization.Data;
import com.hazelcast.nio.serialization.PortableReader;
import com.hazelcast.nio.serialization.PortableWriter;
import com.hazelcast.security.permission.TopicPermission;
import com.hazelcast.topic.impl.DataAwareMessage;
import com.hazelcast.topic.impl.TopicPortableHook;
import com.hazelcast.topic.impl.TopicService;
import com.hazelcast.topic.impl.client.PortableMessage;
import java.io.IOException;
import java.security.Permission;

public class AddMessageListenerRequest
extends BaseClientAddListenerRequest {
    private String name;

    public AddMessageListenerRequest() {
    }

    public AddMessageListenerRequest(String name) {
        this.name = name;
    }

    public String call() throws Exception {
        TopicService service = (TopicService)this.getService();
        ClientEndpoint endpoint = this.getEndpoint();
        Object partitionKey = this.serializationService.toData(this.name);
        MessageListenerImpl listener = new MessageListenerImpl(endpoint, (Data)partitionKey, this.getCallId());
        String registrationId = service.addMessageListener(this.name, listener, this.localOnly);
        endpoint.addListenerDestroyAction("hz:impl:topicService", this.name, registrationId);
        return registrationId;
    }

    @Override
    public String getServiceName() {
        return "hz:impl:topicService";
    }

    @Override
    public int getFactoryId() {
        return TopicPortableHook.F_ID;
    }

    @Override
    public int getClassId() {
        return 2;
    }

    @Override
    public void write(PortableWriter writer) throws IOException {
        super.write(writer);
        writer.writeUTF("n", this.name);
    }

    @Override
    public void read(PortableReader reader) throws IOException {
        super.read(reader);
        this.name = reader.readUTF("n");
    }

    @Override
    public Permission getRequiredPermission() {
        return new TopicPermission(this.name, "listen");
    }

    @Override
    public String getDistributedObjectName() {
        return this.name;
    }

    @Override
    public String getMethodName() {
        return "addMessageListener";
    }

    @Override
    public Object[] getParameters() {
        return new Object[]{null};
    }

    private static class MessageListenerImpl
    implements MessageListener {
        private final ClientEndpoint endpoint;
        private final long callId;
        private final Data partitionKey;

        public MessageListenerImpl(ClientEndpoint endpoint, Data partitionKey, long callId) {
            this.endpoint = endpoint;
            this.partitionKey = partitionKey;
            this.callId = callId;
        }

        public void onMessage(Message message) {
            if (!this.endpoint.isAlive()) {
                return;
            }
            if (!(message instanceof DataAwareMessage)) {
                throw new IllegalArgumentException("Expecting: DataAwareMessage, Found: " + message.getClass().getSimpleName());
            }
            DataAwareMessage dataAwareMessage = (DataAwareMessage)message;
            Data messageData = dataAwareMessage.getMessageData();
            String publisherUuid = message.getPublishingMember().getUuid();
            PortableMessage portableMessage = new PortableMessage(messageData, message.getPublishTime(), publisherUuid);
            this.endpoint.sendEvent(this.partitionKey, portableMessage, this.callId);
        }
    }
}

