/*
 * Decompiled with CFR 0.152.
 */
package lombok.ast.grammar;

import lombok.ast.Node;
import lombok.ast.grammar.ParserGroup;
import lombok.ast.grammar.StatementsActions;
import org.parboiled.BaseParser;
import org.parboiled.Rule;

public class StatementsParser
extends BaseParser<Node> {
    final ParserGroup group;
    final StatementsActions actions;

    public StatementsParser(ParserGroup group) {
        this.actions = new StatementsActions(group.getSource());
        this.group = group;
    }

    public Rule anyStatement() {
        return this.Sequence(this.TestNot(this.Ch('}')), this.labelledStatement(), new Object[0]);
    }

    public Rule blockStatement() {
        return this.Sequence(this.Ch('{'), this.group.basics.optWS(), new Object[]{this.ZeroOrMore(this.anyStatement().label("statement")), this.Ch('}'), this.group.basics.optWS(), this.set(this.actions.createBlock(this.values("ZeroOrMore/statement")))});
    }

    public Rule localClassDeclaration() {
        return this.group.structures.classOrInterfaceDeclaration();
    }

    public Rule variableDefinition() {
        return this.Sequence(this.group.structures.variableDefinitionModifiers().label("modifiers"), this.group.structures.variableDefinition(), new Object[]{this.set(), this.set(this.actions.posify((Node)this.value())), this.set(this.actions.addLocalVariableModifiers((Node)this.value(), (Node)this.value("modifiers")))});
    }

    public Rule localVariableDeclaration() {
        return this.Sequence(this.variableDefinition().label("definition"), this.Ch(';'), new Object[]{this.group.basics.optWS(), this.set(this.actions.createVariableDeclaration((Node)this.value("definition")))});
    }

    public Rule explicitAlternateConstructorInvocation() {
        return this.Sequence(this.group.types.typeArguments().label("typeArgs"), this.String("this"), new Object[]{this.group.basics.testLexBreak(), this.group.basics.optWS(), this.group.structures.methodArguments().label("arguments"), this.Ch(';'), this.group.basics.optWS(), this.set(this.actions.createAlternateConstructorInvocation((Node)this.value("typeArgs"), (Node)this.value("arguments")))});
    }

    public Rule explicitSuperConstructorInvocation() {
        return this.Sequence(this.Optional(this.Sequence(this.group.expressions.allPrimaryExpressions(), this.Ch('.').label("dot"), new Object[]{this.group.basics.optWS()})).label("qualifier"), this.group.types.typeArguments().label("typeArgs"), new Object[]{this.String("super"), this.group.basics.testLexBreak(), this.group.basics.optWS(), this.group.structures.methodArguments().label("arguments"), this.Ch(';'), this.group.basics.optWS(), this.set(this.actions.createSuperConstructorInvocation((org.parboiled.Node<Node>)this.node("qualifier/Sequence/dot"), (Node)this.value("qualifier"), (Node)this.value("typeArgs"), (Node)this.value("arguments")))});
    }

    Rule emptyStatement() {
        return this.Sequence(this.Ch(';'), this.group.basics.optWS(), new Object[]{this.set(this.actions.createEmptyStatement())});
    }

    public Rule labelledStatement() {
        return this.Sequence(this.ZeroOrMore(this.Sequence(this.group.basics.identifier().label("labelName"), this.Ch(':'), new Object[]{this.group.basics.optWS()})), this.FirstOf(this.blockStatement(), this.localClassDeclaration(), new Object[]{this.localVariableDeclaration(), this.emptyStatement(), this.expressionStatement(), this.ifStatement(), this.assertStatement(), this.switchStatement(), this.caseStatement(), this.defaultStatement(), this.whileStatement(), this.doWhileStatement(), this.basicForStatement(), this.enhancedForStatement(), this.breakStatement(), this.continueStatement(), this.returnStatement(), this.synchronizedStatement(), this.throwStatement(), this.tryStatement(), this.explicitAlternateConstructorInvocation(), this.explicitSuperConstructorInvocation()}).label("statement"), new Object[]{this.set(this.actions.createLabelledStatement(this.values("ZeroOrMore/Sequence/labelName"), (Node)this.value("statement")))});
    }

    public Rule expressionStatement() {
        return this.Sequence(this.group.expressions.statementExpression().label("expression"), this.Ch(';'), new Object[]{this.group.basics.optWS(), this.set(this.actions.createExpressionStatement((Node)this.value("expression")))});
    }

    public Rule ifStatement() {
        return this.Sequence(this.String("if"), this.group.basics.testLexBreak(), new Object[]{this.group.basics.optWS(), this.Ch('('), this.group.basics.optWS(), this.group.expressions.anyExpression().label("condition"), this.Ch(')'), this.group.basics.optWS(), this.anyStatement(), this.set(), this.Optional(this.Sequence(this.String("else"), this.group.basics.testLexBreak(), new Object[]{this.group.basics.optWS(), this.anyStatement()}).label("else")), this.set(this.actions.createIfStatement((Node)this.value("condition"), (Node)this.value(), (Node)this.value("Optional/else")))});
    }

    public Rule assertStatement() {
        return this.Sequence(this.String("assert"), this.group.basics.testLexBreak(), new Object[]{this.group.basics.optWS(), this.group.expressions.anyExpression(), this.set(), this.Optional(this.Sequence(this.Ch(':'), this.group.basics.optWS(), new Object[]{this.group.expressions.anyExpression(), this.set()})), this.Ch(';'), this.group.basics.optWS(), this.set(this.actions.createAssertStatement((Node)this.value(), (Node)this.value("Optional/Sequence")))});
    }

    public Rule switchStatement() {
        return this.Sequence(this.String("switch"), this.group.basics.testLexBreak(), new Object[]{this.group.basics.optWS(), this.Ch('('), this.group.basics.optWS(), this.group.expressions.anyExpression(), this.set(), this.Ch(')'), this.group.basics.optWS(), this.blockStatement(), this.set(this.actions.createSwitchStatement((Node)this.value(), (Node)this.lastValue()))});
    }

    public Rule caseStatement() {
        return this.Sequence(this.String("case"), this.group.basics.testLexBreak(), new Object[]{this.group.basics.optWS(), this.group.expressions.anyExpression(), this.set(), this.Ch(':'), this.group.basics.optWS(), this.set(this.actions.createCaseStatement((Node)this.value()))});
    }

    public Rule defaultStatement() {
        return this.Sequence(this.String("default").label("defaultKeyword"), this.group.basics.testLexBreak(), new Object[]{this.group.basics.optWS(), this.Ch(':'), this.group.basics.optWS(), this.set(this.actions.createDefaultStatement((org.parboiled.Node<Node>)this.node("defaultKeyword")))});
    }

    public Rule whileStatement() {
        return this.Sequence(this.String("while"), this.group.basics.testLexBreak(), new Object[]{this.group.basics.optWS(), this.Ch('('), this.group.basics.optWS(), this.group.expressions.anyExpression().label("condition"), this.Ch(')'), this.group.basics.optWS(), this.anyStatement(), this.set(), this.set(this.actions.createWhileStatement((Node)this.value("condition"), (Node)this.value()))});
    }

    public Rule doWhileStatement() {
        return this.Sequence(this.String("do"), this.group.basics.testLexBreak(), new Object[]{this.group.basics.optWS(), this.anyStatement(), this.set(), this.String("while"), this.group.basics.testLexBreak(), this.group.basics.optWS(), this.Ch('('), this.group.basics.optWS(), this.group.expressions.anyExpression().label("condition"), this.Ch(')'), this.group.basics.optWS(), this.Ch(';'), this.group.basics.optWS(), this.set(this.actions.createDoStatement((Node)this.value("condition"), (Node)this.value()))});
    }

    public Rule basicForStatement() {
        return this.Sequence(this.String("for"), this.group.basics.testLexBreak(), new Object[]{this.group.basics.optWS(), this.Ch('('), this.group.basics.optWS(), this.forInit().label("init"), this.Ch(';'), this.group.basics.optWS(), this.Optional(this.group.expressions.anyExpression()).label("condition"), this.Ch(';'), this.group.basics.optWS(), this.forUpdate().label("update"), this.Ch(')'), this.group.basics.optWS(), this.anyStatement().label("statement"), this.set(this.actions.createBasicFor((Node)this.value("init"), (Node)this.value("condition"), (Node)this.value("update"), (Node)this.value("statement")))});
    }

    Rule forInit() {
        return this.Optional(this.FirstOf(this.variableDefinition(), this.statementExpressionList(), new Object[0]));
    }

    Rule forUpdate() {
        return this.Optional(this.statementExpressionList());
    }

    Rule statementExpressionList() {
        return this.Sequence(this.group.expressions.statementExpression().label("head"), this.ZeroOrMore(this.Sequence(this.Ch(','), this.group.basics.optWS(), new Object[]{this.group.expressions.statementExpression()}).label("tail")), new Object[]{this.set(this.actions.createStatementExpressionList((Node)this.value("head"), this.values("ZeroOrMore/tail")))});
    }

    public Rule enhancedForStatement() {
        return this.Sequence(this.String("for"), this.group.basics.testLexBreak(), new Object[]{this.group.basics.optWS(), this.Ch('('), this.group.basics.optWS(), this.group.structures.variableDefinitionModifiers().label("modifiers"), this.group.types.type().label("type"), this.group.structures.variableDefinitionPartNoAssign().label("varDeclPart"), this.Ch(':'), this.group.basics.optWS(), this.group.expressions.anyExpression().label("iterable"), this.Ch(')'), this.group.basics.optWS(), this.anyStatement().label("statement"), this.set(this.actions.createEnhancedFor((org.parboiled.Node<Node>)this.node("modifiers"), (Node)this.value("type"), (org.parboiled.Node<Node>)this.node("varDeclPart"), (Node)this.value("iterable"), (Node)this.value("statement")))});
    }

    public Rule breakStatement() {
        return this.Sequence(this.String("break"), this.group.basics.testLexBreak(), new Object[]{this.group.basics.optWS(), this.Optional(this.group.basics.identifier()).label("identifier"), this.Ch(';'), this.group.basics.optWS(), this.set(this.actions.createBreak((Node)this.value("identifier")))});
    }

    public Rule continueStatement() {
        return this.Sequence(this.String("continue"), this.group.basics.testLexBreak(), new Object[]{this.group.basics.optWS(), this.Optional(this.group.basics.identifier()).label("identifier"), this.Ch(';'), this.group.basics.optWS(), this.set(this.actions.createContinue((Node)this.value("identifier")))});
    }

    public Rule returnStatement() {
        return this.Sequence(this.String("return"), this.group.basics.testLexBreak(), new Object[]{this.group.basics.optWS(), this.Optional(this.group.expressions.anyExpression()).label("value"), this.Ch(';'), this.group.basics.optWS(), this.set(this.actions.createReturn((Node)this.value("value")))});
    }

    public Rule throwStatement() {
        return this.Sequence(this.String("throw"), this.group.basics.testLexBreak(), new Object[]{this.group.basics.optWS(), this.group.expressions.anyExpression().label("throwable"), this.Ch(';'), this.group.basics.optWS(), this.set(this.actions.createThrow((Node)this.value("throwable")))});
    }

    public Rule synchronizedStatement() {
        return this.Sequence(this.String("synchronized"), this.group.basics.testLexBreak(), new Object[]{this.group.basics.optWS(), this.Ch('('), this.group.basics.optWS(), this.group.expressions.anyExpression().label("lock"), this.Ch(')'), this.group.basics.optWS(), this.blockStatement().label("body"), this.set(this.actions.createSynchronizedStatement((Node)this.value("lock"), (Node)this.value("body")))});
    }

    public Rule tryStatement() {
        return this.Sequence(this.String("try"), this.group.basics.testLexBreak(), new Object[]{this.group.basics.optWS(), this.blockStatement().label("body"), this.ZeroOrMore(this.catchBlock().label("catchBlock")), this.Optional(this.Sequence(this.String("finally"), this.group.basics.testLexBreak(), new Object[]{this.group.basics.optWS(), this.blockStatement().label("finallyBody")})), this.set(this.actions.createTryStatement((Node)this.value("body"), this.values("ZeroOrMore/catchBlock"), (Node)this.value("Optional/Sequence/finallyBody")))});
    }

    Rule catchBlock() {
        return this.Sequence(this.String("catch"), this.group.basics.testLexBreak(), new Object[]{this.group.basics.optWS(), this.Ch('('), this.group.basics.optWS(), this.group.structures.variableDefinitionModifiers().label("modifiers"), this.group.types.type().label("type"), this.group.basics.identifier().label("varName"), this.Ch(')'), this.group.basics.optWS(), this.blockStatement().label("body"), this.set(this.actions.createCatch((Node)this.value("modifiers"), (Node)this.value("type"), (Node)this.value("varName"), (Node)this.value("body")))});
    }
}

