/*
 * Decompiled with CFR 0.152.
 */
package com.google.common.truth;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Joiner;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.truth.FailureStrategy;
import com.google.common.truth.StringUtil;
import javax.annotation.Nullable;

public final class FailureMetadata {
    private final FailureStrategy strategy;
    private final ImmutableList<Message> messages;
    @Nullable
    private final Throwable rootCause;

    static FailureMetadata forFailureStrategy(FailureStrategy failureStrategy) {
        return new FailureMetadata(failureStrategy, (ImmutableList<Message>)ImmutableList.of(), null);
    }

    FailureMetadata(FailureStrategy strategy, ImmutableList<Message> messages, @Nullable Throwable rootCause) {
        this.strategy = (FailureStrategy)Preconditions.checkNotNull((Object)strategy);
        this.messages = (ImmutableList)Preconditions.checkNotNull(messages);
        this.rootCause = rootCause;
    }

    FailureStrategy legacyStrategy() {
        return new MessageAddingFailureStrategy();
    }

    FailureMetadata offerRootCause(Throwable rootCause) {
        Preconditions.checkNotNull((Object)rootCause);
        return this.rootCause == null ? new FailureMetadata(this.strategy, this.messages, rootCause) : this;
    }

    FailureMetadata withMessage(String format, Object[] args) {
        return new FailureMetadata(this.strategy, FailureMetadata.prepend(this.messages, new Message(format, args)), this.rootCause);
    }

    @VisibleForTesting
    static int countPlaceholders(@Nullable String template) {
        if (template == null) {
            return 0;
        }
        int index = 0;
        int count = 0;
        while ((index = template.indexOf("%s", index)) != -1) {
            ++index;
            ++count;
        }
        return count;
    }

    private static ImmutableList<Message> prepend(ImmutableList<Message> messages, Message message) {
        return ImmutableList.builder().addAll(messages).add((Object)message).build();
    }

    private final class MessageAddingFailureStrategy
    extends FailureStrategy {
        private MessageAddingFailureStrategy() {
        }

        @Override
        public void fail(String message) {
            FailureMetadata.this.strategy.fail(this.addToMessage(message), FailureMetadata.this.rootCause);
        }

        @Override
        public void fail(String message, Throwable cause) {
            FailureMetadata.this.strategy.fail(this.addToMessage(message), cause);
        }

        @Override
        public void failComparing(String message, CharSequence expected, CharSequence actual) {
            FailureMetadata.this.strategy.failComparing(this.addToMessage(message), expected, actual, FailureMetadata.this.rootCause);
        }

        @Override
        public void failComparing(String message, CharSequence expected, CharSequence actual, Throwable cause) {
            FailureMetadata.this.strategy.failComparing(this.addToMessage(message), expected, actual, cause);
        }

        private String addToMessage(String body) {
            StringBuilder result = new StringBuilder(body.length());
            Joiner.on((String)": ").appendTo(result, (Iterable)FailureMetadata.this.messages);
            if (!FailureMetadata.this.messages.isEmpty()) {
                if (body.isEmpty()) {
                    result.append(":");
                } else {
                    result.append(": ");
                }
            }
            result.append(body);
            return result.toString();
        }
    }

    private static final class Message {
        private static final String PLACEHOLDER_ERR = "Incorrect number of args (%s) for the given placeholders (%s) in string template:\"%s\"";
        private final String format;
        private final Object[] args;

        Message(@Nullable String format, Object ... args) {
            this.format = format;
            this.args = args;
            int placeholders = FailureMetadata.countPlaceholders(format);
            Preconditions.checkArgument((placeholders == args.length ? 1 : 0) != 0, (String)PLACEHOLDER_ERR, (Object)args.length, (Object)placeholders, (Object)format);
        }

        public String toString() {
            return StringUtil.format(this.format, this.args);
        }
    }
}

