/*
 * Decompiled with CFR 0.152.
 */
package com.google.errorprone.bugpatterns.threadsafety;

import com.google.auto.value.AutoValue;
import com.google.common.base.Joiner;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Iterables;
import com.google.common.collect.Sets;
import com.google.errorprone.VisitorState;
import com.google.errorprone.bugpatterns.CanBeStaticAnalyzer;
import com.google.errorprone.bugpatterns.threadsafety.AnnotationInfo;
import com.google.errorprone.bugpatterns.threadsafety.AutoValue_ThreadSafety_Violation;
import com.google.errorprone.bugpatterns.threadsafety.WellKnownMutability;
import com.google.errorprone.util.ASTHelpers;
import com.sun.source.tree.ClassTree;
import com.sun.tools.javac.code.Attribute;
import com.sun.tools.javac.code.Symbol;
import com.sun.tools.javac.code.Type;
import com.sun.tools.javac.code.TypeTag;
import com.sun.tools.javac.code.Types;
import com.sun.tools.javac.util.Name;
import java.lang.annotation.Annotation;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import javax.lang.model.element.AnnotationValue;
import javax.lang.model.element.ElementKind;
import javax.lang.model.util.SimpleAnnotationValueVisitor8;
import org.pcollections.ConsPStack;

public final class ThreadSafety {
    private final VisitorState state;
    private final KnownTypes knownTypes;
    private final ImmutableSet<String> markerAnnotations;
    private final ImmutableSet<String> acceptedAnnotations;
    private final Class<? extends Annotation> containerOfAnnotation;
    private final Class<? extends Annotation> suppressAnnotation;

    public ThreadSafety(VisitorState state, KnownTypes knownTypes, Set<String> markerAnnotations, Set<String> acceptedAnnotations, @Nullable Class<? extends Annotation> containerOfAnnotation, @Nullable Class<? extends Annotation> suppressAnnotation) {
        this.state = (VisitorState)Preconditions.checkNotNull((Object)state);
        this.knownTypes = (KnownTypes)Preconditions.checkNotNull((Object)knownTypes);
        this.markerAnnotations = ImmutableSet.copyOf((Collection)((Collection)Preconditions.checkNotNull(markerAnnotations)));
        this.acceptedAnnotations = ImmutableSet.copyOf((Collection)((Collection)Preconditions.checkNotNull(acceptedAnnotations)));
        this.containerOfAnnotation = containerOfAnnotation;
        this.suppressAnnotation = suppressAnnotation;
    }

    public Violation threadSafeInstantiation(Set<String> threadSafeTypeParams, AnnotationInfo annotation, Type type) {
        if (!annotation.containerOf().isEmpty() && type.tsym.getTypeParameters().size() != type.getTypeArguments().size()) {
            return Violation.of(String.format("'%s' required instantiation of '%s' with type parameters, but was raw", this.getPrettyName(type.tsym), Joiner.on((String)", ").join(annotation.containerOf())));
        }
        for (int i = 0; i < type.tsym.getTypeParameters().size(); ++i) {
            Violation info;
            Symbol.TypeVariableSymbol typaram = type.tsym.getTypeParameters().get(i);
            if (!annotation.containerOf().contains(((Name)typaram.getSimpleName()).toString())) continue;
            Type tyarg = type.getTypeArguments().get(i);
            if (this.suppressAnnotation != null && tyarg.getAnnotationMirrors().stream().anyMatch(a -> ((Symbol.ClassSymbol)a.getAnnotationType().asElement()).flatName().toString().equals(this.suppressAnnotation.getName())) || !(info = this.isThreadSafeType(threadSafeTypeParams, tyarg)).isPresent()) continue;
            return info.plus(String.format("'%s' was instantiated with mutable type for '%s'", this.getPrettyName(type.tsym), typaram.getSimpleName()));
        }
        return Violation.absent();
    }

    public Violation isThreadSafeType(Set<String> threadSafeTypeParams, Type type) {
        return type.accept(new ThreadSafeTypeVisitor(threadSafeTypeParams), null);
    }

    public AnnotationInfo getMarkerOrAcceptedAnnotation(Symbol sym, VisitorState state) {
        String nameStr = sym.flatName().toString();
        AnnotationInfo known = this.knownTypes.getKnownSafeClasses().get(nameStr);
        if (known != null) {
            return known;
        }
        if (!(sym instanceof Symbol.ClassSymbol)) {
            return null;
        }
        return this.getAnnotation(sym, (ImmutableSet<String>)ImmutableSet.copyOf((Collection)Sets.union(this.markerAnnotations, this.acceptedAnnotations)), state);
    }

    public Type mutableEnclosingInstance(Optional<ClassTree> tree, Type.ClassType type) {
        if (tree.isPresent() && !CanBeStaticAnalyzer.referencesOuter(tree.get(), ASTHelpers.getSymbol((ClassTree)tree.get()), this.state)) {
            return null;
        }
        Type enclosing = type.getEnclosingType();
        while (!Type.noType.equals(enclosing)) {
            if (this.getMarkerOrAcceptedAnnotation(enclosing.tsym, this.state) == null && this.isThreadSafeType((Set<String>)ImmutableSet.of(), enclosing).isPresent()) {
                return enclosing;
            }
            enclosing = enclosing.getEnclosingType();
        }
        return null;
    }

    public Set<String> threadSafeTypeParametersInScope(Symbol sym) {
        return this.threadSafeTypeParameterSetInScope(sym);
    }

    @Deprecated
    public Set<String> threadSafeTypeParameterSetInScope(Symbol sym) {
        if (sym == null) {
            return ImmutableSet.of();
        }
        ImmutableSet.Builder result = ImmutableSet.builder();
        Symbol s = sym;
        block4: while (s.owner != null) {
            switch (s.getKind()) {
                case INSTANCE_INIT: {
                    break;
                }
                case PACKAGE: {
                    break block4;
                }
                default: {
                    AnnotationInfo annotation = this.getMarkerOrAcceptedAnnotation(s, this.state);
                    if (annotation == null) break;
                    for (Symbol.TypeVariableSymbol typaram : s.getTypeParameters()) {
                        String name = ((Name)typaram.getSimpleName()).toString();
                        if (!annotation.containerOf().contains(name)) continue;
                        result.add((Object)name);
                    }
                    if (s.isStatic()) break block4;
                }
            }
            s = s.owner;
        }
        return result.build();
    }

    private AnnotationInfo getAnnotation(Symbol sym, ImmutableSet<String> annotationsToCheck, VisitorState state) {
        for (String annotation : annotationsToCheck) {
            AnnotationInfo info = this.getAnnotation(sym, state, annotation, this.containerOfAnnotation);
            if (info == null) continue;
            return info;
        }
        return null;
    }

    private AnnotationInfo getAnnotation(Symbol sym, VisitorState state, String annotation, @Nullable Class<? extends Annotation> elementAnnotation) {
        Attribute.Compound attr = sym.attribute(state.getSymbolFromString(annotation));
        if (attr != null) {
            ImmutableList containerElements = ThreadSafety.containerOf(state, attr);
            if (elementAnnotation != null && containerElements.isEmpty()) {
                containerElements = (ImmutableList)sym.getTypeParameters().stream().filter(p -> p.getAnnotation(elementAnnotation) != null).map(p -> ((Name)p.getSimpleName()).toString()).collect(ImmutableList.toImmutableList());
            }
            return AnnotationInfo.create(sym.getQualifiedName().toString(), containerElements);
        }
        Type superClass = ((Symbol.ClassSymbol)sym).getSuperclass();
        AnnotationInfo superAnnotation = this.getInheritedAnnotation(superClass.asElement(), state);
        if (superAnnotation == null) {
            return null;
        }
        ImmutableList.Builder containerOf = ImmutableList.builder();
        for (int i = 0; i < superClass.getTypeArguments().size(); ++i) {
            Type arg = superClass.getTypeArguments().get(i);
            Symbol.TypeVariableSymbol formal = superClass.asElement().getTypeParameters().get(i);
            if (!arg.hasTag(TypeTag.TYPEVAR)) continue;
            Symbol.TypeSymbol argSym = arg.asElement();
            if (argSym.owner != sym || !superAnnotation.containerOf().contains(((Name)formal.getSimpleName()).toString())) continue;
            containerOf.add((Object)((Name)argSym.getSimpleName()).toString());
        }
        return AnnotationInfo.create(superAnnotation.typeName(), (Iterable<String>)containerOf.build());
    }

    public AnnotationInfo getInheritedAnnotation(Symbol sym, VisitorState state) {
        if (!(sym instanceof Symbol.ClassSymbol)) {
            return null;
        }
        return this.getAnnotation(sym, this.markerAnnotations, state);
    }

    private static ImmutableList<String> containerOf(VisitorState state, Attribute.Compound attr) {
        Attribute m = attr.member(state.getName("containerOf"));
        if (m == null) {
            return ImmutableList.of();
        }
        final ImmutableList.Builder containerOf = ImmutableList.builder();
        m.accept(new SimpleAnnotationValueVisitor8<Void, Void>(){

            @Override
            public Void visitString(String s, Void unused) {
                containerOf.add((Object)s);
                return null;
            }

            @Override
            public Void visitArray(List<? extends AnnotationValue> list, Void unused) {
                for (AnnotationValue annotationValue : list) {
                    annotationValue.accept(this, null);
                }
                return null;
            }
        }, null);
        return containerOf.build();
    }

    public String getPrettyName(Symbol sym) {
        if (!sym.getSimpleName().isEmpty()) {
            return sym.getSimpleName().toString();
        }
        if (sym.getKind() == ElementKind.ENUM) {
            return sym.owner.getSimpleName().toString();
        }
        Type superType = this.state.getTypes().supertype(sym.type);
        if (this.state.getTypes().isSameType(superType, this.state.getSymtab().objectType)) {
            superType = (Type)Iterables.getFirst(this.state.getTypes().interfaces(sym.type), (Object)superType);
        }
        return ((Name)superType.tsym.getSimpleName()).toString();
    }

    private class ThreadSafeTypeVisitor
    extends Types.SimpleVisitor<Violation, Void> {
        private final Set<String> threadSafeTypeParams;

        private ThreadSafeTypeVisitor(Set<String> threadSafeTypeParams) {
            this.threadSafeTypeParams = threadSafeTypeParams;
        }

        @Override
        public Violation visitWildcardType(Type.WildcardType type, Void s) {
            return ThreadSafety.this.state.getTypes().wildUpperBound(type).accept(this, null);
        }

        @Override
        public Violation visitArrayType(Type.ArrayType t, Void s) {
            return Violation.of("arrays are mutable");
        }

        @Override
        public Violation visitTypeVar(Type.TypeVar type, Void s) {
            Symbol.TypeVariableSymbol tyvar = (Symbol.TypeVariableSymbol)type.tsym;
            if (this.threadSafeTypeParams.contains(((Name)tyvar.getSimpleName()).toString())) {
                return Violation.absent();
            }
            String message = this.threadSafeTypeParams.isEmpty() ? String.format("'%s' is a mutable type variable", tyvar.getSimpleName()) : String.format("'%s' is a mutable type variable (not in '%s')", tyvar.getSimpleName(), Joiner.on((String)", ").join(this.threadSafeTypeParams));
            return Violation.of(message);
        }

        @Override
        public Violation visitType(Type type, Void s) {
            switch (type.tsym.getKind()) {
                case ANNOTATION_TYPE: {
                    return Violation.absent();
                }
                case ENUM: {
                    return Violation.absent();
                }
                case INTERFACE: 
                case CLASS: {
                    break;
                }
                default: {
                    throw new AssertionError((Object)String.format("Unexpected type kind %s", new Object[]{type.tsym.getKind()}));
                }
            }
            if (WellKnownMutability.isAnnotation(ThreadSafety.this.state, type)) {
                return Violation.absent();
            }
            AnnotationInfo annotation = ThreadSafety.this.getMarkerOrAcceptedAnnotation(type.tsym, ThreadSafety.this.state);
            if (annotation != null) {
                return ThreadSafety.this.threadSafeInstantiation(this.threadSafeTypeParams, annotation, type);
            }
            String nameStr = type.tsym.flatName().toString();
            if (ThreadSafety.this.knownTypes.getKnownUnsafeClasses().contains(nameStr)) {
                return Violation.of(String.format("'%s' is mutable", type.tsym.getSimpleName()));
            }
            if (WellKnownMutability.isProto2MessageClass(ThreadSafety.this.state, type)) {
                if (WellKnownMutability.isProto2MutableMessageClass(ThreadSafety.this.state, type)) {
                    return Violation.of(String.format("'%s' is a mutable proto message", type.tsym.getSimpleName()));
                }
                return Violation.absent();
            }
            return Violation.of(String.format("the declaration of type '%s' is not annotated with %s", type, ThreadSafety.this.markerAnnotations.stream().map(a -> "@" + a).collect(Collectors.joining(" or "))));
        }
    }

    @AutoValue
    public static abstract class Violation {
        public static Violation create(ConsPStack<String> path) {
            return new AutoValue_ThreadSafety_Violation(path);
        }

        public boolean isPresent() {
            return !this.path().isEmpty();
        }

        public String message() {
            return Joiner.on((String)", ").join(this.path());
        }

        public abstract ConsPStack<String> path();

        public Violation plus(String edge) {
            return Violation.create((ConsPStack<String>)this.path().plus((Object)edge));
        }

        public static Violation of(String reason) {
            return Violation.create((ConsPStack<String>)ConsPStack.singleton((Object)reason));
        }

        public static Violation absent() {
            return Violation.create((ConsPStack<String>)ConsPStack.empty());
        }
    }

    public static interface KnownTypes {
        public Map<String, AnnotationInfo> getKnownSafeClasses();

        public Set<String> getKnownUnsafeClasses();
    }
}

