/*
 * Decompiled with CFR 0.152.
 */
package com.google.turbine.binder.bytecode;

import com.google.common.base.MoreObjects;
import com.google.common.base.Supplier;
import com.google.common.base.Suppliers;
import com.google.common.base.Verify;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.turbine.binder.bound.AnnotationMetadata;
import com.google.turbine.binder.bound.BoundClass;
import com.google.turbine.binder.bound.HeaderBoundClass;
import com.google.turbine.binder.bound.TypeBoundClass;
import com.google.turbine.binder.bytecode.BytecodeBinder;
import com.google.turbine.binder.env.Env;
import com.google.turbine.binder.sym.ClassSymbol;
import com.google.turbine.binder.sym.FieldSymbol;
import com.google.turbine.binder.sym.MethodSymbol;
import com.google.turbine.binder.sym.TyVarSymbol;
import com.google.turbine.bytecode.ClassFile;
import com.google.turbine.bytecode.ClassReader;
import com.google.turbine.bytecode.sig.Sig;
import com.google.turbine.bytecode.sig.SigParser;
import com.google.turbine.model.Const;
import com.google.turbine.model.TurbineElementType;
import com.google.turbine.model.TurbineTyKind;
import com.google.turbine.type.AnnoInfo;
import com.google.turbine.type.Type;
import java.lang.annotation.RetentionPolicy;
import java.util.Map;
import java.util.function.Function;
import org.checkerframework.checker.nullness.qual.Nullable;

public class BytecodeBoundClass
implements BoundClass,
HeaderBoundClass,
TypeBoundClass {
    private final ClassSymbol sym;
    private final Env<ClassSymbol, BytecodeBoundClass> env;
    private final Supplier<ClassFile> classFile;
    private final String jarFile;
    final Supplier<TurbineTyKind> kind = Suppliers.memoize((Supplier)new Supplier<TurbineTyKind>(){

        public TurbineTyKind get() {
            int access = BytecodeBoundClass.this.access();
            if ((access & 0x2000) == 8192) {
                return TurbineTyKind.ANNOTATION;
            }
            if ((access & 0x200) == 512) {
                return TurbineTyKind.INTERFACE;
            }
            if ((access & 0x4000) == 16384) {
                return TurbineTyKind.ENUM;
            }
            return TurbineTyKind.CLASS;
        }
    });
    final Supplier<ClassSymbol> owner = Suppliers.memoize((Supplier)new Supplier<ClassSymbol>(){

        public ClassSymbol get() {
            for (ClassFile.InnerClass inner : ((ClassFile)BytecodeBoundClass.this.classFile.get()).innerClasses()) {
                if (!BytecodeBoundClass.this.sym.binaryName().equals(inner.innerClass())) continue;
                return new ClassSymbol(inner.outerClass());
            }
            return null;
        }
    });
    final Supplier<ImmutableMap<String, ClassSymbol>> children = Suppliers.memoize((Supplier)new Supplier<ImmutableMap<String, ClassSymbol>>(){

        public ImmutableMap<String, ClassSymbol> get() {
            ImmutableMap.Builder result = ImmutableMap.builder();
            for (ClassFile.InnerClass inner : ((ClassFile)BytecodeBoundClass.this.classFile.get()).innerClasses()) {
                if (inner.innerName() == null || !BytecodeBoundClass.this.sym.binaryName().equals(inner.outerClass())) continue;
                result.put((Object)inner.innerName(), (Object)new ClassSymbol(inner.innerClass()));
            }
            return result.build();
        }
    });
    final Supplier<Integer> access = Suppliers.memoize((Supplier)new Supplier<Integer>(){

        public Integer get() {
            int access = ((ClassFile)BytecodeBoundClass.this.classFile.get()).access();
            for (ClassFile.InnerClass inner : ((ClassFile)BytecodeBoundClass.this.classFile.get()).innerClasses()) {
                if (!BytecodeBoundClass.this.sym.binaryName().equals(inner.innerClass())) continue;
                access = inner.access();
            }
            return access;
        }
    });
    private final Supplier<Sig.ClassSig> sig = Suppliers.memoize((Supplier)new Supplier<Sig.ClassSig>(){

        public Sig.ClassSig get() {
            String signature = ((ClassFile)BytecodeBoundClass.this.classFile.get()).signature();
            if (signature == null) {
                return null;
            }
            return new SigParser(signature).parseClassSig();
        }
    });
    private final Supplier<ImmutableMap<String, TyVarSymbol>> tyParams = Suppliers.memoize((Supplier)new Supplier<ImmutableMap<String, TyVarSymbol>>(){

        public ImmutableMap<String, TyVarSymbol> get() {
            Sig.ClassSig csig = (Sig.ClassSig)BytecodeBoundClass.this.sig.get();
            if (csig == null || csig.tyParams().isEmpty()) {
                return ImmutableMap.of();
            }
            ImmutableMap.Builder result = ImmutableMap.builder();
            for (Sig.TyParamSig p : csig.tyParams()) {
                result.put((Object)p.name(), (Object)new TyVarSymbol(BytecodeBoundClass.this.sym, p.name()));
            }
            return result.build();
        }
    });
    final Supplier<ClassSymbol> superclass = Suppliers.memoize((Supplier)new Supplier<ClassSymbol>(){

        public ClassSymbol get() {
            String superclass = ((ClassFile)BytecodeBoundClass.this.classFile.get()).superName();
            if (superclass == null) {
                return null;
            }
            return new ClassSymbol(superclass);
        }
    });
    final Supplier<ImmutableList<ClassSymbol>> interfaces = Suppliers.memoize((Supplier)new Supplier<ImmutableList<ClassSymbol>>(){

        public ImmutableList<ClassSymbol> get() {
            ImmutableList.Builder result = ImmutableList.builder();
            for (String i : ((ClassFile)BytecodeBoundClass.this.classFile.get()).interfaces()) {
                result.add((Object)new ClassSymbol(i));
            }
            return result.build();
        }
    });
    Supplier<Type.ClassTy> superClassType = Suppliers.memoize((Supplier)new Supplier<Type.ClassTy>(){

        public Type.ClassTy get() {
            if (BytecodeBoundClass.this.superclass() == null) {
                return null;
            }
            if (BytecodeBoundClass.this.sig.get() == null || ((Sig.ClassSig)BytecodeBoundClass.this.sig.get()).superClass() == null) {
                return Type.ClassTy.asNonParametricClassTy(BytecodeBoundClass.this.superclass());
            }
            return BytecodeBinder.bindClassTy(((Sig.ClassSig)BytecodeBoundClass.this.sig.get()).superClass(), BytecodeBoundClass.makeScope(BytecodeBoundClass.this.env, BytecodeBoundClass.this.sym, (Map)ImmutableMap.of()));
        }
    });
    Supplier<ImmutableMap<TyVarSymbol, TypeBoundClass.TyVarInfo>> typeParameterTypes = Suppliers.memoize((Supplier)new Supplier<ImmutableMap<TyVarSymbol, TypeBoundClass.TyVarInfo>>(){

        public ImmutableMap<TyVarSymbol, TypeBoundClass.TyVarInfo> get() {
            if (BytecodeBoundClass.this.sig.get() == null) {
                return ImmutableMap.of();
            }
            ImmutableMap.Builder tparams = ImmutableMap.builder();
            Function scope = BytecodeBoundClass.makeScope(BytecodeBoundClass.this.env, BytecodeBoundClass.this.sym, BytecodeBoundClass.this.typeParameters());
            for (Sig.TyParamSig p : ((Sig.ClassSig)BytecodeBoundClass.this.sig.get()).tyParams()) {
                tparams.put(BytecodeBoundClass.this.typeParameters().get((Object)p.name()), (Object)BytecodeBoundClass.bindTyParam(p, scope));
            }
            return tparams.build();
        }
    });
    private final Supplier<ImmutableList<TypeBoundClass.FieldInfo>> fields = Suppliers.memoize((Supplier)new Supplier<ImmutableList<TypeBoundClass.FieldInfo>>(){

        public ImmutableList<TypeBoundClass.FieldInfo> get() {
            ImmutableList.Builder fields = ImmutableList.builder();
            for (ClassFile.FieldInfo cfi : ((ClassFile)BytecodeBoundClass.this.classFile.get()).fields()) {
                FieldSymbol fieldSym = new FieldSymbol(BytecodeBoundClass.this.sym, cfi.name());
                Type type = null;
                int access = cfi.access();
                Const.Value value = cfi.value();
                if (value != null) {
                    switch (cfi.descriptor()) {
                        case "Z": {
                            value = new Const.BooleanValue(value.asInteger().value() != 0);
                            break;
                        }
                        case "C": {
                            value = new Const.CharValue(value.asChar().value());
                            break;
                        }
                        case "S": {
                            value = new Const.ShortValue(value.asShort().value());
                            break;
                        }
                        case "B": {
                            value = new Const.ByteValue(value.asByte().value());
                            break;
                        }
                    }
                }
                fields.add((Object)new TypeBoundClass.FieldInfo(fieldSym, type, access, (ImmutableList<AnnoInfo>)ImmutableList.of(), null, value));
            }
            return fields.build();
        }
    });
    Supplier<ImmutableList<TypeBoundClass.MethodInfo>> methods = Suppliers.memoize((Supplier)new Supplier<ImmutableList<TypeBoundClass.MethodInfo>>(){

        public ImmutableList<TypeBoundClass.MethodInfo> get() {
            if (BytecodeBoundClass.this.kind() != TurbineTyKind.ANNOTATION) {
                return ImmutableList.of();
            }
            ImmutableList.Builder methods = ImmutableList.builder();
            for (ClassFile.MethodInfo m : ((ClassFile)BytecodeBoundClass.this.classFile.get()).methods()) {
                methods.add((Object)BytecodeBoundClass.this.bindMethod(m));
            }
            return methods.build();
        }
    });
    final Supplier<AnnotationMetadata> annotationMetadata = Suppliers.memoize((Supplier)new Supplier<AnnotationMetadata>(){

        public AnnotationMetadata get() {
            if ((BytecodeBoundClass.this.access() & 0x2000) != 8192) {
                return null;
            }
            RetentionPolicy retention = null;
            ImmutableSet target = null;
            ClassSymbol repeatable = null;
            for (ClassFile.AnnotationInfo annotation : ((ClassFile)BytecodeBoundClass.this.classFile.get()).annotations()) {
                switch (annotation.typeName()) {
                    case "Ljava/lang/annotation/Retention;": {
                        retention = BytecodeBoundClass.this.bindRetention(annotation);
                        break;
                    }
                    case "Ljava/lang/annotation/Target;": {
                        target = BytecodeBoundClass.bindTarget(annotation);
                        break;
                    }
                    case "Ljava/lang/annotation/Repeatable;": {
                        repeatable = BytecodeBoundClass.bindRepeatable(annotation);
                        break;
                    }
                }
            }
            return new AnnotationMetadata(retention, target, repeatable);
        }
    });

    public BytecodeBoundClass(final ClassSymbol sym, final Supplier<byte[]> bytes, Env<ClassSymbol, BytecodeBoundClass> env, final String jarFile) {
        this.sym = sym;
        this.env = env;
        this.jarFile = jarFile;
        this.classFile = Suppliers.memoize((Supplier)new Supplier<ClassFile>(){

            public ClassFile get() {
                ClassFile cf = ClassReader.read(jarFile + "!" + sym.binaryName(), (byte[])bytes.get());
                Verify.verify((boolean)cf.name().equals(sym.binaryName()), (String)"expected class data for %s, saw %s instead", (Object)sym.binaryName(), (Object)cf.name());
                return cf;
            }
        });
    }

    @Override
    public TurbineTyKind kind() {
        return (TurbineTyKind)((Object)this.kind.get());
    }

    @Override
    public @Nullable ClassSymbol owner() {
        return (ClassSymbol)this.owner.get();
    }

    @Override
    public ImmutableMap<String, ClassSymbol> children() {
        return (ImmutableMap)this.children.get();
    }

    @Override
    public int access() {
        return (Integer)this.access.get();
    }

    @Override
    public ImmutableMap<String, TyVarSymbol> typeParameters() {
        return (ImmutableMap)this.tyParams.get();
    }

    @Override
    public ClassSymbol superclass() {
        return (ClassSymbol)this.superclass.get();
    }

    @Override
    public ImmutableList<ClassSymbol> interfaces() {
        return (ImmutableList)this.interfaces.get();
    }

    @Override
    public Type.ClassTy superClassType() {
        return (Type.ClassTy)this.superClassType.get();
    }

    private static TypeBoundClass.TyVarInfo bindTyParam(Sig.TyParamSig sig, Function<String, TyVarSymbol> scope) {
        Type superClassBound = null;
        if (sig.classBound() != null) {
            superClassBound = BytecodeBinder.bindTy(sig.classBound(), scope);
        }
        ImmutableList.Builder interfaceBounds = ImmutableList.builder();
        for (Sig.TySig t : sig.interfaceBounds()) {
            interfaceBounds.add((Object)BytecodeBinder.bindTy(t, scope));
        }
        return new TypeBoundClass.TyVarInfo(superClassBound, (ImmutableList<Type>)interfaceBounds.build(), (ImmutableList<AnnoInfo>)ImmutableList.of());
    }

    @Override
    public ImmutableMap<TyVarSymbol, TypeBoundClass.TyVarInfo> typeParameterTypes() {
        return (ImmutableMap)this.typeParameterTypes.get();
    }

    @Override
    public ImmutableList<TypeBoundClass.FieldInfo> fields() {
        return (ImmutableList)this.fields.get();
    }

    private TypeBoundClass.MethodInfo bindMethod(ClassFile.MethodInfo m) {
        MethodSymbol methodSymbol = new MethodSymbol(this.sym, m.name());
        Sig.MethodSig sig = new SigParser((String)MoreObjects.firstNonNull((Object)m.signature(), (Object)m.descriptor())).parseMethodSig();
        Verify.verify((boolean)sig.tyParams().isEmpty());
        Function<String, TyVarSymbol> scope = BytecodeBoundClass.makeScope(this.env, this.sym, (Map<String, TyVarSymbol>)ImmutableMap.of());
        Type ret = null;
        if (sig.returnType() != null) {
            ret = BytecodeBinder.bindTy(sig.returnType(), scope);
        }
        ImmutableList.Builder formals = ImmutableList.builder();
        for (Sig.TySig tySig : sig.params()) {
            formals.add((Object)new TypeBoundClass.ParamInfo(BytecodeBinder.bindTy(tySig, scope), null, (ImmutableList<AnnoInfo>)ImmutableList.of(), 0));
        }
        Verify.verify((boolean)sig.exceptions().isEmpty());
        return new TypeBoundClass.MethodInfo(methodSymbol, (ImmutableMap<TyVarSymbol, TypeBoundClass.TyVarInfo>)ImmutableMap.of(), ret, (ImmutableList<TypeBoundClass.ParamInfo>)formals.build(), (ImmutableList<Type>)ImmutableList.of(), m.access(), null, null, (ImmutableList<AnnoInfo>)ImmutableList.of(), null);
    }

    @Override
    public ImmutableList<TypeBoundClass.MethodInfo> methods() {
        return (ImmutableList)this.methods.get();
    }

    private RetentionPolicy bindRetention(ClassFile.AnnotationInfo annotation) {
        ClassFile.AnnotationInfo.ElementValue val = annotation.elementValuePairs().get("value");
        if (val.kind() != ClassFile.AnnotationInfo.ElementValue.Kind.ENUM) {
            return null;
        }
        ClassFile.AnnotationInfo.ElementValue.EnumConstValue enumVal = (ClassFile.AnnotationInfo.ElementValue.EnumConstValue)val;
        if (!enumVal.typeName().equals("Ljava/lang/annotation/RetentionPolicy;")) {
            return null;
        }
        return RetentionPolicy.valueOf(enumVal.constName());
    }

    private static ImmutableSet<TurbineElementType> bindTarget(ClassFile.AnnotationInfo annotation) {
        ImmutableSet.Builder result = ImmutableSet.builder();
        ClassFile.AnnotationInfo.ElementValue val = annotation.elementValuePairs().get("value");
        switch (val.kind()) {
            case ARRAY: {
                for (ClassFile.AnnotationInfo.ElementValue element : ((ClassFile.AnnotationInfo.ElementValue.ArrayValue)val).elements()) {
                    if (element.kind() != ClassFile.AnnotationInfo.ElementValue.Kind.ENUM) continue;
                    BytecodeBoundClass.bindTargetElement((ImmutableSet.Builder<TurbineElementType>)result, (ClassFile.AnnotationInfo.ElementValue.EnumConstValue)element);
                }
                break;
            }
            case ENUM: {
                BytecodeBoundClass.bindTargetElement((ImmutableSet.Builder<TurbineElementType>)result, (ClassFile.AnnotationInfo.ElementValue.EnumConstValue)val);
                break;
            }
        }
        return result.build();
    }

    private static void bindTargetElement(ImmutableSet.Builder<TurbineElementType> target, ClassFile.AnnotationInfo.ElementValue.EnumConstValue enumVal) {
        if (enumVal.typeName().equals("Ljava/lang/annotation/ElementType;")) {
            target.add((Object)TurbineElementType.valueOf(enumVal.constName()));
        }
    }

    private static ClassSymbol bindRepeatable(ClassFile.AnnotationInfo annotation) {
        ClassFile.AnnotationInfo.ElementValue val = annotation.elementValuePairs().get("value");
        switch (val.kind()) {
            case CLASS: {
                String className = ((ClassFile.AnnotationInfo.ElementValue.ConstClassValue)val).className();
                return new ClassSymbol(className.substring(1, className.length() - 1));
            }
        }
        return null;
    }

    @Override
    public AnnotationMetadata annotationMetadata() {
        return (AnnotationMetadata)this.annotationMetadata.get();
    }

    private static Function<String, TyVarSymbol> makeScope(final Env<ClassSymbol, BytecodeBoundClass> env, final ClassSymbol sym, final Map<String, TyVarSymbol> typeVariables) {
        return new Function<String, TyVarSymbol>(){

            @Override
            public TyVarSymbol apply(String input) {
                TyVarSymbol result = (TyVarSymbol)typeVariables.get(input);
                if (result != null) {
                    return result;
                }
                ClassSymbol curr = sym;
                while (curr != null) {
                    BytecodeBoundClass info = (BytecodeBoundClass)env.get(curr);
                    if (info == null) {
                        throw new AssertionError(curr);
                    }
                    result = (TyVarSymbol)info.typeParameters().get((Object)input);
                    if (result != null) {
                        return result;
                    }
                    curr = info.owner();
                }
                throw new AssertionError((Object)input);
            }
        };
    }

    public String jarFile() {
        return this.jarFile;
    }

    public ClassFile classFile() {
        return (ClassFile)this.classFile.get();
    }
}

