/*
 * Decompiled with CFR 0.152.
 */
package com.google.errorprone.dataflow.nullnesspropagation;

import com.google.errorprone.dataflow.DataFlow;
import com.google.errorprone.dataflow.nullnesspropagation.Nullness;
import com.google.errorprone.dataflow.nullnesspropagation.NullnessPropagationTransfer;
import com.sun.source.util.TreePath;
import com.sun.tools.javac.util.Context;
import java.io.Serializable;

public final class NullnessAnalysis
implements Serializable {
    private static final Context.Key<NullnessAnalysis> NULLNESS_ANALYSIS_KEY = new Context.Key();
    private final NullnessPropagationTransfer nullnessPropagation = new NullnessPropagationTransfer();

    public static NullnessAnalysis instance(Context context) {
        NullnessAnalysis instance = context.get(NULLNESS_ANALYSIS_KEY);
        if (instance == null) {
            instance = new NullnessAnalysis();
            context.put(NULLNESS_ANALYSIS_KEY, instance);
        }
        return instance;
    }

    private NullnessAnalysis() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Nullness getNullness(TreePath exprPath, Context context) {
        try {
            this.nullnessPropagation.setContext(context).setCompilationUnit(exprPath.getCompilationUnit());
            Nullness nullness = (Nullness)((Object)DataFlow.expressionDataflow(exprPath, context, this.nullnessPropagation));
            return nullness;
        }
        finally {
            this.nullnessPropagation.setContext(null).setCompilationUnit(null);
        }
    }
}

