/*
 * Decompiled with CFR 0.152.
 */
package com.sun.tools.sjavac;

import com.sun.tools.sjavac.Log;
import com.sun.tools.sjavac.Transformer;
import com.sun.tools.sjavac.Util;
import com.sun.tools.sjavac.comp.CompilationService;
import com.sun.tools.sjavac.options.Options;
import com.sun.tools.sjavac.pubapi.PubApi;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URI;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;

public class CopyFile
implements Transformer {
    @Override
    public void setExtra(String e) {
    }

    @Override
    public void setExtra(Options a) {
    }

    @Override
    public boolean transform(CompilationService compilationService, Map<String, Set<URI>> pkgSrcs, Set<URI> visibleSrcs, Map<String, Set<String>> oldPackageDependents, URI destRoot, Map<String, Set<URI>> packageArtifacts, Map<String, Map<String, Set<String>>> packageDependencies, Map<String, Map<String, Set<String>>> packageCpDependencies, Map<String, PubApi> packagePubapis, Map<String, PubApi> dependencyPubapis, int debugLevel, boolean incremental, int numCores) {
        boolean rc = true;
        for (String pkgName : pkgSrcs.keySet()) {
            String pkgNameF = Util.toFileSystemPath(pkgName);
            for (URI u : pkgSrcs.get(pkgName)) {
                File src = new File(u);
                File destDir = new File(destRoot.getPath() + File.separator + pkgNameF);
                String dest_filename = destRoot.getPath() + File.separator + pkgNameF + File.separator + src.getName();
                File dest = new File(dest_filename);
                if (!destDir.isDirectory() && !destDir.mkdirs()) {
                    Log.error("Error: The copier could not create the directory " + destDir.getPath());
                    return false;
                }
                Set<URI> as = packageArtifacts.get(pkgName);
                if (as == null) {
                    as = new HashSet<URI>();
                    packageArtifacts.put(pkgName, as);
                }
                as.add(dest.toURI());
                if (dest.exists() && dest.lastModified() > src.lastModified()) continue;
                Log.info("Copying " + pkgNameF + File.separator + src.getName());
                try (FileInputStream fin = new FileInputStream(src);
                     FileOutputStream fout = new FileOutputStream(dest);){
                    int len;
                    byte[] buf = new byte[1024];
                    while ((len = ((InputStream)fin).read(buf)) > 0) {
                        ((OutputStream)fout).write(buf, 0, len);
                    }
                }
                catch (IOException e) {
                    Log.error("Could not copy the file " + src.getPath() + " to " + dest.getPath());
                    rc = false;
                }
            }
        }
        return rc;
    }
}

