/*
 * Decompiled with CFR 0.152.
 */
package com.google.testing.compile;

import com.google.common.base.Objects;
import com.google.common.base.Optional;
import com.google.common.base.Preconditions;
import com.google.testing.compile.TreeDifference;
import com.sun.source.tree.AnnotationTree;
import com.sun.source.tree.ArrayAccessTree;
import com.sun.source.tree.ArrayTypeTree;
import com.sun.source.tree.AssertTree;
import com.sun.source.tree.AssignmentTree;
import com.sun.source.tree.BinaryTree;
import com.sun.source.tree.BlockTree;
import com.sun.source.tree.BreakTree;
import com.sun.source.tree.CaseTree;
import com.sun.source.tree.CatchTree;
import com.sun.source.tree.ClassTree;
import com.sun.source.tree.CompilationUnitTree;
import com.sun.source.tree.CompoundAssignmentTree;
import com.sun.source.tree.ConditionalExpressionTree;
import com.sun.source.tree.ContinueTree;
import com.sun.source.tree.DoWhileLoopTree;
import com.sun.source.tree.EmptyStatementTree;
import com.sun.source.tree.EnhancedForLoopTree;
import com.sun.source.tree.ErroneousTree;
import com.sun.source.tree.ExpressionStatementTree;
import com.sun.source.tree.ForLoopTree;
import com.sun.source.tree.IdentifierTree;
import com.sun.source.tree.IfTree;
import com.sun.source.tree.ImportTree;
import com.sun.source.tree.InstanceOfTree;
import com.sun.source.tree.LabeledStatementTree;
import com.sun.source.tree.LambdaExpressionTree;
import com.sun.source.tree.LiteralTree;
import com.sun.source.tree.MemberReferenceTree;
import com.sun.source.tree.MemberSelectTree;
import com.sun.source.tree.MethodInvocationTree;
import com.sun.source.tree.MethodTree;
import com.sun.source.tree.ModifiersTree;
import com.sun.source.tree.NewArrayTree;
import com.sun.source.tree.NewClassTree;
import com.sun.source.tree.ParameterizedTypeTree;
import com.sun.source.tree.ParenthesizedTree;
import com.sun.source.tree.PrimitiveTypeTree;
import com.sun.source.tree.ReturnTree;
import com.sun.source.tree.SwitchTree;
import com.sun.source.tree.SynchronizedTree;
import com.sun.source.tree.ThrowTree;
import com.sun.source.tree.Tree;
import com.sun.source.tree.TryTree;
import com.sun.source.tree.TypeCastTree;
import com.sun.source.tree.TypeParameterTree;
import com.sun.source.tree.UnaryTree;
import com.sun.source.tree.VariableTree;
import com.sun.source.tree.WhileLoopTree;
import com.sun.source.tree.WildcardTree;
import com.sun.source.util.SimpleTreeVisitor;
import com.sun.source.util.TreePath;
import java.util.Iterator;
import javax.annotation.Nullable;
import javax.lang.model.element.Name;

final class TreeDiffer {
    private TreeDiffer() {
    }

    static final TreeDifference diffCompilationUnits(@Nullable CompilationUnitTree expected, @Nullable CompilationUnitTree actual) {
        TreeDifference.Builder diffBuilder = new TreeDifference.Builder();
        DiffVisitor diffVisitor = new DiffVisitor(diffBuilder);
        diffVisitor.scan(expected, actual);
        return diffBuilder.build();
    }

    static final TreeDifference diffSubtrees(@Nullable TreePath pathToExpected, @Nullable TreePath pathToActual) {
        TreeDifference.Builder diffBuilder = new TreeDifference.Builder();
        DiffVisitor diffVisitor = new DiffVisitor(diffBuilder, pathToExpected, pathToActual);
        diffVisitor.scan(pathToExpected.getLeaf(), pathToActual.getLeaf());
        return diffBuilder.build();
    }

    static final class DiffVisitor
    extends SimpleTreeVisitor<Void, Tree> {
        private TreePath expectedPath;
        private TreePath actualPath;
        private final TreeDifference.Builder diffBuilder;

        public DiffVisitor(TreeDifference.Builder diffBuilder) {
            this.diffBuilder = diffBuilder;
            this.expectedPath = null;
            this.actualPath = null;
        }

        public DiffVisitor(TreeDifference.Builder diffBuilder, TreePath pathToExpected, TreePath pathToActual) {
            this.diffBuilder = diffBuilder;
            this.expectedPath = pathToExpected;
            this.actualPath = pathToActual;
        }

        public void addTypeMismatch(Tree expected, Tree actual) {
            this.diffBuilder.addDifferingNodes(this.expectedPathPlus(expected), this.actualPathPlus(actual), String.format("Expected node kind to be <%s> but was <%s>.", new Object[]{expected.getKind(), actual.getKind()}));
        }

        private void checkForDiff(boolean p, String message, Object ... formatArgs) {
            if (!p) {
                this.diffBuilder.addDifferingNodes(this.expectedPath, this.actualPath, String.format(message, formatArgs));
            }
        }

        private TreePath actualPathPlus(Tree actual) {
            Preconditions.checkNotNull((Object)actual, (Object)"Tried to push null actual tree onto path.");
            return new TreePath(this.actualPath, actual);
        }

        private TreePath expectedPathPlus(Tree expected) {
            Preconditions.checkNotNull((Object)expected, (Object)"Tried to push null expected tree onto path.");
            return new TreePath(this.expectedPath, expected);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private Void pushPathAndAccept(Tree expected, Tree actual) {
            TreePath prevExpectedPath = this.expectedPath;
            TreePath prevActualPath = this.actualPath;
            this.expectedPath = this.expectedPathPlus(expected);
            this.actualPath = this.actualPathPlus(actual);
            try {
                Void void_ = expected.accept(this, actual);
                return void_;
            }
            finally {
                this.expectedPath = prevExpectedPath;
                this.actualPath = prevActualPath;
            }
        }

        private boolean namesEqual(@Nullable Name expected, @Nullable Name actual) {
            return expected == null ? actual == null : actual != null && expected.contentEquals(actual);
        }

        public Void scan(@Nullable Tree expected, @Nullable Tree actual) {
            if (expected == null && actual != null) {
                this.diffBuilder.addExtraActualNode(this.actualPathPlus(actual));
            } else if (expected != null && actual == null) {
                this.diffBuilder.addExtraExpectedNode(this.expectedPathPlus(expected));
            } else if (actual != null && expected != null) {
                this.pushPathAndAccept(expected, actual);
            }
            return null;
        }

        private Void parallelScan(Iterable<? extends Tree> expecteds, Iterable<? extends Tree> actuals) {
            if (expecteds != null && actuals != null) {
                Iterator<? extends Tree> expectedsIterator = expecteds.iterator();
                Iterator<? extends Tree> actualsIterator = actuals.iterator();
                while (expectedsIterator.hasNext() && actualsIterator.hasNext()) {
                    this.pushPathAndAccept(expectedsIterator.next(), actualsIterator.next());
                }
                if (!expectedsIterator.hasNext() && actualsIterator.hasNext()) {
                    this.diffBuilder.addExtraActualNode(this.actualPathPlus(actualsIterator.next()));
                } else if (expectedsIterator.hasNext() && !actualsIterator.hasNext()) {
                    this.diffBuilder.addExtraExpectedNode(this.expectedPathPlus(expectedsIterator.next()));
                }
            } else if (expecteds == null && !this.isEmptyOrNull(actuals)) {
                this.diffBuilder.addExtraActualNode(this.actualPathPlus(actuals.iterator().next()));
            } else if (actuals == null && !this.isEmptyOrNull(expecteds)) {
                this.diffBuilder.addExtraExpectedNode(this.expectedPathPlus(expecteds.iterator().next()));
            }
            return null;
        }

        private boolean isEmptyOrNull(Iterable<?> iterable) {
            return iterable == null || !iterable.iterator().hasNext();
        }

        @Override
        public Void visitAnnotation(AnnotationTree expected, Tree actual) {
            Optional<AnnotationTree> other = this.checkTypeAndCast(expected, actual);
            if (!other.isPresent()) {
                this.addTypeMismatch(expected, actual);
                return null;
            }
            this.scan(expected.getAnnotationType(), ((AnnotationTree)other.get()).getAnnotationType());
            this.parallelScan(expected.getArguments(), ((AnnotationTree)other.get()).getArguments());
            return null;
        }

        @Override
        public Void visitMethodInvocation(MethodInvocationTree expected, Tree actual) {
            Optional<MethodInvocationTree> other = this.checkTypeAndCast(expected, actual);
            if (!other.isPresent()) {
                this.addTypeMismatch(expected, actual);
                return null;
            }
            this.parallelScan(expected.getTypeArguments(), ((MethodInvocationTree)other.get()).getTypeArguments());
            this.scan(expected.getMethodSelect(), ((MethodInvocationTree)other.get()).getMethodSelect());
            this.parallelScan(expected.getArguments(), ((MethodInvocationTree)other.get()).getArguments());
            return null;
        }

        @Override
        public Void visitLambdaExpression(LambdaExpressionTree expected, Tree actual) {
            Optional<LambdaExpressionTree> other = this.checkTypeAndCast(expected, actual);
            if (!other.isPresent()) {
                this.addTypeMismatch(expected, actual);
                return null;
            }
            this.parallelScan(expected.getParameters(), ((LambdaExpressionTree)other.get()).getParameters());
            this.scan(expected.getBody(), ((LambdaExpressionTree)other.get()).getBody());
            return null;
        }

        @Override
        public Void visitMemberReference(MemberReferenceTree expected, Tree actual) {
            Optional<MemberReferenceTree> other = this.checkTypeAndCast(expected, actual);
            if (!other.isPresent()) {
                this.addTypeMismatch(expected, actual);
                return null;
            }
            this.scan(expected.getQualifierExpression(), ((MemberReferenceTree)other.get()).getQualifierExpression());
            this.parallelScan(expected.getTypeArguments(), ((MemberReferenceTree)other.get()).getTypeArguments());
            this.checkForDiff(expected.getName().contentEquals(((MemberReferenceTree)other.get()).getName()), "Expected identifier to be <%s> but was <%s>.", expected.getName(), ((MemberReferenceTree)other.get()).getName());
            return null;
        }

        @Override
        public Void visitAssert(AssertTree expected, Tree actual) {
            Optional<AssertTree> other = this.checkTypeAndCast(expected, actual);
            if (!other.isPresent()) {
                this.addTypeMismatch(expected, actual);
                return null;
            }
            this.scan(expected.getCondition(), ((AssertTree)other.get()).getCondition());
            this.scan(expected.getDetail(), ((AssertTree)other.get()).getDetail());
            return null;
        }

        @Override
        public Void visitAssignment(AssignmentTree expected, Tree actual) {
            Optional<AssignmentTree> other = this.checkTypeAndCast(expected, actual);
            if (!other.isPresent()) {
                this.addTypeMismatch(expected, actual);
                return null;
            }
            this.scan(expected.getVariable(), ((AssignmentTree)other.get()).getVariable());
            this.scan(expected.getExpression(), ((AssignmentTree)other.get()).getExpression());
            return null;
        }

        @Override
        public Void visitCompoundAssignment(CompoundAssignmentTree expected, Tree actual) {
            Optional<CompoundAssignmentTree> other = this.checkTypeAndCast(expected, actual);
            if (!other.isPresent()) {
                this.addTypeMismatch(expected, actual);
                return null;
            }
            this.scan(expected.getVariable(), ((CompoundAssignmentTree)other.get()).getVariable());
            this.scan(expected.getExpression(), ((CompoundAssignmentTree)other.get()).getExpression());
            return null;
        }

        @Override
        public Void visitBinary(BinaryTree expected, Tree actual) {
            Optional<BinaryTree> other = this.checkTypeAndCast(expected, actual);
            if (!other.isPresent()) {
                this.addTypeMismatch(expected, actual);
                return null;
            }
            this.scan(expected.getLeftOperand(), ((BinaryTree)other.get()).getLeftOperand());
            this.scan(expected.getRightOperand(), ((BinaryTree)other.get()).getRightOperand());
            return null;
        }

        @Override
        public Void visitBlock(BlockTree expected, Tree actual) {
            Optional<BlockTree> other = this.checkTypeAndCast(expected, actual);
            if (!other.isPresent()) {
                this.addTypeMismatch(expected, actual);
                return null;
            }
            this.checkForDiff(expected.isStatic() == ((BlockTree)other.get()).isStatic(), "Expected block to be <%s> but was <%s>.", expected.isStatic() ? "static" : "non-static", ((BlockTree)other.get()).isStatic() ? "static" : "non-static");
            this.parallelScan(expected.getStatements(), ((BlockTree)other.get()).getStatements());
            return null;
        }

        @Override
        public Void visitBreak(BreakTree expected, Tree actual) {
            Optional<BreakTree> other = this.checkTypeAndCast(expected, actual);
            if (!other.isPresent()) {
                this.addTypeMismatch(expected, actual);
                return null;
            }
            this.checkForDiff(this.namesEqual(expected.getLabel(), ((BreakTree)other.get()).getLabel()), "Expected label on break statement to be <%s> but was <%s>.", expected.getLabel(), ((BreakTree)other.get()).getLabel());
            return null;
        }

        @Override
        public Void visitCase(CaseTree expected, Tree actual) {
            Optional<CaseTree> other = this.checkTypeAndCast(expected, actual);
            if (!other.isPresent()) {
                this.addTypeMismatch(expected, actual);
                return null;
            }
            this.scan(expected.getExpression(), ((CaseTree)other.get()).getExpression());
            this.parallelScan(expected.getStatements(), ((CaseTree)other.get()).getStatements());
            return null;
        }

        @Override
        public Void visitCatch(CatchTree expected, Tree actual) {
            Optional<CatchTree> other = this.checkTypeAndCast(expected, actual);
            if (!other.isPresent()) {
                this.addTypeMismatch(expected, actual);
                return null;
            }
            this.scan(expected.getParameter(), ((CatchTree)other.get()).getParameter());
            this.scan(expected.getBlock(), ((CatchTree)other.get()).getBlock());
            return null;
        }

        @Override
        public Void visitClass(ClassTree expected, Tree actual) {
            Optional<ClassTree> other = this.checkTypeAndCast(expected, actual);
            if (!other.isPresent()) {
                this.addTypeMismatch(expected, actual);
                return null;
            }
            this.checkForDiff(expected.getSimpleName().contentEquals(((ClassTree)other.get()).getSimpleName()), "Expected name of type to be <%s> but was <%s>.", expected.getSimpleName(), ((ClassTree)other.get()).getSimpleName());
            this.scan(expected.getModifiers(), ((ClassTree)other.get()).getModifiers());
            this.parallelScan(expected.getTypeParameters(), ((ClassTree)other.get()).getTypeParameters());
            this.scan(expected.getExtendsClause(), ((ClassTree)other.get()).getExtendsClause());
            this.parallelScan(expected.getImplementsClause(), ((ClassTree)other.get()).getImplementsClause());
            this.parallelScan(expected.getMembers(), ((ClassTree)other.get()).getMembers());
            return null;
        }

        @Override
        public Void visitConditionalExpression(ConditionalExpressionTree expected, Tree actual) {
            Optional<ConditionalExpressionTree> other = this.checkTypeAndCast(expected, actual);
            if (!other.isPresent()) {
                this.addTypeMismatch(expected, actual);
                return null;
            }
            this.scan(expected.getCondition(), ((ConditionalExpressionTree)other.get()).getCondition());
            this.scan(expected.getTrueExpression(), ((ConditionalExpressionTree)other.get()).getTrueExpression());
            this.scan(expected.getFalseExpression(), ((ConditionalExpressionTree)other.get()).getFalseExpression());
            return null;
        }

        @Override
        public Void visitContinue(ContinueTree expected, Tree actual) {
            Optional<ContinueTree> other = this.checkTypeAndCast(expected, actual);
            if (!other.isPresent()) {
                this.addTypeMismatch(expected, actual);
                return null;
            }
            this.checkForDiff(this.namesEqual(expected.getLabel(), ((ContinueTree)other.get()).getLabel()), "Expected label on continue statement to be <%s> but was <%s>.", expected.getLabel(), ((ContinueTree)other.get()).getLabel());
            return null;
        }

        @Override
        public Void visitDoWhileLoop(DoWhileLoopTree expected, Tree actual) {
            Optional<DoWhileLoopTree> other = this.checkTypeAndCast(expected, actual);
            if (!other.isPresent()) {
                this.addTypeMismatch(expected, actual);
                return null;
            }
            this.scan(expected.getCondition(), ((DoWhileLoopTree)other.get()).getCondition());
            this.scan(expected.getStatement(), ((DoWhileLoopTree)other.get()).getStatement());
            return null;
        }

        @Override
        public Void visitErroneous(ErroneousTree expected, Tree actual) {
            Optional<ErroneousTree> other = this.checkTypeAndCast(expected, actual);
            if (!other.isPresent()) {
                this.addTypeMismatch(expected, actual);
                return null;
            }
            this.parallelScan(expected.getErrorTrees(), ((ErroneousTree)other.get()).getErrorTrees());
            return null;
        }

        @Override
        public Void visitExpressionStatement(ExpressionStatementTree expected, Tree actual) {
            Optional<ExpressionStatementTree> other = this.checkTypeAndCast(expected, actual);
            if (!other.isPresent()) {
                this.addTypeMismatch(expected, actual);
                return null;
            }
            this.scan(expected.getExpression(), ((ExpressionStatementTree)other.get()).getExpression());
            return null;
        }

        @Override
        public Void visitEnhancedForLoop(EnhancedForLoopTree expected, Tree actual) {
            Optional<EnhancedForLoopTree> other = this.checkTypeAndCast(expected, actual);
            if (!other.isPresent()) {
                this.addTypeMismatch(expected, actual);
                return null;
            }
            this.scan(expected.getVariable(), ((EnhancedForLoopTree)other.get()).getVariable());
            this.scan(expected.getExpression(), ((EnhancedForLoopTree)other.get()).getExpression());
            this.scan(expected.getStatement(), ((EnhancedForLoopTree)other.get()).getStatement());
            return null;
        }

        @Override
        public Void visitForLoop(ForLoopTree expected, Tree actual) {
            Optional<ForLoopTree> other = this.checkTypeAndCast(expected, actual);
            if (!other.isPresent()) {
                this.addTypeMismatch(expected, actual);
                return null;
            }
            this.parallelScan(expected.getInitializer(), ((ForLoopTree)other.get()).getInitializer());
            this.scan(expected.getCondition(), ((ForLoopTree)other.get()).getCondition());
            this.parallelScan(expected.getUpdate(), ((ForLoopTree)other.get()).getUpdate());
            this.scan(expected.getStatement(), ((ForLoopTree)other.get()).getStatement());
            return null;
        }

        @Override
        public Void visitIdentifier(IdentifierTree expected, Tree actual) {
            Optional<IdentifierTree> other = this.checkTypeAndCast(expected, actual);
            if (!other.isPresent()) {
                this.addTypeMismatch(expected, actual);
                return null;
            }
            this.checkForDiff(expected.getName().contentEquals(((IdentifierTree)other.get()).getName()), "Expected identifier to be <%s> but was <%s>.", expected.getName(), ((IdentifierTree)other.get()).getName());
            return null;
        }

        @Override
        public Void visitIf(IfTree expected, Tree actual) {
            Optional<IfTree> other = this.checkTypeAndCast(expected, actual);
            if (!other.isPresent()) {
                this.addTypeMismatch(expected, actual);
                return null;
            }
            this.scan(expected.getCondition(), ((IfTree)other.get()).getCondition());
            this.scan(expected.getThenStatement(), ((IfTree)other.get()).getThenStatement());
            this.scan(expected.getElseStatement(), ((IfTree)other.get()).getElseStatement());
            return null;
        }

        @Override
        public Void visitImport(ImportTree expected, Tree actual) {
            Optional<ImportTree> other = this.checkTypeAndCast(expected, actual);
            if (!other.isPresent()) {
                this.addTypeMismatch(expected, actual);
                return null;
            }
            this.checkForDiff(expected.isStatic() == ((ImportTree)other.get()).isStatic(), "Expected import to be <%s> but was <%s>.", expected.isStatic() ? "static" : "non-static", ((ImportTree)other.get()).isStatic() ? "static" : "non-static");
            this.scan(expected.getQualifiedIdentifier(), ((ImportTree)other.get()).getQualifiedIdentifier());
            return null;
        }

        @Override
        public Void visitArrayAccess(ArrayAccessTree expected, Tree actual) {
            Optional<ArrayAccessTree> other = this.checkTypeAndCast(expected, actual);
            if (!other.isPresent()) {
                this.addTypeMismatch(expected, actual);
                return null;
            }
            this.scan(expected.getExpression(), ((ArrayAccessTree)other.get()).getExpression());
            this.scan(expected.getIndex(), ((ArrayAccessTree)other.get()).getIndex());
            return null;
        }

        @Override
        public Void visitLabeledStatement(LabeledStatementTree expected, Tree actual) {
            Optional<LabeledStatementTree> other = this.checkTypeAndCast(expected, actual);
            if (!other.isPresent()) {
                this.addTypeMismatch(expected, actual);
                return null;
            }
            this.checkForDiff(expected.getLabel().contentEquals(((LabeledStatementTree)other.get()).getLabel()), "Expected statement label to be <%s> but was <%s>.", expected.getLabel(), ((LabeledStatementTree)other.get()).getLabel());
            this.scan(expected.getStatement(), ((LabeledStatementTree)other.get()).getStatement());
            return null;
        }

        @Override
        public Void visitLiteral(LiteralTree expected, Tree actual) {
            Optional<LiteralTree> other = this.checkTypeAndCast(expected, actual);
            if (!other.isPresent()) {
                this.addTypeMismatch(expected, actual);
                return null;
            }
            this.checkForDiff(Objects.equal((Object)expected.getValue(), (Object)((LiteralTree)other.get()).getValue()), "Expected literal value to be <%s> but was <%s>.", expected.getValue(), ((LiteralTree)other.get()).getValue());
            return null;
        }

        @Override
        public Void visitMethod(MethodTree expected, Tree actual) {
            Optional<MethodTree> other = this.checkTypeAndCast(expected, actual);
            if (!other.isPresent()) {
                this.addTypeMismatch(expected, actual);
                return null;
            }
            this.checkForDiff(expected.getName().contentEquals(((MethodTree)other.get()).getName()), "Expected method name to be <%s> but was <%s>.", expected.getName(), ((MethodTree)other.get()).getName());
            this.scan(expected.getModifiers(), ((MethodTree)other.get()).getModifiers());
            this.scan(expected.getReturnType(), ((MethodTree)other.get()).getReturnType());
            this.parallelScan(expected.getTypeParameters(), ((MethodTree)other.get()).getTypeParameters());
            this.parallelScan(expected.getParameters(), ((MethodTree)other.get()).getParameters());
            this.parallelScan(expected.getThrows(), ((MethodTree)other.get()).getThrows());
            this.scan(expected.getBody(), ((MethodTree)other.get()).getBody());
            this.scan(expected.getDefaultValue(), ((MethodTree)other.get()).getDefaultValue());
            return null;
        }

        @Override
        public Void visitModifiers(ModifiersTree expected, Tree actual) {
            Optional<ModifiersTree> other = this.checkTypeAndCast(expected, actual);
            if (!other.isPresent()) {
                this.addTypeMismatch(expected, actual);
                return null;
            }
            this.checkForDiff(expected.getFlags().equals(((ModifiersTree)other.get()).getFlags()), "Expected modifier set to be <%s> but was <%s>.", expected.getFlags(), ((ModifiersTree)other.get()).getFlags());
            this.parallelScan(expected.getAnnotations(), ((ModifiersTree)other.get()).getAnnotations());
            return null;
        }

        @Override
        public Void visitNewArray(NewArrayTree expected, Tree actual) {
            Optional<NewArrayTree> other = this.checkTypeAndCast(expected, actual);
            if (!other.isPresent()) {
                this.addTypeMismatch(expected, actual);
                return null;
            }
            this.scan(expected.getType(), ((NewArrayTree)other.get()).getType());
            this.parallelScan(expected.getDimensions(), ((NewArrayTree)other.get()).getDimensions());
            this.parallelScan(expected.getInitializers(), ((NewArrayTree)other.get()).getInitializers());
            return null;
        }

        @Override
        public Void visitNewClass(NewClassTree expected, Tree actual) {
            Optional<NewClassTree> other = this.checkTypeAndCast(expected, actual);
            if (!other.isPresent()) {
                this.addTypeMismatch(expected, actual);
                return null;
            }
            this.scan(expected.getEnclosingExpression(), ((NewClassTree)other.get()).getEnclosingExpression());
            this.parallelScan(expected.getTypeArguments(), ((NewClassTree)other.get()).getTypeArguments());
            this.scan(expected.getIdentifier(), ((NewClassTree)other.get()).getIdentifier());
            this.parallelScan(expected.getArguments(), ((NewClassTree)other.get()).getArguments());
            this.scan(expected.getClassBody(), ((NewClassTree)other.get()).getClassBody());
            return null;
        }

        @Override
        public Void visitParenthesized(ParenthesizedTree expected, Tree actual) {
            Optional<ParenthesizedTree> other = this.checkTypeAndCast(expected, actual);
            if (!other.isPresent()) {
                this.addTypeMismatch(expected, actual);
                return null;
            }
            this.scan(expected.getExpression(), ((ParenthesizedTree)other.get()).getExpression());
            return null;
        }

        @Override
        public Void visitReturn(ReturnTree expected, Tree actual) {
            Optional<ReturnTree> other = this.checkTypeAndCast(expected, actual);
            if (!other.isPresent()) {
                this.addTypeMismatch(expected, actual);
                return null;
            }
            this.scan(expected.getExpression(), ((ReturnTree)other.get()).getExpression());
            return null;
        }

        @Override
        public Void visitMemberSelect(MemberSelectTree expected, Tree actual) {
            Optional<MemberSelectTree> other = this.checkTypeAndCast(expected, actual);
            if (!other.isPresent()) {
                this.addTypeMismatch(expected, actual);
                return null;
            }
            this.checkForDiff(expected.getIdentifier().contentEquals(((MemberSelectTree)other.get()).getIdentifier()), "Expected member identifier to be <%s> but was <%s>.", expected.getIdentifier(), ((MemberSelectTree)other.get()).getIdentifier());
            this.scan(expected.getExpression(), ((MemberSelectTree)other.get()).getExpression());
            return null;
        }

        @Override
        public Void visitEmptyStatement(EmptyStatementTree expected, Tree actual) {
            if (!this.checkTypeAndCast(expected, actual).isPresent()) {
                this.addTypeMismatch(expected, actual);
                return null;
            }
            return null;
        }

        @Override
        public Void visitSwitch(SwitchTree expected, Tree actual) {
            Optional<SwitchTree> other = this.checkTypeAndCast(expected, actual);
            if (!other.isPresent()) {
                this.addTypeMismatch(expected, actual);
                return null;
            }
            this.scan(expected.getExpression(), ((SwitchTree)other.get()).getExpression());
            this.parallelScan(expected.getCases(), ((SwitchTree)other.get()).getCases());
            return null;
        }

        @Override
        public Void visitSynchronized(SynchronizedTree expected, Tree actual) {
            Optional<SynchronizedTree> other = this.checkTypeAndCast(expected, actual);
            if (!other.isPresent()) {
                this.addTypeMismatch(expected, actual);
                return null;
            }
            this.scan(expected.getExpression(), ((SynchronizedTree)other.get()).getExpression());
            this.scan(expected.getBlock(), ((SynchronizedTree)other.get()).getBlock());
            return null;
        }

        @Override
        public Void visitThrow(ThrowTree expected, Tree actual) {
            Optional<ThrowTree> other = this.checkTypeAndCast(expected, actual);
            if (!other.isPresent()) {
                this.addTypeMismatch(expected, actual);
                return null;
            }
            this.scan(expected.getExpression(), ((ThrowTree)other.get()).getExpression());
            return null;
        }

        @Override
        public Void visitCompilationUnit(CompilationUnitTree expected, Tree actual) {
            Optional<CompilationUnitTree> other = this.checkTypeAndCast(expected, actual);
            if (!other.isPresent()) {
                this.addTypeMismatch(expected, actual);
                return null;
            }
            this.parallelScan(expected.getPackageAnnotations(), ((CompilationUnitTree)other.get()).getPackageAnnotations());
            this.scan(expected.getPackageName(), ((CompilationUnitTree)other.get()).getPackageName());
            this.parallelScan(expected.getImports(), ((CompilationUnitTree)other.get()).getImports());
            this.parallelScan(expected.getTypeDecls(), ((CompilationUnitTree)other.get()).getTypeDecls());
            return null;
        }

        @Override
        public Void visitTry(TryTree expected, Tree actual) {
            Optional<TryTree> other = this.checkTypeAndCast(expected, actual);
            if (!other.isPresent()) {
                this.addTypeMismatch(expected, actual);
                return null;
            }
            this.scan(expected.getBlock(), ((TryTree)other.get()).getBlock());
            this.parallelScan(expected.getCatches(), ((TryTree)other.get()).getCatches());
            this.scan(expected.getFinallyBlock(), ((TryTree)other.get()).getFinallyBlock());
            return null;
        }

        @Override
        public Void visitParameterizedType(ParameterizedTypeTree expected, Tree actual) {
            Optional<ParameterizedTypeTree> other = this.checkTypeAndCast(expected, actual);
            if (!other.isPresent()) {
                this.addTypeMismatch(expected, actual);
                return null;
            }
            this.scan(expected.getType(), ((ParameterizedTypeTree)other.get()).getType());
            this.parallelScan(expected.getTypeArguments(), ((ParameterizedTypeTree)other.get()).getTypeArguments());
            return null;
        }

        @Override
        public Void visitArrayType(ArrayTypeTree expected, Tree actual) {
            Optional<ArrayTypeTree> other = this.checkTypeAndCast(expected, actual);
            if (!other.isPresent()) {
                this.addTypeMismatch(expected, actual);
                return null;
            }
            this.scan(expected.getType(), ((ArrayTypeTree)other.get()).getType());
            return null;
        }

        @Override
        public Void visitTypeCast(TypeCastTree expected, Tree actual) {
            Optional<TypeCastTree> other = this.checkTypeAndCast(expected, actual);
            if (!other.isPresent()) {
                this.addTypeMismatch(expected, actual);
                return null;
            }
            this.scan(expected.getType(), ((TypeCastTree)other.get()).getType());
            this.scan(expected.getExpression(), ((TypeCastTree)other.get()).getExpression());
            return null;
        }

        @Override
        public Void visitPrimitiveType(PrimitiveTypeTree expected, Tree actual) {
            Optional<PrimitiveTypeTree> other = this.checkTypeAndCast(expected, actual);
            if (!other.isPresent()) {
                this.addTypeMismatch(expected, actual);
                return null;
            }
            this.checkForDiff(expected.getPrimitiveTypeKind() == ((PrimitiveTypeTree)other.get()).getPrimitiveTypeKind(), "Expected primitive type kind to be <%s> but was <%s>.", new Object[]{expected.getPrimitiveTypeKind(), ((PrimitiveTypeTree)other.get()).getPrimitiveTypeKind()});
            return null;
        }

        @Override
        public Void visitTypeParameter(TypeParameterTree expected, Tree actual) {
            Optional<TypeParameterTree> other = this.checkTypeAndCast(expected, actual);
            if (!other.isPresent()) {
                this.addTypeMismatch(expected, actual);
                return null;
            }
            this.checkForDiff(expected.getName().contentEquals(((TypeParameterTree)other.get()).getName()), "Expected type parameter name to be <%s> but was <%s>.", expected.getName(), ((TypeParameterTree)other.get()).getName());
            this.parallelScan(expected.getBounds(), ((TypeParameterTree)other.get()).getBounds());
            return null;
        }

        @Override
        public Void visitInstanceOf(InstanceOfTree expected, Tree actual) {
            Optional<InstanceOfTree> other = this.checkTypeAndCast(expected, actual);
            if (!other.isPresent()) {
                this.addTypeMismatch(expected, actual);
                return null;
            }
            this.scan(expected.getExpression(), ((InstanceOfTree)other.get()).getExpression());
            this.scan(expected.getType(), ((InstanceOfTree)other.get()).getType());
            return null;
        }

        @Override
        public Void visitUnary(UnaryTree expected, Tree actual) {
            Optional<UnaryTree> other = this.checkTypeAndCast(expected, actual);
            if (!other.isPresent()) {
                this.addTypeMismatch(expected, actual);
                return null;
            }
            this.scan(expected.getExpression(), ((UnaryTree)other.get()).getExpression());
            return null;
        }

        @Override
        public Void visitVariable(VariableTree expected, Tree actual) {
            Optional<VariableTree> other = this.checkTypeAndCast(expected, actual);
            if (!other.isPresent()) {
                this.addTypeMismatch(expected, actual);
                return null;
            }
            this.checkForDiff(expected.getName().contentEquals(((VariableTree)other.get()).getName()), "Expected variable name to be <%s> but was <%s>.", expected.getName(), ((VariableTree)other.get()).getName());
            this.scan(expected.getModifiers(), ((VariableTree)other.get()).getModifiers());
            this.scan(expected.getType(), ((VariableTree)other.get()).getType());
            this.scan(expected.getInitializer(), ((VariableTree)other.get()).getInitializer());
            return null;
        }

        @Override
        public Void visitWhileLoop(WhileLoopTree expected, Tree actual) {
            Optional<WhileLoopTree> other = this.checkTypeAndCast(expected, actual);
            if (!other.isPresent()) {
                this.addTypeMismatch(expected, actual);
                return null;
            }
            this.scan(expected.getCondition(), ((WhileLoopTree)other.get()).getCondition());
            this.scan(expected.getStatement(), ((WhileLoopTree)other.get()).getStatement());
            return null;
        }

        @Override
        public Void visitWildcard(WildcardTree expected, Tree actual) {
            Optional<WildcardTree> other = this.checkTypeAndCast(expected, actual);
            if (!other.isPresent()) {
                this.addTypeMismatch(expected, actual);
                return null;
            }
            this.scan(expected.getBound(), ((WildcardTree)other.get()).getBound());
            return null;
        }

        @Override
        public Void visitOther(Tree expected, Tree actual) {
            throw new UnsupportedOperationException("cannot compare unknown trees");
        }

        private <T extends Tree> Optional<T> checkTypeAndCast(T expected, Tree actual) {
            Tree.Kind treeKind;
            Tree.Kind expectedKind = ((Tree)Preconditions.checkNotNull(expected)).getKind();
            if (expectedKind == (treeKind = ((Tree)Preconditions.checkNotNull((Object)actual)).getKind())) {
                Tree treeAsExpectedType = actual;
                return Optional.of((Object)treeAsExpectedType);
            }
            return Optional.absent();
        }
    }
}

