/*
 * Decompiled with CFR 0.152.
 */
package com.sun.tools.javac.file;

import com.sun.tools.javac.code.Lint;
import com.sun.tools.javac.file.FSInfo;
import com.sun.tools.javac.file.JavacFileManager;
import com.sun.tools.javac.main.Option;
import com.sun.tools.javac.util.ListBuffer;
import com.sun.tools.javac.util.Log;
import com.sun.tools.javac.util.StringUtils;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.UncheckedIOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.EnumMap;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import java.util.zip.ZipFile;
import javax.tools.JavaFileManager;
import javax.tools.StandardLocation;

public class Locations {
    private Log log;
    private FSInfo fsInfo;
    private boolean warn;
    static final Path JRT_MARKER_FILE = Paths.get("JRT_MARKER_FILE", new String[0]);
    Map<JavaFileManager.Location, LocationHandler> handlersForLocation;
    Map<Option, LocationHandler> handlersForOption;

    Locations() {
        this.initHandlers();
    }

    void update(Log log, Lint lint, FSInfo fsInfo) {
        this.log = log;
        this.warn = lint.isEnabled(Lint.LintCategory.PATH);
        this.fsInfo = fsInfo;
    }

    public Collection<Path> bootClassPath() {
        return this.getLocation(StandardLocation.PLATFORM_CLASS_PATH);
    }

    boolean isDefaultBootClassPath() {
        BootClassPathLocationHandler h = (BootClassPathLocationHandler)this.getHandler(StandardLocation.PLATFORM_CLASS_PATH);
        return h.isDefault();
    }

    public Collection<Path> userClassPath() {
        return this.getLocation(StandardLocation.CLASS_PATH);
    }

    public Collection<Path> sourcePath() {
        Collection<Path> p = this.getLocation(StandardLocation.SOURCE_PATH);
        return p == null || p.isEmpty() ? null : p;
    }

    private static Iterable<Path> getPathEntries(String searchPath) {
        return Locations.getPathEntries(searchPath, null);
    }

    private static Iterable<Path> getPathEntries(String searchPath, Path emptyPathDefault) {
        ListBuffer<Path> entries = new ListBuffer<Path>();
        for (String s : searchPath.split(Pattern.quote(File.pathSeparator), -1)) {
            if (s.isEmpty()) {
                if (emptyPathDefault == null) continue;
                entries.add(emptyPathDefault);
                continue;
            }
            entries.add(Paths.get(s, new String[0]));
        }
        return entries;
    }

    void initHandlers() {
        LocationHandler[] handlers;
        this.handlersForLocation = new HashMap<JavaFileManager.Location, LocationHandler>();
        this.handlersForOption = new EnumMap<Option, LocationHandler>(Option.class);
        for (LocationHandler h : handlers = new LocationHandler[]{new BootClassPathLocationHandler(), new ClassPathLocationHandler(), new SimpleLocationHandler(StandardLocation.SOURCE_PATH, Option.SOURCEPATH), new SimpleLocationHandler(StandardLocation.ANNOTATION_PROCESSOR_PATH, Option.PROCESSORPATH), new OutputLocationHandler(StandardLocation.CLASS_OUTPUT, Option.D), new OutputLocationHandler(StandardLocation.SOURCE_OUTPUT, Option.S), new OutputLocationHandler(StandardLocation.NATIVE_HEADER_OUTPUT, Option.H)}) {
            this.handlersForLocation.put(h.location, h);
            for (Option o : h.options) {
                this.handlersForOption.put(o, h);
            }
        }
    }

    boolean handleOption(Option option, String value) {
        LocationHandler h = this.handlersForOption.get((Object)option);
        return h == null ? false : h.handleOption(option, value);
    }

    Collection<Path> getLocation(JavaFileManager.Location location) {
        LocationHandler h = this.getHandler(location);
        return h == null ? null : h.getLocation();
    }

    Path getOutputLocation(JavaFileManager.Location location) {
        if (!location.isOutputLocation()) {
            throw new IllegalArgumentException();
        }
        LocationHandler h = this.getHandler(location);
        return ((OutputLocationHandler)h).outputDir;
    }

    void setLocation(JavaFileManager.Location location, Iterable<? extends Path> files) throws IOException {
        LocationHandler h = this.getHandler(location);
        if (h == null) {
            h = location.isOutputLocation() ? new OutputLocationHandler(location, new Option[0]) : new SimpleLocationHandler(location, new Option[0]);
            this.handlersForLocation.put(location, h);
        }
        h.setLocation(files);
    }

    protected LocationHandler getHandler(JavaFileManager.Location location) {
        Objects.requireNonNull(location);
        return this.handlersForLocation.get(location);
    }

    private boolean isArchive(Path file) {
        String n = StringUtils.toLowerCase(file.getFileName().toString());
        return this.fsInfo.isFile(file) && (n.endsWith(".jar") || n.endsWith(".zip"));
    }

    private class BootClassPathLocationHandler
    extends LocationHandler {
        private Collection<Path> searchPath;
        final Map<Option, String> optionValues;
        private boolean isDefault;

        BootClassPathLocationHandler() {
            super(StandardLocation.PLATFORM_CLASS_PATH, Option.BOOTCLASSPATH, Option.XBOOTCLASSPATH, Option.XBOOTCLASSPATH_PREPEND, Option.XBOOTCLASSPATH_APPEND, Option.ENDORSEDDIRS, Option.DJAVA_ENDORSED_DIRS, Option.EXTDIRS, Option.DJAVA_EXT_DIRS);
            this.optionValues = new EnumMap<Option, String>(Option.class);
        }

        boolean isDefault() {
            this.lazy();
            return this.isDefault;
        }

        @Override
        boolean handleOption(Option option, String value) {
            if (!this.options.contains((Object)option)) {
                return false;
            }
            option = this.canonicalize(option);
            this.optionValues.put(option, value);
            if (option == Option.BOOTCLASSPATH) {
                this.optionValues.remove((Object)Option.XBOOTCLASSPATH_PREPEND);
                this.optionValues.remove((Object)Option.XBOOTCLASSPATH_APPEND);
            }
            this.searchPath = null;
            return true;
        }

        private Option canonicalize(Option option) {
            switch (option) {
                case XBOOTCLASSPATH: {
                    return Option.BOOTCLASSPATH;
                }
                case DJAVA_ENDORSED_DIRS: {
                    return Option.ENDORSEDDIRS;
                }
                case DJAVA_EXT_DIRS: {
                    return Option.EXTDIRS;
                }
            }
            return option;
        }

        @Override
        Collection<Path> getLocation() {
            this.lazy();
            return this.searchPath;
        }

        @Override
        void setLocation(Iterable<? extends Path> files) {
            if (files == null) {
                this.searchPath = null;
            } else {
                this.isDefault = false;
                SearchPath p = new SearchPath().addFiles(files, false);
                this.searchPath = Collections.unmodifiableCollection(p);
                this.optionValues.clear();
            }
        }

        SearchPath computePath() throws IOException {
            String java_home = System.getProperty("java.home");
            SearchPath path = new SearchPath();
            String bootclasspathOpt = this.optionValues.get((Object)Option.BOOTCLASSPATH);
            String endorseddirsOpt = this.optionValues.get((Object)Option.ENDORSEDDIRS);
            String extdirsOpt = this.optionValues.get((Object)Option.EXTDIRS);
            String xbootclasspathPrependOpt = this.optionValues.get((Object)Option.XBOOTCLASSPATH_PREPEND);
            String xbootclasspathAppendOpt = this.optionValues.get((Object)Option.XBOOTCLASSPATH_APPEND);
            path.addFiles(xbootclasspathPrependOpt);
            if (endorseddirsOpt != null) {
                path.addDirectories(endorseddirsOpt);
            } else {
                path.addDirectories(System.getProperty("java.endorsed.dirs"), false);
            }
            if (bootclasspathOpt != null) {
                path.addFiles(bootclasspathOpt);
            } else {
                Collection<Path> systemClasses = this.systemClasses(java_home);
                if (systemClasses != null) {
                    path.addFiles(systemClasses, false);
                } else {
                    String files = System.getProperty("sun.boot.class.path");
                    path.addFiles(files, false);
                }
            }
            path.addFiles(xbootclasspathAppendOpt);
            if (extdirsOpt != null) {
                path.addDirectories(extdirsOpt);
            } else {
                Path jfxrt = Paths.get(java_home, "lib", "jfxrt.jar");
                if (Files.exists(jfxrt, new LinkOption[0])) {
                    path.addFile(jfxrt, false);
                }
                path.addDirectories(System.getProperty("java.ext.dirs"), false);
            }
            this.isDefault = xbootclasspathPrependOpt == null && bootclasspathOpt == null && xbootclasspathAppendOpt == null;
            return path;
        }

        private Collection<Path> systemClasses(String java_home) throws IOException {
            Path modules;
            Path libModules = Paths.get(java_home, "lib", "modules");
            if (Files.exists(libModules, new LinkOption[0])) {
                try (Stream<Path> files = Files.list(libModules);){
                    boolean haveJImageFiles = files.anyMatch(f -> f.getFileName().toString().endsWith(".jimage"));
                    if (haveJImageFiles) {
                        Collection<Path> collection = this.addAdditionalBootEntries(Collections.singleton(JRT_MARKER_FILE));
                        return collection;
                    }
                }
            }
            if (Files.isDirectory((modules = Paths.get(java_home, "modules")).resolve("java.base"), new LinkOption[0])) {
                try (Stream<Path> listedModules = Files.list(modules);){
                    Collection<Path> collection = this.addAdditionalBootEntries(listedModules.collect(Collectors.toList()));
                    return collection;
                }
            }
            return null;
        }

        private Collection<Path> addAdditionalBootEntries(Collection<Path> modules) throws IOException {
            String files = System.getProperty("sun.boot.class.path");
            if (files == null) {
                return modules;
            }
            LinkedHashSet<Path> paths = new LinkedHashSet<Path>();
            for (String s : files.split(Pattern.quote(File.pathSeparator))) {
                if (s.endsWith(".jimage")) {
                    paths.addAll(modules);
                    continue;
                }
                if (s.isEmpty()) continue;
                paths.add(Paths.get(s, new String[0]));
            }
            return paths;
        }

        private void lazy() {
            if (this.searchPath == null) {
                try {
                    this.searchPath = Collections.unmodifiableCollection(this.computePath());
                }
                catch (IOException e) {
                    throw new UncheckedIOException(e);
                }
            }
        }
    }

    private class ClassPathLocationHandler
    extends SimpleLocationHandler {
        ClassPathLocationHandler() {
            super(StandardLocation.CLASS_PATH, Option.CLASSPATH, Option.CP);
        }

        @Override
        Collection<Path> getLocation() {
            this.lazy();
            return this.searchPath;
        }

        @Override
        protected SearchPath computePath(String value) {
            String cp = value;
            if (cp == null) {
                cp = System.getProperty("env.class.path");
            }
            if (cp == null && System.getProperty("application.home") == null) {
                cp = System.getProperty("java.class.path");
            }
            if (cp == null) {
                cp = ".";
            }
            return this.createPath().addFiles(cp);
        }

        @Override
        protected SearchPath createPath() {
            return new SearchPath().expandJarClassPaths(true).emptyPathDefault(Paths.get(".", new String[0]));
        }

        private void lazy() {
            if (this.searchPath == null) {
                this.setLocation(null);
            }
        }
    }

    private class SimpleLocationHandler
    extends LocationHandler {
        protected Collection<Path> searchPath;

        SimpleLocationHandler(JavaFileManager.Location location, Option ... options) {
            super(location, options);
        }

        @Override
        boolean handleOption(Option option, String value) {
            if (!this.options.contains((Object)option)) {
                return false;
            }
            this.searchPath = value == null ? null : Collections.unmodifiableCollection(this.createPath().addFiles(value));
            return true;
        }

        @Override
        Collection<Path> getLocation() {
            return this.searchPath;
        }

        @Override
        void setLocation(Iterable<? extends Path> files) {
            SearchPath p = files == null ? this.computePath(null) : this.createPath().addFiles(files);
            this.searchPath = Collections.unmodifiableCollection(p);
        }

        protected SearchPath computePath(String value) {
            return this.createPath().addFiles(value);
        }

        protected SearchPath createPath() {
            return new SearchPath();
        }
    }

    private class OutputLocationHandler
    extends LocationHandler {
        private Path outputDir;

        OutputLocationHandler(JavaFileManager.Location location, Option ... options) {
            super(location, options);
        }

        @Override
        boolean handleOption(Option option, String value) {
            if (!this.options.contains((Object)option)) {
                return false;
            }
            this.outputDir = value == null ? null : Paths.get(value, new String[0]);
            return true;
        }

        @Override
        Collection<Path> getLocation() {
            return this.outputDir == null ? null : Collections.singleton(this.outputDir);
        }

        @Override
        void setLocation(Iterable<? extends Path> files) throws IOException {
            if (files == null) {
                this.outputDir = null;
            } else {
                Iterator<? extends Path> pathIter = files.iterator();
                if (!pathIter.hasNext()) {
                    throw new IllegalArgumentException("empty path for directory");
                }
                Path dir = pathIter.next();
                if (pathIter.hasNext()) {
                    throw new IllegalArgumentException("path too long for directory");
                }
                if (!Files.exists(dir, new LinkOption[0])) {
                    throw new FileNotFoundException(dir + ": does not exist");
                }
                if (!Files.isDirectory(dir, new LinkOption[0])) {
                    throw new IOException(dir + ": not a directory");
                }
                this.outputDir = dir;
            }
        }
    }

    protected abstract class LocationHandler {
        final JavaFileManager.Location location;
        final Set<Option> options;

        protected LocationHandler(JavaFileManager.Location location, Option ... options) {
            this.location = location;
            this.options = options.length == 0 ? EnumSet.noneOf(Option.class) : EnumSet.copyOf(Arrays.asList(options));
        }

        abstract boolean handleOption(Option var1, String var2);

        abstract Collection<Path> getLocation();

        abstract void setLocation(Iterable<? extends Path> var1) throws IOException;
    }

    private class SearchPath
    extends LinkedHashSet<Path> {
        private static final long serialVersionUID = 0L;
        private boolean expandJarClassPaths = false;
        private final Set<Path> canonicalValues = new HashSet<Path>();
        private Path emptyPathDefault = null;

        private SearchPath() {
        }

        public SearchPath expandJarClassPaths(boolean x) {
            this.expandJarClassPaths = x;
            return this;
        }

        public SearchPath emptyPathDefault(Path x) {
            this.emptyPathDefault = x;
            return this;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public SearchPath addDirectories(String dirs, boolean warn) {
            boolean prev = this.expandJarClassPaths;
            this.expandJarClassPaths = true;
            try {
                if (dirs != null) {
                    for (Path dir : Locations.getPathEntries(dirs)) {
                        this.addDirectory(dir, warn);
                    }
                }
                SearchPath searchPath = this;
                return searchPath;
            }
            finally {
                this.expandJarClassPaths = prev;
            }
        }

        public SearchPath addDirectories(String dirs) {
            return this.addDirectories(dirs, Locations.this.warn);
        }

        private void addDirectory(Path dir, boolean warn) {
            if (!Files.isDirectory(dir, new LinkOption[0])) {
                if (warn) {
                    Locations.this.log.warning(Lint.LintCategory.PATH, "dir.path.element.not.found", dir);
                }
                return;
            }
            try (Stream<Path> s = Files.list(dir);){
                s.filter(dirEntry -> Locations.this.isArchive(dirEntry)).forEach(dirEntry -> this.addFile((Path)dirEntry, warn));
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }

        public SearchPath addFiles(String files, boolean warn) {
            if (files != null) {
                this.addFiles(Locations.getPathEntries(files, this.emptyPathDefault), warn);
            }
            return this;
        }

        public SearchPath addFiles(String files) {
            return this.addFiles(files, Locations.this.warn);
        }

        public SearchPath addFiles(Iterable<? extends Path> files, boolean warn) {
            if (files != null) {
                for (Path path : files) {
                    this.addFile(path, warn);
                }
            }
            return this;
        }

        public SearchPath addFiles(Iterable<? extends Path> files) {
            return this.addFiles(files, Locations.this.warn);
        }

        public void addFile(Path file, boolean warn) {
            if (this.contains(file)) {
                return;
            }
            if (!Locations.this.fsInfo.exists(file)) {
                if (warn) {
                    Locations.this.log.warning(Lint.LintCategory.PATH, "path.element.not.found", file);
                }
                super.add(file);
                return;
            }
            Path canonFile = Locations.this.fsInfo.getCanonicalFile(file);
            if (this.canonicalValues.contains(canonFile)) {
                return;
            }
            if (Locations.this.fsInfo.isFile(file) && !Locations.this.isArchive(file) && !file.getFileName().toString().endsWith(".jimage")) {
                try {
                    ZipFile z = new ZipFile(file.toFile());
                    z.close();
                    if (warn) {
                        Locations.this.log.warning(Lint.LintCategory.PATH, "unexpected.archive.file", file);
                    }
                }
                catch (IOException e) {
                    if (warn) {
                        Locations.this.log.warning(Lint.LintCategory.PATH, "invalid.archive.file", file);
                    }
                    return;
                }
            }
            super.add(file);
            this.canonicalValues.add(canonFile);
            if (this.expandJarClassPaths && Locations.this.fsInfo.isFile(file) && !file.getFileName().toString().endsWith(".jimage")) {
                this.addJarClassPath(file, warn);
            }
        }

        private void addJarClassPath(Path jarFile, boolean warn) {
            try {
                for (Path f : Locations.this.fsInfo.getJarClassPath(jarFile)) {
                    this.addFile(f, warn);
                }
            }
            catch (IOException e) {
                Locations.this.log.error("error.reading.file", jarFile, JavacFileManager.getMessage(e));
            }
        }
    }
}

