/*
 * Decompiled with CFR 0.152.
 */
package com.google.errorprone.matchers;

import com.google.errorprone.VisitorState;
import com.google.errorprone.matchers.AnnotationMatcherUtils;
import com.google.errorprone.matchers.Matcher;
import com.sun.source.tree.AnnotationTree;
import com.sun.source.tree.ExpressionTree;
import com.sun.source.tree.NewArrayTree;
import com.sun.source.tree.ParenthesizedTree;

public class AnnotationHasArgumentWithValue
implements Matcher<AnnotationTree> {
    private final String element;
    private final Matcher<ExpressionTree> valueMatcher;

    public AnnotationHasArgumentWithValue(String element, Matcher<ExpressionTree> valueMatcher) {
        this.element = element;
        this.valueMatcher = valueMatcher;
    }

    @Override
    public boolean matches(AnnotationTree annotationTree, VisitorState state) {
        ExpressionTree expressionTree = AnnotationMatcherUtils.getArgument(annotationTree, this.element);
        if (expressionTree == null) {
            return false;
        }
        while (expressionTree instanceof ParenthesizedTree) {
            expressionTree = ((ParenthesizedTree)expressionTree).getExpression();
        }
        if (expressionTree instanceof NewArrayTree) {
            NewArrayTree arrayTree = (NewArrayTree)expressionTree;
            for (ExpressionTree expressionTree2 : arrayTree.getInitializers()) {
                if (!this.valueMatcher.matches(expressionTree2, state)) continue;
                return true;
            }
            return false;
        }
        return this.valueMatcher.matches(expressionTree, state);
    }
}

