/*
 * Decompiled with CFR 0.152.
 */
package com.google.turbine.type;

import com.google.common.base.Joiner;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.turbine.binder.sym.ClassSymbol;
import com.google.turbine.binder.sym.TyVarSymbol;
import com.google.turbine.model.TurbineConstantTypeKind;
import com.google.turbine.type.AnnoInfo;
import java.util.Arrays;

public interface Type {
    public static final Type VOID = new Type(){

        @Override
        public TyKind tyKind() {
            return TyKind.VOID_TY;
        }
    };

    public TyKind tyKind();

    public static class WildUnboundedTy
    extends WildTy {
        private final ImmutableList<AnnoInfo> annotations;

        public WildUnboundedTy(ImmutableList<AnnoInfo> annotations) {
            this.annotations = annotations;
        }

        @Override
        public WildTy.BoundKind boundKind() {
            return WildTy.BoundKind.NONE;
        }

        @Override
        public Type bound() {
            throw new IllegalStateException();
        }

        @Override
        public ImmutableList<AnnoInfo> annotations() {
            return this.annotations;
        }
    }

    public static class WildLowerBoundedTy
    extends WildTy {
        public final Type bound;
        private final ImmutableList<AnnoInfo> annotations;

        public WildLowerBoundedTy(Type bound, ImmutableList<AnnoInfo> annotations) {
            this.bound = bound;
            this.annotations = annotations;
        }

        @Override
        public Type bound() {
            return this.bound;
        }

        @Override
        public WildTy.BoundKind boundKind() {
            return WildTy.BoundKind.LOWER;
        }

        @Override
        public ImmutableList<AnnoInfo> annotations() {
            return this.annotations;
        }
    }

    public static class WildUpperBoundedTy
    extends WildTy {
        public final Type bound;
        private final ImmutableList<AnnoInfo> annotations;

        public WildUpperBoundedTy(Type bound, ImmutableList<AnnoInfo> annotations) {
            this.bound = bound;
            this.annotations = annotations;
        }

        @Override
        public Type bound() {
            return this.bound;
        }

        @Override
        public ImmutableList<AnnoInfo> annotations() {
            return this.annotations;
        }

        @Override
        public WildTy.BoundKind boundKind() {
            return WildTy.BoundKind.UPPER;
        }
    }

    public static abstract class WildTy
    implements Type {
        public abstract BoundKind boundKind();

        public abstract Type bound();

        public abstract ImmutableList<AnnoInfo> annotations();

        @Override
        public TyKind tyKind() {
            return TyKind.WILD_TY;
        }

        public static enum BoundKind {
            NONE,
            UPPER,
            LOWER;

        }
    }

    public static class PrimTy
    implements Type {
        private final TurbineConstantTypeKind primtkind;
        private final ImmutableList<AnnoInfo> annos;

        public PrimTy(TurbineConstantTypeKind tykind, ImmutableList<AnnoInfo> annos) {
            this.primtkind = tykind;
            this.annos = annos;
        }

        public TurbineConstantTypeKind primkind() {
            return this.primtkind;
        }

        @Override
        public TyKind tyKind() {
            return TyKind.PRIM_TY;
        }

        public ImmutableList<AnnoInfo> annos() {
            return this.annos;
        }
    }

    public static class TyVar
    implements Type {
        private final TyVarSymbol sym;
        private final ImmutableList<AnnoInfo> annos;

        public TyVar(TyVarSymbol sym, ImmutableList<AnnoInfo> annos) {
            this.sym = sym;
            this.annos = annos;
        }

        public TyVarSymbol sym() {
            return this.sym;
        }

        @Override
        public TyKind tyKind() {
            return TyKind.TY_VAR;
        }

        public String toString() {
            return this.sym.owner() + "#" + this.sym.name();
        }

        public ImmutableList<AnnoInfo> annos() {
            return this.annos;
        }
    }

    public static class ArrayTy
    implements Type {
        private final Type elem;
        private final ImmutableList<AnnoInfo> annos;

        public ArrayTy(Type elem, ImmutableList<AnnoInfo> annos) {
            this.elem = elem;
            this.annos = annos;
        }

        public Type elementType() {
            return this.elem;
        }

        @Override
        public TyKind tyKind() {
            return TyKind.ARRAY_TY;
        }

        public ImmutableList<AnnoInfo> annos() {
            return this.annos;
        }
    }

    public static class ClassTy
    implements Type {
        public static final ClassTy OBJECT = ClassTy.asNonParametricClassTy(ClassSymbol.OBJECT);
        public static final ClassTy STRING = ClassTy.asNonParametricClassTy(ClassSymbol.STRING);
        public final ImmutableList<SimpleClassTy> classes;

        public static ClassTy asNonParametricClassTy(ClassSymbol i) {
            return new ClassTy(Arrays.asList(new SimpleClassTy(i, (ImmutableList<Type>)ImmutableList.of(), (ImmutableList<AnnoInfo>)ImmutableList.of())));
        }

        public ClassTy(Iterable<SimpleClassTy> classes) {
            this.classes = ImmutableList.copyOf(classes);
        }

        @Override
        public TyKind tyKind() {
            return TyKind.CLASS_TY;
        }

        public ClassSymbol sym() {
            return ((SimpleClassTy)this.classes.get(this.classes.size() - 1)).sym;
        }

        public String toString() {
            StringBuilder sb = new StringBuilder();
            boolean first = true;
            for (SimpleClassTy c : this.classes) {
                if (!first) {
                    sb.append('.');
                    sb.append(c.sym.toString().substring(c.sym.toString().lastIndexOf(36) + 1));
                } else {
                    sb.append(c.sym);
                }
                if (!c.targs.isEmpty()) {
                    sb.append('<');
                    Joiner.on((char)',').appendTo(sb, (Iterable)c.targs);
                    sb.append('>');
                }
                first = false;
            }
            return sb.toString();
        }

        public static class SimpleClassTy {
            private final ClassSymbol sym;
            private final ImmutableList<Type> targs;
            private final ImmutableList<AnnoInfo> annos;

            public SimpleClassTy(ClassSymbol sym, ImmutableList<Type> targs, ImmutableList<AnnoInfo> annos) {
                Preconditions.checkNotNull((Object)sym);
                Preconditions.checkNotNull(targs);
                this.sym = sym;
                this.targs = targs;
                this.annos = annos;
            }

            public ClassSymbol sym() {
                return this.sym;
            }

            public ImmutableList<Type> targs() {
                return this.targs;
            }

            public ImmutableList<AnnoInfo> annos() {
                return this.annos;
            }
        }
    }

    public static enum TyKind {
        PRIM_TY,
        VOID_TY,
        CLASS_TY,
        ARRAY_TY,
        TY_VAR,
        WILD_TY;

    }
}

