/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.client.impl.protocol.task;

import com.hazelcast.client.ClientEndpoint;
import com.hazelcast.client.impl.ClientEndpointImpl;
import com.hazelcast.client.impl.client.ClientPrincipal;
import com.hazelcast.client.impl.operations.ClientReAuthOperation;
import com.hazelcast.client.impl.protocol.AuthenticationStatus;
import com.hazelcast.client.impl.protocol.ClientMessage;
import com.hazelcast.client.impl.protocol.task.AbstractCallableMessageTask;
import com.hazelcast.config.GroupConfig;
import com.hazelcast.core.Member;
import com.hazelcast.instance.Node;
import com.hazelcast.logging.ILogger;
import com.hazelcast.nio.Address;
import com.hazelcast.nio.Connection;
import com.hazelcast.nio.ConnectionType;
import com.hazelcast.security.Credentials;
import com.hazelcast.security.SecurityContext;
import com.hazelcast.security.UsernamePasswordCredentials;
import com.hazelcast.util.UuidUtil;
import java.security.Permission;
import java.util.Set;
import java.util.logging.Level;
import javax.security.auth.login.LoginContext;
import javax.security.auth.login.LoginException;

public abstract class AuthenticationBaseMessageTask<P>
extends AbstractCallableMessageTask<P> {
    protected transient ClientPrincipal principal;
    protected transient Credentials credentials;
    protected transient byte clientSerializationVersion;

    public AuthenticationBaseMessageTask(ClientMessage clientMessage, Node node, Connection connection) {
        super(clientMessage, node, connection);
    }

    @Override
    protected ClientEndpointImpl getEndpoint() {
        if (this.connection.isAlive()) {
            return new ClientEndpointImpl(this.clientEngine, this.connection);
        }
        this.handleEndpointNotCreatedConnectionNotAlive();
        return null;
    }

    @Override
    protected boolean isAuthenticationMessage() {
        return true;
    }

    private void handleEndpointNotCreatedConnectionNotAlive() {
        this.logger.warning("Dropped: " + this.clientMessage + " -> endpoint not created for AuthenticationRequest, connection not alive");
    }

    @Override
    public Object call() {
        byte serializationServiceVersion = this.serializationService.getVersion();
        AuthenticationStatus authenticationStatus = this.clientSerializationVersion != serializationServiceVersion ? AuthenticationStatus.SERIALIZATION_VERSION_MISMATCH : this.authenticate();
        switch (authenticationStatus) {
            case AUTHENTICATED: {
                return this.handleAuthenticated();
            }
            case CREDENTIALS_FAILED: {
                return this.handleUnauthenticated();
            }
            case SERIALIZATION_VERSION_MISMATCH: {
                return this.handleSerializationVersionMismatch();
            }
        }
        throw new IllegalStateException("Unsupported authentication status :" + (Object)((Object)authenticationStatus));
    }

    private AuthenticationStatus authenticate() {
        AuthenticationStatus status;
        ILogger logger = this.clientEngine.getLogger(this.getClass());
        if (this.credentials == null) {
            status = AuthenticationStatus.CREDENTIALS_FAILED;
            logger.severe("Could not retrieve Credentials object!");
        } else if (this.clientEngine.getSecurityContext() != null) {
            status = this.authenticate(this.clientEngine.getSecurityContext());
        } else if (this.credentials instanceof UsernamePasswordCredentials) {
            UsernamePasswordCredentials usernamePasswordCredentials = (UsernamePasswordCredentials)this.credentials;
            status = this.authenticate(usernamePasswordCredentials);
        } else {
            status = AuthenticationStatus.CREDENTIALS_FAILED;
            logger.severe("Hazelcast security is disabled.\nUsernamePasswordCredentials or cluster group-name and group-password should be used for authentication!\nCurrent credentials type is: " + this.credentials.getClass().getName());
        }
        return status;
    }

    private AuthenticationStatus authenticate(SecurityContext securityContext) {
        Connection connection = this.endpoint.getConnection();
        this.credentials.setEndpoint(connection.getInetAddress().getHostAddress());
        try {
            LoginContext lc = securityContext.createClientLoginContext(this.credentials);
            lc.login();
            this.endpoint.setLoginContext(lc);
            return AuthenticationStatus.AUTHENTICATED;
        }
        catch (LoginException e) {
            this.logger.warning(e);
            return AuthenticationStatus.CREDENTIALS_FAILED;
        }
    }

    private AuthenticationStatus authenticate(UsernamePasswordCredentials credentials) {
        GroupConfig groupConfig = this.nodeEngine.getConfig().getGroupConfig();
        String nodeGroupName = groupConfig.getName();
        String nodeGroupPassword = groupConfig.getPassword();
        boolean usernameMatch = nodeGroupName.equals(credentials.getUsername());
        boolean passwordMatch = nodeGroupPassword.equals(credentials.getPassword());
        return usernameMatch && passwordMatch ? AuthenticationStatus.AUTHENTICATED : AuthenticationStatus.CREDENTIALS_FAILED;
    }

    private Object handleUnauthenticated() {
        Connection connection = this.endpoint.getConnection();
        ILogger logger = this.clientEngine.getLogger(this.getClass());
        logger.log(Level.WARNING, "Received auth from " + connection + " with principal " + this.principal + " , authentication failed");
        byte status = AuthenticationStatus.CREDENTIALS_FAILED.getId();
        return this.encodeAuth(status, null, null, null, this.serializationService.getVersion());
    }

    private Object handleSerializationVersionMismatch() {
        return this.encodeAuth(AuthenticationStatus.SERIALIZATION_VERSION_MISMATCH.getId(), null, null, null, this.serializationService.getVersion());
    }

    private ClientMessage handleAuthenticated() {
        boolean isNotMember;
        if (this.isOwnerConnection()) {
            String uuid = this.getUuid();
            String localMemberUUID = this.clientEngine.getLocalMember().getUuid();
            this.principal = new ClientPrincipal(uuid, localMemberUUID);
            this.reAuthLocal();
            Set<Member> members = this.nodeEngine.getClusterService().getMembers();
            for (Member member : members) {
                if (member.localMember()) continue;
                ClientReAuthOperation op = new ClientReAuthOperation(uuid);
                op.setCallerUuid(localMemberUUID);
                this.nodeEngine.getOperationService().send(op, member.getAddress());
            }
        }
        boolean bl = isNotMember = this.clientEngine.getClusterService().getMember(this.principal.getOwnerUuid()) == null;
        if (isNotMember) {
            byte status = AuthenticationStatus.CREDENTIALS_FAILED.getId();
            return this.encodeAuth(status, null, null, null, this.serializationService.getVersion());
        }
        Connection connection = this.endpoint.getConnection();
        ILogger logger = this.clientEngine.getLogger(this.getClass());
        this.endpoint.authenticated(this.principal, this.credentials, this.isOwnerConnection());
        this.setConnectionType();
        logger.log(Level.INFO, "Received auth from " + connection + ", successfully authenticated" + ", principal : " + this.principal + ", owner connection : " + this.isOwnerConnection());
        this.endpointManager.registerEndpoint(this.endpoint);
        this.clientEngine.bind(this.endpoint);
        Address thisAddress = this.clientEngine.getThisAddress();
        byte status = AuthenticationStatus.AUTHENTICATED.getId();
        return this.encodeAuth(status, thisAddress, this.principal.getUuid(), this.principal.getOwnerUuid(), this.serializationService.getVersion());
    }

    private void setConnectionType() {
        String type = this.getClientType();
        if ("JVM".equals(type)) {
            this.connection.setType(ConnectionType.JAVA_CLIENT);
        } else if ("CSP".equals(type)) {
            this.connection.setType(ConnectionType.CSHARP_CLIENT);
        } else if ("CPP".equals(type)) {
            this.connection.setType(ConnectionType.CPP_CLIENT);
        } else if ("PYH".equals(type)) {
            this.connection.setType(ConnectionType.PYTHON_CLIENT);
        } else if ("RBY".equals(type)) {
            this.connection.setType(ConnectionType.RUBY_CLIENT);
        } else {
            this.clientEngine.getLogger(this.getClass()).info("Unknown client type: " + type);
            this.connection.setType(ConnectionType.BINARY_CLIENT);
        }
    }

    protected abstract ClientMessage encodeAuth(byte var1, Address var2, String var3, String var4, byte var5);

    protected abstract boolean isOwnerConnection();

    protected abstract String getClientType();

    private String getUuid() {
        if (this.principal != null) {
            return this.principal.getUuid();
        }
        return UuidUtil.createClientUuid(this.endpoint.getConnection().getEndPoint());
    }

    private void reAuthLocal() {
        Set<ClientEndpoint> endpoints = this.endpointManager.getEndpoints(this.principal.getUuid());
        for (ClientEndpoint endpoint : endpoints) {
            endpoint.authenticated(this.principal);
        }
        this.clientEngine.addOwnershipMapping(this.principal.getUuid(), this.principal.getOwnerUuid());
    }

    @Override
    public Permission getRequiredPermission() {
        return null;
    }
}

