/*
 * Decompiled with CFR 0.152.
 */
package com.google.common.collect.testing.google;

import com.google.common.annotations.GwtCompatible;
import com.google.common.collect.testing.Helpers;
import com.google.common.collect.testing.features.CollectionSize;
import com.google.common.collect.testing.features.MapFeature;
import com.google.common.collect.testing.google.AbstractBiMapTester;
import java.util.Map;

@GwtCompatible
public class BiMapPutTester<K, V>
extends AbstractBiMapTester<K, V> {
    @MapFeature.Require(value={MapFeature.SUPPORTS_PUT})
    @CollectionSize.Require(value={CollectionSize.ZERO})
    public void testPutWithSameValueFails() {
        this.getMap().put(this.k0(), this.v0());
        try {
            this.getMap().put(this.k1(), this.v0());
            BiMapPutTester.fail((String)"Expected IllegalArgumentException");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        this.expectAdded((Map.Entry)this.e0());
    }

    @MapFeature.Require(value={MapFeature.SUPPORTS_PUT})
    @CollectionSize.Require(value={CollectionSize.ZERO})
    public void testPutPresentKeyDifferentValue() {
        this.getMap().put(this.k0(), this.v0());
        this.getMap().put(this.k0(), this.v1());
        this.expectContents(Helpers.mapEntry(this.k0(), this.v1()));
    }

    @MapFeature.Require(value={MapFeature.SUPPORTS_PUT})
    @CollectionSize.Require(value={CollectionSize.ZERO})
    public void putDistinctKeysDistinctValues() {
        this.getMap().put(this.k0(), this.v0());
        this.getMap().put(this.k1(), this.v1());
        this.expectAdded((Map.Entry)this.e0(), (Map.Entry)this.e1());
    }

    @MapFeature.Require(value={MapFeature.SUPPORTS_PUT})
    @CollectionSize.Require(value={CollectionSize.ZERO})
    public void testForcePutOverwritesOldValueEntry() {
        this.getMap().put(this.k0(), this.v0());
        this.getMap().forcePut(this.k1(), this.v0());
        this.expectAdded(Helpers.mapEntry(this.k1(), this.v0()));
    }

    @MapFeature.Require(value={MapFeature.SUPPORTS_PUT})
    @CollectionSize.Require(value={CollectionSize.ZERO})
    public void testInversePut() {
        this.getMap().put(this.k0(), this.v0());
        this.getMap().inverse().put(this.v1(), this.k1());
        this.expectAdded((Map.Entry)this.e0(), (Map.Entry)this.e1());
    }
}

