/*
 * Decompiled with CFR 0.152.
 */
package com.google.protobuf.util;

import com.google.protobuf.Duration;
import com.google.protobuf.Timestamp;
import com.google.protobuf.util.Durations;
import com.google.protobuf.util.Timestamps;
import java.math.BigInteger;
import java.text.ParseException;

@Deprecated
public final class TimeUtil {
    public static final long TIMESTAMP_SECONDS_MIN = -62135596800L;
    public static final long TIMESTAMP_SECONDS_MAX = 253402300799L;
    public static final long DURATION_SECONDS_MIN = -315576000000L;
    public static final long DURATION_SECONDS_MAX = 315576000000L;
    private static final long NANOS_PER_SECOND = 1000000000L;
    private static final BigInteger NANOS_PER_SECOND_BIG_INTEGER = new BigInteger(String.valueOf(1000000000L));

    private TimeUtil() {
    }

    @Deprecated
    public static String toString(Timestamp timestamp) {
        return Timestamps.toString(timestamp);
    }

    @Deprecated
    public static Timestamp parseTimestamp(String string) throws ParseException {
        return Timestamps.parse(string);
    }

    @Deprecated
    public static String toString(Duration duration) {
        return Durations.toString(duration);
    }

    @Deprecated
    public static Duration parseDuration(String string) throws ParseException {
        return Durations.parse(string);
    }

    @Deprecated
    public static Timestamp createTimestampFromMillis(long l) {
        return Timestamps.fromMillis(l);
    }

    @Deprecated
    public static Duration createDurationFromMillis(long l) {
        return Durations.fromMillis(l);
    }

    @Deprecated
    public static long toMillis(Timestamp timestamp) {
        return Timestamps.toMillis(timestamp);
    }

    @Deprecated
    public static long toMillis(Duration duration) {
        return Durations.toMillis(duration);
    }

    @Deprecated
    public static Timestamp createTimestampFromMicros(long l) {
        return Timestamps.fromMicros(l);
    }

    @Deprecated
    public static Duration createDurationFromMicros(long l) {
        return Durations.fromMicros(l);
    }

    @Deprecated
    public static long toMicros(Timestamp timestamp) {
        return Timestamps.toMicros(timestamp);
    }

    @Deprecated
    public static long toMicros(Duration duration) {
        return Durations.toMicros(duration);
    }

    @Deprecated
    public static Timestamp createTimestampFromNanos(long l) {
        return Timestamps.fromNanos(l);
    }

    @Deprecated
    public static Duration createDurationFromNanos(long l) {
        return Durations.fromNanos(l);
    }

    @Deprecated
    public static long toNanos(Timestamp timestamp) {
        return Timestamps.toNanos(timestamp);
    }

    @Deprecated
    public static long toNanos(Duration duration) {
        return Durations.toNanos(duration);
    }

    @Deprecated
    public static Timestamp getCurrentTime() {
        return Timestamps.fromMillis(System.currentTimeMillis());
    }

    @Deprecated
    public static Timestamp getEpoch() {
        return Timestamp.getDefaultInstance();
    }

    @Deprecated
    public static Duration distance(Timestamp timestamp, Timestamp timestamp2) {
        return Timestamps.between(timestamp, timestamp2);
    }

    @Deprecated
    public static Timestamp add(Timestamp timestamp, Duration duration) {
        return Timestamps.add(timestamp, duration);
    }

    @Deprecated
    public static Timestamp subtract(Timestamp timestamp, Duration duration) {
        return Timestamps.subtract(timestamp, duration);
    }

    @Deprecated
    public static Duration add(Duration duration, Duration duration2) {
        return Durations.add(duration, duration2);
    }

    @Deprecated
    public static Duration subtract(Duration duration, Duration duration2) {
        return Durations.subtract(duration, duration2);
    }

    public static Duration multiply(Duration duration, double d) {
        double d2 = (double)duration.getSeconds() * d + (double)duration.getNanos() * d / 1.0E9;
        if (d2 < -9.223372036854776E18 || d2 > 9.223372036854776E18) {
            throw new IllegalArgumentException("Result is out of valid range.");
        }
        long l = (long)d2;
        int n = (int)((d2 - (double)l) * 1.0E9);
        return TimeUtil.normalizedDuration(l, n);
    }

    public static Duration divide(Duration duration, double d) {
        return TimeUtil.multiply(duration, 1.0 / d);
    }

    public static Duration multiply(Duration duration, long l) {
        return TimeUtil.createDurationFromBigInteger(TimeUtil.toBigInteger(duration).multiply(TimeUtil.toBigInteger(l)));
    }

    public static Duration divide(Duration duration, long l) {
        return TimeUtil.createDurationFromBigInteger(TimeUtil.toBigInteger(duration).divide(TimeUtil.toBigInteger(l)));
    }

    public static long divide(Duration duration, Duration duration2) {
        return TimeUtil.toBigInteger(duration).divide(TimeUtil.toBigInteger(duration2)).longValue();
    }

    public static Duration remainder(Duration duration, Duration duration2) {
        return TimeUtil.createDurationFromBigInteger(TimeUtil.toBigInteger(duration).remainder(TimeUtil.toBigInteger(duration2)));
    }

    private static BigInteger toBigInteger(Duration duration) {
        return TimeUtil.toBigInteger(duration.getSeconds()).multiply(NANOS_PER_SECOND_BIG_INTEGER).add(TimeUtil.toBigInteger(duration.getNanos()));
    }

    private static BigInteger toBigInteger(long l) {
        return new BigInteger(String.valueOf(l));
    }

    private static Duration createDurationFromBigInteger(BigInteger bigInteger) {
        long l = bigInteger.divide(new BigInteger(String.valueOf(1000000000L))).longValue();
        int n = bigInteger.remainder(new BigInteger(String.valueOf(1000000000L))).intValue();
        return TimeUtil.normalizedDuration(l, n);
    }

    private static Duration normalizedDuration(long l, int n) {
        if ((long)n <= -1000000000L || (long)n >= 1000000000L) {
            l += (long)n / 1000000000L;
            n = (int)((long)n % 1000000000L);
        }
        if (l > 0L && n < 0) {
            n = (int)((long)n + 1000000000L);
            --l;
        }
        if (l < 0L && n > 0) {
            n = (int)((long)n - 1000000000L);
            ++l;
        }
        if (l < -315576000000L || l > 315576000000L) {
            throw new IllegalArgumentException("Duration is out of valid range.");
        }
        return Duration.newBuilder().setSeconds(l).setNanos(n).build();
    }
}

