/*
 * Decompiled with CFR 0.152.
 */
package com.google.common.graph;

import com.google.common.annotations.Beta;
import com.google.common.base.Preconditions;
import com.google.common.collect.UnmodifiableIterator;
import com.google.common.graph.SuccessorsFunction;
import java.util.ArrayDeque;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Queue;
import java.util.Set;

@Beta
public abstract class Traverser<N> {
    public static <N> Traverser<N> forGraph(SuccessorsFunction<N> graph) {
        return new GraphTraverser<N>(graph);
    }

    public static <N> Traverser<N> forTree(SuccessorsFunction<N> tree) {
        throw new UnsupportedOperationException("Not yet implemented");
    }

    public abstract Iterable<N> breadthFirst(N var1);

    public abstract Iterable<N> depthFirstPreOrder(N var1);

    public abstract Iterable<N> depthFirstPostOrder(N var1);

    private static class GraphTraverser<N>
    extends Traverser<N> {
        private final SuccessorsFunction<N> graph;

        GraphTraverser(SuccessorsFunction<N> graph) {
            this.graph = Preconditions.checkNotNull(graph);
        }

        @Override
        public Iterable<N> breadthFirst(final N startNode) {
            return new Iterable<N>(){

                @Override
                public Iterator<N> iterator() {
                    return new BreadthFirstIterator(startNode);
                }
            };
        }

        @Override
        public Iterable<N> depthFirstPreOrder(N startNode) {
            throw new UnsupportedOperationException("Not yet implemented");
        }

        @Override
        public Iterable<N> depthFirstPostOrder(N startNode) {
            throw new UnsupportedOperationException("Not yet implemented");
        }

        final class BreadthFirstIterator
        extends UnmodifiableIterator<N> {
            final Queue<N> queue = new ArrayDeque();
            final Set<N> visited = new HashSet();

            BreadthFirstIterator(N root) {
                this.queue.add(root);
                this.visited.add(root);
            }

            @Override
            public boolean hasNext() {
                return !this.queue.isEmpty();
            }

            @Override
            public N next() {
                Object current = this.queue.remove();
                for (Object neighbor : GraphTraverser.this.graph.successors(current)) {
                    if (!this.visited.add(neighbor)) continue;
                    this.queue.add(neighbor);
                }
                return current;
            }
        }
    }
}

