/*
 * Decompiled with CFR 0.152.
 */
package com.google.common.truth;

import com.google.common.base.Preconditions;
import com.google.common.base.Throwables;
import com.google.common.truth.AbstractFailureStrategy;
import com.google.common.truth.FailureStrategy;
import com.google.common.truth.SimpleSubjectBuilder;
import com.google.common.truth.StandardSubjectBuilder;
import com.google.common.truth.Subject;
import com.google.common.truth.SubjectFactory;
import com.google.common.truth.Truth;
import javax.annotation.Nullable;
import org.junit.rules.TestRule;
import org.junit.runner.Description;
import org.junit.runners.model.Statement;

public final class ExpectFailure
implements TestRule {
    private final FailureStrategy strategy = new AbstractFailureStrategy(){

        @Override
        public void fail(String message, Throwable cause) {
            try {
                Truth.THROW_ASSERTION_ERROR.fail(message, cause);
            }
            catch (AssertionError e) {
                ExpectFailure.this.captureFailure(e);
                return;
            }
            throw new AssertionError((Object)"fail() unexpectedly succeeded.");
        }

        @Override
        public void failComparing(String message, CharSequence expected, CharSequence actual, Throwable cause) {
            try {
                Truth.THROW_ASSERTION_ERROR.failComparing(message, expected, actual, cause);
            }
            catch (AssertionError e) {
                ExpectFailure.this.captureFailure(e);
                return;
            }
            throw new AssertionError((Object)"fail() unexpectedly succeeded.");
        }
    };
    private boolean inRuleContext = false;
    private boolean failureExpected = false;
    @Nullable
    private AssertionError failure = null;

    public StandardSubjectBuilder whenTesting() {
        Preconditions.checkState((boolean)this.inRuleContext, (Object)"ExpectFailure must be used as a JUnit @Rule");
        if (this.failure != null) {
            AssertionError error = new AssertionError((Object)"ExpectFailure already captured a failure");
            ((Throwable)((Object)error)).initCause((Throwable)((Object)this.failure));
            throw error;
        }
        if (this.failureExpected) {
            throw new AssertionError((Object)"ExpectFailure.whenTesting() called previously, but did not capture a failure.");
        }
        this.failureExpected = true;
        return StandardSubjectBuilder.forCustomFailureStrategy(this.strategy);
    }

    public AssertionError getFailure() {
        if (this.failure == null) {
            throw new AssertionError((Object)"ExpectFailure did not capture a failure.");
        }
        return this.failure;
    }

    private void captureFailure(AssertionError captured) {
        if (this.failure != null) {
            throw new AssertionError((Object)String.format("ExpectFailure.whenTesting() caught multiple failures:\n\n%s\n\n%s\n", Throwables.getStackTraceAsString((Throwable)((Object)this.failure)), Throwables.getStackTraceAsString((Throwable)((Object)captured))));
        }
        this.failure = captured;
    }

    public static AssertionError expectFailure(StandardSubjectBuilderCallback assertionCallback) {
        ExpectFailure expectFailure = new ExpectFailure();
        expectFailure.inRuleContext = true;
        assertionCallback.invokeAssertion(expectFailure.whenTesting());
        return expectFailure.getFailure();
    }

    @Deprecated
    public static <S extends Subject<S, A>, A> AssertionError expectFailureAbout(final SubjectFactory<S, A> factory, final SimpleSubjectBuilderCallback<S, A> assertionCallback) {
        return ExpectFailure.expectFailure(new StandardSubjectBuilderCallback(){

            @Override
            public void invokeAssertion(StandardSubjectBuilder whenTesting) {
                assertionCallback.invokeAssertion(whenTesting.about(factory));
            }
        });
    }

    public static <S extends Subject<S, A>, A> AssertionError expectFailureAbout(final Subject.Factory<S, A> factory, final SimpleSubjectBuilderCallback<S, A> assertionCallback) {
        return ExpectFailure.expectFailure(new StandardSubjectBuilderCallback(){

            @Override
            public void invokeAssertion(StandardSubjectBuilder whenTesting) {
                assertionCallback.invokeAssertion(whenTesting.about(factory));
            }
        });
    }

    public Statement apply(final Statement base, Description description) {
        Preconditions.checkNotNull((Object)base);
        Preconditions.checkNotNull((Object)description);
        return new Statement(){

            public void evaluate() throws Throwable {
                ExpectFailure.this.inRuleContext = true;
                try {
                    base.evaluate();
                }
                finally {
                    ExpectFailure.this.inRuleContext = false;
                }
                if (ExpectFailure.this.failureExpected && ExpectFailure.this.failure == null) {
                    throw new AssertionError((Object)"ExpectFailure.whenTesting() invoked, but no failure was caught.");
                }
            }
        };
    }

    public static interface SimpleSubjectBuilderCallback<S extends Subject<S, A>, A> {
        public void invokeAssertion(SimpleSubjectBuilder<S, A> var1);
    }

    public static interface StandardSubjectBuilderCallback {
        public void invokeAssertion(StandardSubjectBuilder var1);
    }
}

