/*
 * Decompiled with CFR 0.152.
 */
package com.google.errorprone.bugpatterns;

import com.google.errorprone.BugPattern;
import com.google.errorprone.VisitorState;
import com.google.errorprone.bugpatterns.BugChecker;
import com.google.errorprone.fixes.Fix;
import com.google.errorprone.fixes.SuggestedFix;
import com.google.errorprone.matchers.Description;
import com.google.errorprone.matchers.Matcher;
import com.google.errorprone.matchers.Matchers;
import com.sun.source.tree.BinaryTree;
import com.sun.source.tree.ExpressionTree;
import com.sun.source.tree.LiteralTree;
import com.sun.source.tree.Tree;
import com.sun.tools.javac.code.Symtab;
import com.sun.tools.javac.code.Type;
import com.sun.tools.javac.code.Types;
import com.sun.tools.javac.tree.JCTree;

@BugPattern(name="BadShiftAmount", summary="Shift by an amount that is out of range", category=BugPattern.Category.JDK, severity=BugPattern.SeverityLevel.ERROR)
public class BadShiftAmount
extends BugChecker
implements BugChecker.BinaryTreeMatcher {
    private static final Matcher<BinaryTree> BAD_SHIFT_AMOUNT_INT = new Matcher<BinaryTree>(){

        public boolean matches(BinaryTree tree, VisitorState state) {
            Object rightValue;
            Type leftType = ((JCTree)((Object)tree.getLeftOperand())).type;
            Types types = state.getTypes();
            Symtab symtab = state.getSymtab();
            if (!(types.isSameType(leftType, symtab.intType) || types.isSameType(leftType, symtab.byteType) || types.isSameType(leftType, symtab.shortType) || types.isSameType(leftType, symtab.charType))) {
                return false;
            }
            ExpressionTree rightOperand = tree.getRightOperand();
            if (rightOperand instanceof LiteralTree && (rightValue = ((LiteralTree)rightOperand).getValue()) instanceof Number) {
                int intValue = ((Number)rightValue).intValue();
                return intValue < 0 || intValue > 31;
            }
            return false;
        }
    };
    public static final Matcher<BinaryTree> BINARY_TREE_MATCHER = Matchers.allOf((Matcher[])new Matcher[]{Matchers.anyOf((Matcher[])new Matcher[]{Matchers.kindIs((Tree.Kind)Tree.Kind.LEFT_SHIFT), Matchers.kindIs((Tree.Kind)Tree.Kind.RIGHT_SHIFT), Matchers.kindIs((Tree.Kind)Tree.Kind.UNSIGNED_RIGHT_SHIFT)}), BAD_SHIFT_AMOUNT_INT});

    public Description matchBinary(BinaryTree tree, VisitorState state) {
        SuggestedFix fix;
        if (!BINARY_TREE_MATCHER.matches((Tree)tree, state)) {
            return Description.NO_MATCH;
        }
        int intValue = ((Number)((LiteralTree)tree.getRightOperand()).getValue()).intValue();
        if (intValue >= 32 && intValue <= 63) {
            fix = tree.getLeftOperand().getKind() == Tree.Kind.INT_LITERAL ? SuggestedFix.postfixWith((Tree)tree.getLeftOperand(), (String)"L") : SuggestedFix.prefixWith((Tree)tree, (String)"(long) ");
        } else {
            String actualShiftDistance = Integer.toString(intValue & 0x1F);
            fix = SuggestedFix.replace((Tree)tree.getRightOperand(), (String)actualShiftDistance);
        }
        return this.describeMatch(tree, (Fix)fix);
    }
}

