/*
 * Decompiled with CFR 0.152.
 */
package com.google.errorprone.bugpatterns;

import com.google.errorprone.BugPattern;
import com.google.errorprone.VisitorState;
import com.google.errorprone.bugpatterns.BugChecker;
import com.google.errorprone.bugpatterns.StaticImports;
import com.google.errorprone.fixes.Fix;
import com.google.errorprone.fixes.SuggestedFix;
import com.google.errorprone.matchers.Description;
import com.sun.source.tree.ImportTree;
import com.sun.source.tree.Tree;

@BugPattern(name="NonCanonicalStaticMemberImport", summary="Static import of member uses non-canonical name", category=BugPattern.Category.JDK, severity=BugPattern.SeverityLevel.WARNING, documentSuppression=false)
public class NonCanonicalStaticMemberImport
extends BugChecker
implements BugChecker.ImportTreeMatcher {
    public Description matchImport(ImportTree tree, VisitorState state) {
        StaticImports.StaticImportInfo importInfo = StaticImports.tryCreate(tree, state);
        if (importInfo == null || importInfo.isCanonical() || importInfo.members().isEmpty()) {
            return Description.NO_MATCH;
        }
        return this.describeMatch(tree, (Fix)SuggestedFix.replace((Tree)tree, (String)importInfo.importStatement()));
    }
}

