/*
 * Decompiled with CFR 0.152.
 */
package com.google.errorprone.bugpatterns;

import com.google.errorprone.BugPattern;
import com.google.errorprone.VisitorState;
import com.google.errorprone.bugpatterns.BugChecker;
import com.google.errorprone.fixes.Fix;
import com.google.errorprone.fixes.SuggestedFix;
import com.google.errorprone.matchers.Description;
import com.google.errorprone.matchers.Matcher;
import com.google.errorprone.matchers.Matchers;
import com.google.errorprone.matchers.MethodVisibility;
import com.google.errorprone.suppliers.Supplier;
import com.google.errorprone.suppliers.Suppliers;
import com.google.errorprone.util.ASTHelpers;
import com.sun.source.tree.ClassTree;
import com.sun.source.tree.IdentifierTree;
import com.sun.source.tree.MethodTree;
import com.sun.source.tree.Tree;
import com.sun.source.util.TreeScanner;
import com.sun.tools.javac.tree.JCTree;
import com.sun.tools.javac.util.Name;

@BugPattern(name="NonOverridingEquals", summary="equals method doesn't override Object.equals", category=BugPattern.Category.JDK, severity=BugPattern.SeverityLevel.WARNING, tags={"FragileCode"})
public class NonOverridingEquals
extends BugChecker
implements BugChecker.MethodTreeMatcher {
    private static final String MESSAGE_BASE = "equals method doesn't override Object.equals";
    private static final Matcher<MethodTree> MATCHER = Matchers.allOf((Matcher[])new Matcher[]{Matchers.methodIsNamed((String)"equals"), Matchers.methodHasParameters((Matcher[])new Matcher[]{Matchers.variableType((Matcher)Matchers.not((Matcher)Matchers.isSameType((String)"java.lang.Object")))}), Matchers.anyOf((Matcher[])new Matcher[]{Matchers.methodReturns((Supplier)Suppliers.BOOLEAN_TYPE), Matchers.methodReturns((Supplier)Suppliers.JAVA_LANG_BOOLEAN_TYPE)})});
    private static final Matcher<MethodTree> enclosingClassOverridesEquals = Matchers.enclosingClass((Matcher)Matchers.hasMethod((Matcher)Matchers.allOf((Matcher[])new Matcher[]{Matchers.methodIsNamed((String)"equals"), Matchers.methodReturns((Supplier)Suppliers.BOOLEAN_TYPE), Matchers.methodHasParameters((Matcher[])new Matcher[]{Matchers.variableType((Matcher)Matchers.isSameType((Supplier)Suppliers.OBJECT_TYPE))}), Matchers.not((Matcher)Matchers.isStatic())})));
    private static final Matcher<MethodTree> noFixMatcher = Matchers.anyOf((Matcher[])new Matcher[]{Matchers.isStatic(), Matchers.not((Matcher)Matchers.methodHasVisibility((MethodVisibility.Visibility)MethodVisibility.Visibility.PUBLIC)), Matchers.methodReturns((Supplier)Suppliers.JAVA_LANG_BOOLEAN_TYPE)});

    public Description matchMethod(MethodTree methodTree, VisitorState state) {
        if (!MATCHER.matches((Tree)methodTree, state)) {
            return Description.NO_MATCH;
        }
        if (enclosingClassOverridesEquals.matches((Tree)methodTree, state)) {
            return this.buildDescription(methodTree).setMessage("equals method doesn't override Object.equals; if this is a type-specific helper for a method that does override Object.equals, either inline it into the callers or rename it to avoid ambiguity").build();
        }
        if (noFixMatcher.matches((Tree)methodTree, state)) {
            return this.describeMatch(methodTree);
        }
        JCTree.JCClassDecl cls = (JCTree.JCClassDecl)state.findEnclosing(new Class[]{ClassTree.class});
        if ((cls.getModifiers().flags & 0x4000L) != 0L) {
            return this.buildDescription(methodTree).setMessage("equals method doesn't override Object.equals; enum instances can safely be compared by reference equality, so please delete this").addFix((Fix)SuggestedFix.delete((Tree)methodTree)).build();
        }
        SuggestedFix.Builder fix = SuggestedFix.builder();
        if (ASTHelpers.getAnnotation((Tree)methodTree, Override.class) == null) {
            fix.prefixWith((Tree)methodTree, "@Override\n");
        }
        JCTree parameterType = (JCTree)methodTree.getParameters().get(0).getType();
        Name parameterName = ((JCTree.JCVariableDecl)methodTree.getParameters().get(0)).getName();
        fix.replace((Tree)parameterType, "Object");
        if (methodTree.getBody() != null) {
            String typeCheckStmt = "if (!(" + parameterName + " instanceof " + parameterType + ")) {\n  return false;\n}\n";
            fix.prefixWith((Tree)methodTree.getBody().getStatements().get(0), typeCheckStmt);
            new CastScanner().scan(methodTree.getBody(), new CastState(parameterName, parameterType.toString(), fix));
        }
        return this.describeMatch(methodTree, (Fix)fix.build());
    }

    private static class CastScanner
    extends TreeScanner<Void, CastState> {
        private CastScanner() {
        }

        @Override
        public Void visitIdentifier(IdentifierTree node, CastState state) {
            if (state.name.equals(node.getName())) {
                state.fix.replace((Tree)node, "((" + state.castToType + ") " + state.name + ")");
            }
            return (Void)super.visitIdentifier(node, state);
        }
    }

    private static class CastState {
        final Name name;
        final String castToType;
        final SuggestedFix.Builder fix;

        public CastState(Name name, String castToType, SuggestedFix.Builder fix) {
            this.name = name;
            this.castToType = castToType;
            this.fix = fix;
        }
    }
}

