/*
 * Decompiled with CFR 0.152.
 */
package com.google.errorprone;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.errorprone.BaseErrorProneJavaCompiler;
import com.google.errorprone.InvalidCommandLineOptionException;
import com.google.errorprone.MaskedClassLoader;
import com.google.errorprone.scanner.ScannerSupplier;
import com.sun.tools.javac.main.CommandLine;
import com.sun.tools.javac.main.Main;
import java.io.BufferedWriter;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.io.UncheckedIOException;
import java.io.Writer;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.processing.Processor;
import javax.tools.DiagnosticListener;
import javax.tools.JavaCompiler;
import javax.tools.JavaFileManager;
import javax.tools.JavaFileObject;

@Deprecated
public class BaseErrorProneCompiler {
    private final DiagnosticListener<? super JavaFileObject> diagnosticListener;
    private final PrintWriter errOutput;
    private final ScannerSupplier scannerSupplier;

    private BaseErrorProneCompiler(PrintWriter errOutput, DiagnosticListener<? super JavaFileObject> diagnosticListener, ScannerSupplier scannerSupplier) {
        this.errOutput = errOutput;
        this.diagnosticListener = diagnosticListener;
        this.scannerSupplier = (ScannerSupplier)Preconditions.checkNotNull((Object)scannerSupplier);
    }

    public static Builder builder() {
        return new Builder();
    }

    public Main.Result run(String[] argv) {
        try {
            argv = CommandLine.parse((String[])argv);
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
        ArrayList<String> javacOpts = new ArrayList<String>();
        ArrayList<String> sources = new ArrayList<String>();
        for (String arg : argv) {
            if (!arg.startsWith("-") && arg.endsWith(".java")) {
                sources.add(arg);
                continue;
            }
            javacOpts.add(arg);
        }
        MaskedClassLoader.MaskedFileManager fileManager = new MaskedClassLoader.MaskedFileManager();
        return this.run(javacOpts.toArray(new String[0]), fileManager, (List<JavaFileObject>)ImmutableList.copyOf(fileManager.getJavaFileObjectsFromStrings(sources)), null);
    }

    public Main.Result run(String[] argv, List<JavaFileObject> javaFileObjects) {
        return this.run(argv, null, javaFileObjects, (Iterable<? extends Processor>)ImmutableList.of());
    }

    public Main.Result run(String[] args, JavaFileManager fileManager, List<JavaFileObject> javaFileObjects, Iterable<? extends Processor> processors) {
        BaseErrorProneJavaCompiler compiler = new BaseErrorProneJavaCompiler(this.scannerSupplier);
        try {
            JavaCompiler.CompilationTask task = compiler.getTask(this.errOutput, fileManager, this.diagnosticListener, (Iterable<String>)ImmutableList.copyOf((Object[])args), null, javaFileObjects);
            if (processors != null) {
                task.setProcessors(processors);
            }
            return task.call() != false ? Main.Result.OK : Main.Result.ERROR;
        }
        catch (InvalidCommandLineOptionException e) {
            this.errOutput.print(e);
            this.errOutput.flush();
            return Main.Result.CMDERR;
        }
    }

    public static class Builder {
        private DiagnosticListener<? super JavaFileObject> diagnosticListener = null;
        private PrintWriter errOutput = new PrintWriter((Writer)new BufferedWriter(new OutputStreamWriter((OutputStream)System.err, Charset.defaultCharset())), true);
        private ScannerSupplier scannerSupplier;

        public BaseErrorProneCompiler build() {
            return new BaseErrorProneCompiler(this.errOutput, this.diagnosticListener, this.scannerSupplier);
        }

        public Builder redirectOutputTo(PrintWriter errOutput) {
            this.errOutput = errOutput;
            return this;
        }

        public Builder listenToDiagnostics(DiagnosticListener<? super JavaFileObject> listener) {
            this.diagnosticListener = listener;
            return this;
        }

        public Builder report(ScannerSupplier scannerSupplier) {
            this.scannerSupplier = scannerSupplier;
            return this;
        }
    }
}

