/*
 * Decompiled with CFR 0.152.
 */
package com.google.errorprone.bugpatterns;

import com.google.errorprone.BugPattern;
import com.google.errorprone.VisitorState;
import com.google.errorprone.bugpatterns.BugChecker;
import com.google.errorprone.fixes.Fix;
import com.google.errorprone.fixes.SuggestedFix;
import com.google.errorprone.matchers.Description;
import com.google.errorprone.matchers.Matcher;
import com.google.errorprone.matchers.Matchers;
import com.google.errorprone.util.ASTHelpers;
import com.sun.source.tree.BinaryTree;
import com.sun.source.tree.CompoundAssignmentTree;
import com.sun.source.tree.ExpressionTree;
import com.sun.source.tree.LiteralTree;
import com.sun.source.tree.StatementTree;
import com.sun.source.tree.Tree;
import com.sun.source.util.TreePath;

@BugPattern(name="DivZero", altNames={"divzero"}, summary="Division by integer literal zero", severity=BugPattern.SeverityLevel.ERROR, providesFix=BugPattern.ProvidesFix.REQUIRES_HUMAN_ATTENTION)
public class DivZero
extends BugChecker
implements BugChecker.BinaryTreeMatcher,
BugChecker.CompoundAssignmentTreeMatcher {
    public Description matchBinary(BinaryTree tree, VisitorState state) {
        return this.matchDivZero(tree, tree.getRightOperand(), state);
    }

    public Description matchCompoundAssignment(CompoundAssignmentTree tree, VisitorState state) {
        return this.matchDivZero(tree, tree.getExpression(), state);
    }

    private Description matchDivZero(Tree tree, ExpressionTree operand, VisitorState state) {
        if (!Matchers.anyOf((Matcher[])new Matcher[]{Matchers.kindIs((Tree.Kind)Tree.Kind.DIVIDE), Matchers.kindIs((Tree.Kind)Tree.Kind.DIVIDE_ASSIGNMENT)}).matches(tree, state)) {
            return Description.NO_MATCH;
        }
        if (!Matchers.kindIs((Tree.Kind)Tree.Kind.INT_LITERAL).matches((Tree)operand, state)) {
            return Description.NO_MATCH;
        }
        LiteralTree rightOperand = (LiteralTree)operand;
        if ((Integer)rightOperand.getValue() != 0) {
            return Description.NO_MATCH;
        }
        StatementTree enclosingStmt = (StatementTree)ASTHelpers.findEnclosingNode((TreePath)state.getPath(), StatementTree.class);
        return enclosingStmt != null ? this.describeMatch(tree, (Fix)SuggestedFix.replace((Tree)enclosingStmt, (String)"throw new ArithmeticException(\"/ by zero\");")) : this.describeMatch(tree);
    }
}

