/*
 * Decompiled with CFR 0.152.
 */
package com.google.errorprone.bugpatterns;

import com.google.errorprone.BugPattern;
import com.google.errorprone.VisitorState;
import com.google.errorprone.bugpatterns.BugChecker;
import com.google.errorprone.matchers.Description;
import com.sun.source.tree.CompilationUnitTree;

@BugPattern(name="PackageInfo", summary="Declaring types inside package-info.java files is very bad form", severity=BugPattern.SeverityLevel.ERROR)
public class PackageInfo
extends BugChecker
implements BugChecker.CompilationUnitTreeMatcher {
    public Description matchCompilationUnit(CompilationUnitTree tree, VisitorState state) {
        if (tree.getSourceFile() == null) {
            return Description.NO_MATCH;
        }
        String name = tree.getSourceFile().getName();
        int idx = name.lastIndexOf(47);
        if (idx != -1) {
            name = name.substring(idx + 1);
        }
        if (!name.equals("package-info.java")) {
            return Description.NO_MATCH;
        }
        if (tree.getTypeDecls().isEmpty()) {
            return Description.NO_MATCH;
        }
        return this.describeMatch(tree.getTypeDecls().get(0));
    }
}

