/*
 * Decompiled with CFR 0.152.
 */
package com.google.errorprone.bugpatterns.inject.guice;

import com.google.errorprone.BugPattern;
import com.google.errorprone.VisitorState;
import com.google.errorprone.bugpatterns.BugChecker;
import com.google.errorprone.fixes.Fix;
import com.google.errorprone.fixes.SuggestedFix;
import com.google.errorprone.matchers.Description;
import com.google.errorprone.matchers.InjectMatchers;
import com.google.errorprone.util.ASTHelpers;
import com.sun.source.tree.MethodTree;
import com.sun.source.tree.Tree;
import com.sun.tools.javac.code.Symbol;
import com.sun.tools.javac.code.Types;

@BugPattern(name="OverridesJavaxInjectableMethod", summary="This method is not annotated with @Inject, but it overrides a method that is  annotated with @javax.inject.Inject. The method will not be Injected.", severity=BugPattern.SeverityLevel.ERROR, providesFix=BugPattern.ProvidesFix.REQUIRES_HUMAN_ATTENTION)
public class OverridesJavaxInjectableMethod
extends BugChecker
implements BugChecker.MethodTreeMatcher {
    public Description matchMethod(MethodTree methodTree, VisitorState state) {
        if (InjectMatchers.hasInjectAnnotation().matches((Tree)methodTree, state)) {
            return Description.NO_MATCH;
        }
        boolean foundJavaxInject = false;
        for (Symbol.MethodSymbol superMethod : ASTHelpers.findSuperMethods((Symbol.MethodSymbol)ASTHelpers.getSymbol((MethodTree)methodTree), (Types)state.getTypes())) {
            if (ASTHelpers.hasAnnotation((Symbol)superMethod, (String)"com.google.inject.Inject", (VisitorState)state)) {
                return Description.NO_MATCH;
            }
            foundJavaxInject |= ASTHelpers.hasAnnotation((Symbol)superMethod, (String)"javax.inject.Inject", (VisitorState)state);
        }
        if (foundJavaxInject) {
            return this.describeMatch(methodTree, (Fix)SuggestedFix.builder().addImport("javax.inject.Inject").prefixWith((Tree)methodTree, "@Inject\n").build());
        }
        return Description.NO_MATCH;
    }
}

