/*
 * Decompiled with CFR 0.152.
 */
package com.google.errorprone.bugpatterns.time;

import com.google.common.collect.ImmutableList;
import com.google.errorprone.BugPattern;
import com.google.errorprone.VisitorState;
import com.google.errorprone.bugpatterns.BugChecker;
import com.google.errorprone.matchers.Description;
import com.google.errorprone.matchers.Matcher;
import com.google.errorprone.matchers.Matchers;
import com.google.errorprone.matchers.method.MethodMatchers;
import com.google.errorprone.util.ASTHelpers;
import com.google.protobuf.GeneratedMessage;
import com.google.protobuf.GeneratedMessageLite;
import com.sun.source.tree.ClassTree;
import com.sun.source.tree.ExpressionTree;
import com.sun.source.tree.LambdaExpressionTree;
import com.sun.source.tree.MethodInvocationTree;
import com.sun.source.tree.Tree;
import com.sun.source.tree.VariableTree;
import com.sun.source.util.TreeScanner;
import com.sun.tools.javac.code.Symbol;
import com.sun.tools.javac.tree.JCTree;
import java.util.ArrayList;
import java.util.List;
import java.util.regex.Pattern;

@BugPattern(name="JavaDurationGetSecondsGetNano", summary="duration.getNano() only accesses the underlying nanosecond adjustment from the whole second.", explanation="If you call duration.getNano(), you must also call duration.getSeconds() in 'nearby' code. If you are trying to convert this duration to nanoseconds, you probably meant to use duration.toNanos() instead.", severity=BugPattern.SeverityLevel.WARNING)
public final class JavaDurationGetSecondsGetNano
extends BugChecker
implements BugChecker.MethodInvocationTreeMatcher {
    private static final Matcher<ExpressionTree> GET_SECONDS = MethodMatchers.instanceMethod().onExactClass("java.time.Duration").named("getSeconds");
    private static final Matcher<ExpressionTree> GET_NANO = Matchers.allOf((Matcher[])new Matcher[]{MethodMatchers.instanceMethod().onExactClass("java.time.Duration").named("getNano"), Matchers.not((Matcher)Matchers.packageStartsWith((String)"java."))});
    private static final Matcher<ExpressionTree> IS_IMMUTABLE_PROTO_GETTER = MethodMatchers.instanceMethod().onDescendantOfAny(new String[]{GeneratedMessage.class.getName(), GeneratedMessageLite.class.getName()}).withNameMatching(Pattern.compile("get(?!CachedSize$|SerializedSize$).+")).withParameters(new String[0]);

    public Description matchMethodInvocation(MethodInvocationTree tree, VisitorState state) {
        if (GET_NANO.matches((Tree)tree, state) && !JavaDurationGetSecondsGetNano.containsGetSecondsCallInNearbyCode(tree, state, GET_SECONDS, false)) {
            return this.describeMatch(tree);
        }
        return Description.NO_MATCH;
    }

    static boolean containsGetSecondsCallInNearbyCode(final MethodInvocationTree nanoTree, final VisitorState state, final Matcher<ExpressionTree> secondsMatcher, final boolean checkProtoChains) {
        final ExpressionTree getNanoReceiver = ASTHelpers.getReceiver((ExpressionTree)nanoTree);
        TreeScanner<Boolean, Void> scanner = new TreeScanner<Boolean, Void>(){

            @Override
            public Boolean reduce(Boolean r1, Boolean r2) {
                return r1 != null && r1 != false || r2 != null && r2 != false;
            }

            @Override
            public Boolean visitLambdaExpression(LambdaExpressionTree node, Void unused) {
                return false;
            }

            @Override
            public Boolean visitMethodInvocation(MethodInvocationTree tree, Void unused) {
                ExpressionTree getSecondsReceiver;
                if (((Boolean)super.visitMethodInvocation(tree, unused)).booleanValue()) {
                    return true;
                }
                if (tree != null && secondsMatcher.matches((Tree)tree, state) && (getSecondsReceiver = ASTHelpers.getReceiver((ExpressionTree)tree)) != null) {
                    if (getNanoReceiver != null && getSecondsReceiver != null && ASTHelpers.sameVariable((ExpressionTree)getNanoReceiver, (ExpressionTree)getSecondsReceiver)) {
                        return true;
                    }
                    if (!checkProtoChains) {
                        return false;
                    }
                    ExpressionTree treeRootAssignable = ASTHelpers.getRootAssignable((MethodInvocationTree)tree);
                    ExpressionTree nanoTreeRootAssignable = ASTHelpers.getRootAssignable((MethodInvocationTree)nanoTree);
                    if (treeRootAssignable != null && nanoTreeRootAssignable != null && ASTHelpers.sameVariable((ExpressionTree)treeRootAssignable, (ExpressionTree)nanoTreeRootAssignable)) {
                        ArrayList secondsChain = new ArrayList();
                        boolean allProtoGettersForSeconds = JavaDurationGetSecondsGetNano.buildChain(tree, state, secondsChain);
                        ArrayList nanosChain = new ArrayList();
                        boolean allProtoGettersForNanos = JavaDurationGetSecondsGetNano.buildChain(nanoTree, state, nanosChain);
                        if (!allProtoGettersForSeconds || !allProtoGettersForNanos) {
                            return false;
                        }
                        if (secondsChain.equals(nanosChain)) {
                            return true;
                        }
                    }
                }
                return false;
            }
        };
        ImmutableList<Tree> treesToScan = JavaDurationGetSecondsGetNano.getNearbyTreesToScan(state);
        return treesToScan.isEmpty() ? false : (Boolean)scanner.scan((Iterable<Tree>)treesToScan, (Void)null);
    }

    private static boolean buildChain(ExpressionTree expr, VisitorState state, List<Symbol> chain) {
        while (expr instanceof JCTree.JCMethodInvocation) {
            if (!IS_IMMUTABLE_PROTO_GETTER.matches((Tree)(expr = ((JCTree.JCMethodInvocation)expr).getMethodSelect()), state)) {
                return false;
            }
            if (expr instanceof JCTree.JCFieldAccess) {
                expr = ((JCTree.JCFieldAccess)expr).getExpression();
            }
            chain.add(ASTHelpers.getSymbol((Tree)expr));
        }
        return true;
    }

    private static ImmutableList<Tree> getNearbyTreesToScan(VisitorState state) {
        for (Tree parent : state.getPath()) {
            if (parent.getKind() == Tree.Kind.CLASS) {
                ImmutableList.Builder treesToScan = ImmutableList.builder();
                for (Tree tree : ((ClassTree)parent).getMembers()) {
                    ExpressionTree expressionTree;
                    if (!(tree instanceof VariableTree) || (expressionTree = ((VariableTree)tree).getInitializer()) == null) continue;
                    treesToScan.add((Object)expressionTree);
                }
                return treesToScan.build();
            }
            if (parent.getKind() == Tree.Kind.BLOCK) {
                return ImmutableList.of((Object)parent);
            }
            if (parent.getKind() != Tree.Kind.LAMBDA_EXPRESSION) continue;
            return ImmutableList.of();
        }
        return ImmutableList.of();
    }
}

