/*
 * Decompiled with CFR 0.152.
 */
package com.android.builder.testing;

import com.android.builder.testing.ConnectedDevice;
import com.android.builder.testing.api.DeviceConnector;
import com.android.builder.testing.api.DeviceException;
import com.android.builder.testing.api.DeviceProvider;
import com.android.ddmlib.AndroidDebugBridge;
import com.android.ddmlib.DdmPreferences;
import com.android.ddmlib.IDevice;
import com.android.utils.ILogger;
import com.google.common.base.Joiner;
import com.google.common.base.Splitter;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import java.io.File;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.concurrent.TimeUnit;

public class ConnectedDeviceProvider
extends DeviceProvider {
    private final File adbLocation;
    private final long timeOut;
    private final TimeUnit timeOutUnit;
    private final ILogger iLogger;
    private final List<ConnectedDevice> localDevices = Lists.newArrayList();

    public ConnectedDeviceProvider(File adbLocation, int timeOutInMs, ILogger logger) {
        this.adbLocation = adbLocation;
        this.timeOut = timeOutInMs;
        this.timeOutUnit = TimeUnit.MILLISECONDS;
        this.iLogger = logger;
    }

    public String getName() {
        return "connected";
    }

    public List<? extends DeviceConnector> getDevices() {
        return this.localDevices;
    }

    public void init() throws DeviceException {
        DdmPreferences.setTimeOut((int)((int)this.timeOutUnit.toMillis(this.timeOut)));
        AndroidDebugBridge.initIfNeeded((boolean)false);
        AndroidDebugBridge bridge = AndroidDebugBridge.createBridge((String)this.adbLocation.getAbsolutePath(), (boolean)false);
        if (bridge == null) {
            throw new DeviceException("Could not create ADB Bridge. ADB location: " + this.adbLocation.getAbsolutePath());
        }
        long getDevicesCountdown = this.timeOutUnit.toMillis(this.timeOut);
        int sleepTime = 1000;
        while (!bridge.hasInitialDeviceList() && getDevicesCountdown >= 0L) {
            try {
                Thread.sleep(1000L);
            }
            catch (InterruptedException e) {
                throw new DeviceException((Throwable)e);
            }
            if (this.timeOut == 0L) continue;
            getDevicesCountdown -= 1000L;
        }
        if (!bridge.hasInitialDeviceList()) {
            throw new DeviceException("Timeout getting device list.");
        }
        IDevice[] devices = bridge.getDevices();
        if (devices.length == 0) {
            throw new DeviceException("No connected devices!");
        }
        String androidSerialsEnv = System.getenv("ANDROID_SERIAL");
        boolean isValidSerial = androidSerialsEnv != null && !androidSerialsEnv.isEmpty();
        HashSet serials = isValidSerial ? Sets.newHashSet((Iterable)Splitter.on((char)',').split((CharSequence)androidSerialsEnv)) : Collections.emptySet();
        ArrayList filteredDevices = Lists.newArrayListWithCapacity((int)devices.length);
        for (IDevice iDevice : devices) {
            if (isValidSerial && !serials.contains(iDevice.getSerialNumber())) continue;
            serials.remove(iDevice.getSerialNumber());
            filteredDevices.add(iDevice);
        }
        if (!serials.isEmpty()) {
            throw new DeviceException(String.format("Connected device with serial%s '%s' not found!", serials.size() == 1 ? "" : "s", Joiner.on((String)"', '").join((Iterable)serials)));
        }
        for (IDevice device : filteredDevices) {
            if (device.getState() == IDevice.DeviceState.ONLINE) {
                this.localDevices.add(new ConnectedDevice(device, this.iLogger, this.timeOut, this.timeOutUnit));
                continue;
            }
            this.iLogger.info("Skipping device '%s' (%s): Device is %s%s.", new Object[]{device.getName(), device.getSerialNumber(), device.getState(), device.getState() == IDevice.DeviceState.UNAUTHORIZED ? ",\n    see http://d.android.com/tools/help/adb.html#Enabling" : ""});
        }
        if (this.localDevices.isEmpty()) {
            if (isValidSerial) {
                throw new DeviceException(String.format("Connected device with serial $1%s is not online.", androidSerialsEnv));
            }
            throw new DeviceException("No online devices found.");
        }
    }

    public void terminate() throws DeviceException {
    }

    public int getTimeoutInMs() {
        return (int)this.timeOutUnit.toMillis(this.timeOut);
    }

    public boolean isConfigured() {
        return true;
    }
}

