/*
 * Decompiled with CFR 0.152.
 */
package com.google.errorprone.refaster;

import com.google.auto.value.AutoValue;
import com.google.common.base.Preconditions;
import com.google.common.collect.BiMap;
import com.google.common.collect.EnumBiMap;
import com.google.common.collect.Maps;
import com.google.errorprone.refaster.AutoValue_UWildcard;
import com.google.errorprone.refaster.Choice;
import com.google.errorprone.refaster.CouldNotResolveImportException;
import com.google.errorprone.refaster.Inliner;
import com.google.errorprone.refaster.UExpression;
import com.google.errorprone.refaster.UTree;
import com.google.errorprone.refaster.Unifier;
import com.sun.source.tree.Tree;
import com.sun.source.tree.TreeVisitor;
import com.sun.source.tree.WildcardTree;
import com.sun.tools.javac.code.BoundKind;
import com.sun.tools.javac.tree.JCTree;
import javax.annotation.Nullable;

@AutoValue
abstract class UWildcard
extends UExpression
implements WildcardTree {
    private static final BiMap<Tree.Kind, BoundKind> BOUND_KINDS;

    UWildcard() {
    }

    static UWildcard create(Tree.Kind kind, @Nullable UTree<?> bound) {
        Preconditions.checkArgument((boolean)BOUND_KINDS.containsKey((Object)kind));
        Preconditions.checkArgument((bound == null == (kind == Tree.Kind.UNBOUNDED_WILDCARD) ? 1 : 0) != 0);
        return new AutoValue_UWildcard(kind, bound);
    }

    @Override
    public abstract Tree.Kind getKind();

    @Override
    @Nullable
    public abstract UTree<?> getBound();

    @Override
    public JCTree.JCWildcard inline(Inliner inliner) throws CouldNotResolveImportException {
        return inliner.maker().Wildcard(inliner.maker().TypeBoundKind((BoundKind)((Object)BOUND_KINDS.get((Object)this.getKind()))), this.getBound() == null ? null : (JCTree)this.getBound().inline(inliner));
    }

    @Override
    public <R, D> R accept(TreeVisitor<R, D> visitor, D data) {
        return visitor.visitWildcard(this, data);
    }

    @Override
    public Choice<Unifier> visitWildcard(WildcardTree node, Unifier unifier) {
        return Choice.condition(this.getKind() == node.getKind(), unifier).thenChoose(Unifier.unifications(this.getBound(), node.getBound()));
    }

    static {
        EnumBiMap validKinds = EnumBiMap.create(Tree.Kind.class, BoundKind.class);
        validKinds.put((Object)Tree.Kind.UNBOUNDED_WILDCARD, (Object)BoundKind.UNBOUND);
        validKinds.put((Object)Tree.Kind.EXTENDS_WILDCARD, (Object)BoundKind.EXTENDS);
        validKinds.put((Object)Tree.Kind.SUPER_WILDCARD, (Object)BoundKind.SUPER);
        BOUND_KINDS = Maps.unmodifiableBiMap((BiMap)validKinds);
    }
}

