/*
 * Decompiled with CFR 0.152.
 */
package com.google.errorprone;

import com.google.common.base.Stopwatch;
import com.google.common.collect.ImmutableMap;
import com.google.errorprone.matchers.Suppressible;
import com.sun.tools.javac.util.Context;
import java.time.Duration;
import java.util.HashMap;
import java.util.Map;

public final class ErrorProneTimings {
    private static final Context.Key<ErrorProneTimings> timingsKey = new Context.Key();
    private final Map<String, Stopwatch> timers = new HashMap<String, Stopwatch>();

    public static ErrorProneTimings instance(Context context) {
        ErrorProneTimings instance = context.get(timingsKey);
        if (instance == null) {
            instance = new ErrorProneTimings(context);
        }
        return instance;
    }

    private ErrorProneTimings(Context context) {
        context.put(timingsKey, this);
    }

    public AutoCloseable span(Suppressible suppressible) {
        String key = suppressible.canonicalName();
        Stopwatch sw = this.timers.computeIfAbsent(key, k -> Stopwatch.createUnstarted()).start();
        return () -> sw.stop();
    }

    public ImmutableMap<String, Duration> timings() {
        return (ImmutableMap)this.timers.entrySet().stream().collect(ImmutableMap.toImmutableMap(e -> (String)e.getKey(), e -> ((Stopwatch)e.getValue()).elapsed()));
    }
}

