/*
 * Decompiled with CFR 0.152.
 */
package com.google.errorprone.bugpatterns;

import com.google.errorprone.BugPattern;
import com.google.errorprone.VisitorState;
import com.google.errorprone.bugpatterns.BugChecker;
import com.google.errorprone.fixes.Fix;
import com.google.errorprone.fixes.SuggestedFix;
import com.google.errorprone.matchers.Description;
import com.google.errorprone.matchers.Matcher;
import com.google.errorprone.matchers.Matchers;
import com.google.errorprone.predicates.TypePredicates;
import com.sun.source.tree.MethodInvocationTree;
import com.sun.source.tree.Tree;
import com.sun.tools.javac.tree.JCTree;

@BugPattern(name="ArrayEquals", summary="Reference equality used to compare arrays", severity=BugPattern.SeverityLevel.ERROR)
public class ArrayEquals
extends BugChecker
implements BugChecker.MethodInvocationTreeMatcher {
    private static final Matcher<MethodInvocationTree> instanceEqualsMatcher = Matchers.allOf((Matcher[])new Matcher[]{Matchers.instanceMethod().onClass(TypePredicates.isArray()).named("equals"), Matchers.argument((int)0, (Matcher)Matchers.isArrayType())});
    private static final Matcher<MethodInvocationTree> staticEqualsMatcher = Matchers.allOf((Matcher[])new Matcher[]{Matchers.staticEqualsInvocation(), Matchers.argument((int)0, (Matcher)Matchers.isArrayType()), Matchers.argument((int)1, (Matcher)Matchers.isArrayType())});

    public Description matchMethodInvocation(MethodInvocationTree t, VisitorState state) {
        String arg2;
        String arg1;
        if (instanceEqualsMatcher.matches((Tree)t, state)) {
            arg1 = state.getSourceForNode((Tree)((JCTree.JCFieldAccess)t.getMethodSelect()).getExpression());
            arg2 = state.getSourceForNode((Tree)t.getArguments().get(0));
        } else if (staticEqualsMatcher.matches((Tree)t, state)) {
            arg1 = state.getSourceForNode((Tree)t.getArguments().get(0));
            arg2 = state.getSourceForNode((Tree)t.getArguments().get(1));
        } else {
            return Description.NO_MATCH;
        }
        SuggestedFix fix = SuggestedFix.builder().replace((Tree)t, "Arrays.equals(" + arg1 + ", " + arg2 + ")").addImport("java.util.Arrays").build();
        return this.describeMatch(t, (Fix)fix);
    }
}

