/*
 * Decompiled with CFR 0.152.
 */
package com.google.errorprone.bugpatterns;

import com.google.common.base.Ascii;
import com.google.common.base.CaseFormat;
import com.google.errorprone.BugPattern;
import com.google.errorprone.VisitorState;
import com.google.errorprone.bugpatterns.BugChecker;
import com.google.errorprone.fixes.Fix;
import com.google.errorprone.fixes.SuggestedFix;
import com.google.errorprone.fixes.SuggestedFixes;
import com.google.errorprone.matchers.Description;
import com.google.errorprone.suppliers.Supplier;
import com.google.errorprone.util.ASTHelpers;
import com.sun.source.tree.CompilationUnitTree;
import com.sun.source.tree.IdentifierTree;
import com.sun.source.tree.Tree;
import com.sun.source.tree.VariableTree;
import com.sun.source.util.TreeScanner;
import com.sun.tools.javac.code.Symbol;
import com.sun.tools.javac.code.Type;
import com.sun.tools.javac.util.Name;
import java.io.Serializable;
import java.util.Objects;
import javax.lang.model.element.ElementKind;
import javax.lang.model.element.Modifier;

@BugPattern(name="DateFormatConstant", summary="DateFormat is not thread-safe, and should not be used as a constant field.", severity=BugPattern.SeverityLevel.WARNING, tags={"FragileCode"})
public class DateFormatConstant
extends BugChecker
implements BugChecker.VariableTreeMatcher {
    private static final Supplier<Type> JAVA_TEXT_DATEFORMAT = VisitorState.memoize((Supplier & Serializable)state -> state.getTypeFromString("java.text.DateFormat"));

    public Description matchVariable(VariableTree tree, VisitorState state) {
        if (tree.getInitializer() == null) {
            return Description.NO_MATCH;
        }
        Symbol.VarSymbol sym = ASTHelpers.getSymbol((VariableTree)tree);
        if (sym == null || sym.getKind() != ElementKind.FIELD) {
            return Description.NO_MATCH;
        }
        String name = ((Name)sym.getSimpleName()).toString();
        if (!sym.isStatic() || !sym.getModifiers().contains((Object)Modifier.FINAL)) {
            return Description.NO_MATCH;
        }
        if (!name.equals(Ascii.toUpperCase((String)name))) {
            return Description.NO_MATCH;
        }
        if (!ASTHelpers.isSubtype((Type)ASTHelpers.getType((Tree)tree), (Type)((Type)JAVA_TEXT_DATEFORMAT.get(state)), (VisitorState)state)) {
            return Description.NO_MATCH;
        }
        SuggestedFix rename = SuggestedFixes.renameVariable((VariableTree)tree, (String)CaseFormat.UPPER_UNDERSCORE.to(CaseFormat.LOWER_CAMEL, tree.getName().toString()), (VisitorState)state);
        return this.buildDescription(tree).addFix(DateFormatConstant.threadLocalFix(tree, state, sym, rename)).addFix((Fix)rename).build();
    }

    private static Fix threadLocalFix(VariableTree tree, VisitorState state, final Symbol.VarSymbol sym, SuggestedFix rename) {
        final SuggestedFix.Builder fix = SuggestedFix.builder().merge(rename).replace(tree.getType(), String.format("ThreadLocal<%s>", state.getSourceForNode(tree.getType()))).prefixWith((Tree)tree.getInitializer(), "ThreadLocal.withInitial(() -> ").postfixWith((Tree)tree.getInitializer(), ")");
        CompilationUnitTree unit = state.getPath().getCompilationUnit();
        unit.accept(new TreeScanner<Void, Void>(){

            @Override
            public Void visitIdentifier(IdentifierTree tree, Void unused) {
                if (Objects.equals(ASTHelpers.getSymbol((Tree)tree), sym)) {
                    fix.postfixWith((Tree)tree, ".get()");
                }
                return null;
            }
        }, null);
        return fix.build();
    }
}

