/*
 * Decompiled with CFR 0.152.
 */
package com.google.errorprone.bugpatterns;

import com.google.errorprone.BugPattern;
import com.google.errorprone.VisitorState;
import com.google.errorprone.bugpatterns.BugChecker;
import com.google.errorprone.matchers.Description;
import com.google.errorprone.matchers.Matcher;
import com.google.errorprone.matchers.Matchers;
import com.sun.source.tree.MethodInvocationTree;
import com.sun.source.tree.Tree;
import java.util.regex.Pattern;

@BugPattern(name="PrivateSecurityContractProtoAccess", summary="Access to a private protocol buffer field is forbidden. This protocol buffer carries a security contract, and can only be created using an approved library. Direct access to the fields is forbidden.", severity=BugPattern.SeverityLevel.ERROR, linkType=BugPattern.LinkType.NONE)
public class PrivateSecurityContractProtoAccess
extends BugChecker
implements BugChecker.MethodInvocationTreeMatcher {
    private static final Pattern PRIVATE_DO_NOT_ACCESS_OR_ELSE = Pattern.compile(".*PrivateDoNotAccessOrElse.*");
    private static final Matcher<MethodInvocationTree> SAFEHTML_PRIVATE_FIELD_ACCESS = Matchers.allOf((Matcher[])new Matcher[]{Matchers.anyOf((Matcher[])new Matcher[]{PrivateSecurityContractProtoAccess.createFieldMatcher("com.google.common.html.types.SafeHtmlProto"), PrivateSecurityContractProtoAccess.createFieldMatcher("com.google.common.html.types.SafeUrlProto"), PrivateSecurityContractProtoAccess.createFieldMatcher("com.google.common.html.types.TrustedResourceUrlProto"), PrivateSecurityContractProtoAccess.createFieldMatcher("com.google.common.html.types.SafeScriptProto"), PrivateSecurityContractProtoAccess.createFieldMatcher("com.google.common.html.types.SafeStyleProto"), PrivateSecurityContractProtoAccess.createFieldMatcher("com.google.common.html.types.SafeStyleSheetProto")}), Matchers.not((Matcher)Matchers.packageStartsWith((String)"com.google.common.html.types"))});
    private static final String MESSAGE = "Forbidden access to a private proto field. See ";
    private static final String SAFEHTML_LINK = "https://github.com/google/safe-html-types/blob/master/doc/safehtml-types.md#protocol-buffer-conversion";

    private static Matcher<MethodInvocationTree> createFieldMatcher(String className) {
        String builderName = className + ".Builder";
        return Matchers.anyOf((Matcher[])new Matcher[]{Matchers.instanceMethod().onExactClass(className).withNameMatching(PRIVATE_DO_NOT_ACCESS_OR_ELSE), Matchers.instanceMethod().onExactClass(builderName).withNameMatching(PRIVATE_DO_NOT_ACCESS_OR_ELSE)});
    }

    private Description buildErrorMessage(MethodInvocationTree tree, String link) {
        Description.Builder description = this.buildDescription(tree);
        String message = MESSAGE + link + ".";
        description.setMessage(message);
        return description.build();
    }

    public Description matchMethodInvocation(MethodInvocationTree tree, VisitorState state) {
        if (SAFEHTML_PRIVATE_FIELD_ACCESS.matches((Tree)tree, state)) {
            return this.buildErrorMessage(tree, SAFEHTML_LINK);
        }
        return Description.NO_MATCH;
    }
}

