/*
 * Decompiled with CFR 0.152.
 */
package com.google.errorprone.bugpatterns;

import com.google.errorprone.BugPattern;
import com.google.errorprone.VisitorState;
import com.google.errorprone.bugpatterns.AbstractToString;
import com.google.errorprone.fixes.Fix;
import com.google.errorprone.predicates.TypePredicate;
import com.google.errorprone.predicates.TypePredicates;
import com.sun.source.tree.ExpressionTree;
import com.sun.source.tree.Tree;
import java.util.Optional;

@BugPattern(name="StreamToString", summary="Calling toString on a Stream does not provide useful information", severity=BugPattern.SeverityLevel.ERROR)
public class StreamToString
extends AbstractToString {
    private static final TypePredicate STREAM = TypePredicates.isDescendantOf((String)"java.util.stream.Stream");

    @Override
    protected TypePredicate typePredicate() {
        return STREAM;
    }

    @Override
    protected Optional<Fix> implicitToStringFix(ExpressionTree tree, VisitorState state) {
        return Optional.empty();
    }

    @Override
    protected Optional<Fix> toStringFix(Tree parent, ExpressionTree tree, VisitorState state) {
        return Optional.empty();
    }
}

