/*
 * Decompiled with CFR 0.152.
 */
package com.google.errorprone.bugpatterns;

import com.google.common.collect.ImmutableSet;
import com.google.errorprone.BugPattern;
import com.google.errorprone.VisitorState;
import com.google.errorprone.bugpatterns.BugChecker;
import com.google.errorprone.fixes.Fix;
import com.google.errorprone.fixes.SuggestedFix;
import com.google.errorprone.fixes.SuggestedFixes;
import com.google.errorprone.matchers.ChildMultiMatcher;
import com.google.errorprone.matchers.Description;
import com.google.errorprone.matchers.JUnitMatchers;
import com.google.errorprone.matchers.Matcher;
import com.google.errorprone.matchers.Matchers;
import com.google.errorprone.matchers.MultiMatcher;
import com.google.errorprone.util.ASTHelpers;
import com.sun.source.tree.AnnotationTree;
import com.sun.source.tree.ClassTree;
import com.sun.source.tree.Tree;

@BugPattern(name="TestParametersNotInitialized", summary="This test has @TestParameter fields but is using the default JUnit4 runner. The parameters will not be initialised beyond their default value.", severity=BugPattern.SeverityLevel.ERROR)
public final class TestParametersNotInitialized
extends BugChecker
implements BugChecker.ClassTreeMatcher {
    private static final String TEST_PARAMETER = "com.google.testing.junit.testparameterinjector.TestParameter";
    private static final String RUNNER = "com.google.testing.junit.testparameterinjector.TestParameterInjector";
    private static final MultiMatcher<Tree, AnnotationTree> TEST_PARAMETER_INJECTOR = Matchers.annotations((ChildMultiMatcher.MatchType)ChildMultiMatcher.MatchType.AT_LEAST_ONE, (Matcher)Matchers.hasArgumentWithValue((String)"value", (Matcher)JUnitMatchers.isJUnit4TestRunnerOfType((Iterable)ImmutableSet.of((Object)"com.google.testing.junit.testparameterinjector.TestParameterInjector"))));
    private static final MultiMatcher<ClassTree, AnnotationTree> JUNIT4_RUNNER = Matchers.annotations((ChildMultiMatcher.MatchType)ChildMultiMatcher.MatchType.AT_LEAST_ONE, (Matcher)Matchers.hasArgumentWithValue((String)"value", (Matcher)JUnitMatchers.isJUnit4TestRunnerOfType((Iterable)ImmutableSet.of((Object)"org.junit.runners.JUnit4"))));

    public Description matchClass(ClassTree tree, VisitorState state) {
        if (!JUNIT4_RUNNER.matches((Tree)tree, state)) {
            return Description.NO_MATCH;
        }
        if (TEST_PARAMETER_INJECTOR.matches((Tree)tree, state)) {
            return Description.NO_MATCH;
        }
        if (tree.getMembers().stream().noneMatch(m -> ASTHelpers.hasAnnotation((Tree)m, (String)TEST_PARAMETER, (VisitorState)state))) {
            return Description.NO_MATCH;
        }
        AnnotationTree annotation = ASTHelpers.getAnnotationWithSimpleName(tree.getModifiers().getAnnotations(), (String)"RunWith");
        SuggestedFix.Builder fix = SuggestedFix.builder();
        fix.replace((Tree)annotation, String.format("@RunWith(%s.class)", SuggestedFixes.qualifyType((VisitorState)state, (SuggestedFix.Builder)fix, (String)RUNNER)));
        return this.describeMatch(tree, (Fix)fix.build());
    }
}

