/*
 * Decompiled with CFR 0.152.
 */
package com.google.errorprone.bugpatterns;

import com.google.errorprone.BugPattern;
import com.google.errorprone.VisitorState;
import com.google.errorprone.bugpatterns.BugChecker;
import com.google.errorprone.fixes.Fix;
import com.google.errorprone.fixes.SuggestedFix;
import com.google.errorprone.matchers.Description;
import com.google.errorprone.util.ASTHelpers;
import com.sun.source.tree.ExpressionTree;
import com.sun.source.tree.ParenthesizedTree;
import com.sun.source.tree.Tree;

@BugPattern(name="UnnecessaryParentheses", summary="These grouping parentheses are unnecessary; it is unlikely the code will be misinterpreted without them", severity=BugPattern.SeverityLevel.WARNING, tags={"Style"})
public class UnnecessaryParentheses
extends BugChecker
implements BugChecker.ParenthesizedTreeMatcher {
    public Description matchParenthesized(ParenthesizedTree tree, VisitorState state) {
        ExpressionTree expression = tree.getExpression();
        Tree parent = state.getPath().getParentPath().getLeaf();
        switch (parent.getKind()) {
            case IF: 
            case WHILE_LOOP: 
            case DO_WHILE_LOOP: 
            case FOR_LOOP: 
            case SWITCH: 
            case SYNCHRONIZED: {
                return Description.NO_MATCH;
            }
        }
        switch (parent.getKind().name()) {
            case "SWITCH_EXPRESSION": {
                return Description.NO_MATCH;
            }
        }
        if (ASTHelpers.requiresParentheses((ExpressionTree)expression, (VisitorState)state)) {
            return Description.NO_MATCH;
        }
        return this.describeMatch(tree, (Fix)SuggestedFix.builder().replace(ASTHelpers.getStartPosition((Tree)tree), ASTHelpers.getStartPosition((Tree)expression), " ").replace(state.getEndPosition((Tree)expression), state.getEndPosition((Tree)tree), "").build());
    }
}

