/*
 * Decompiled with CFR 0.152.
 */
package com.google.errorprone.bugpatterns;

import com.google.common.base.CaseFormat;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Iterables;
import com.google.errorprone.BugPattern;
import com.google.errorprone.VisitorState;
import com.google.errorprone.bugpatterns.BugChecker;
import com.google.errorprone.matchers.Description;
import com.google.errorprone.matchers.Matcher;
import com.google.errorprone.matchers.method.MethodMatchers;
import com.google.errorprone.predicates.TypePredicate;
import com.google.errorprone.predicates.TypePredicates;
import com.google.errorprone.util.ASTHelpers;
import com.google.errorprone.util.Reachability;
import com.sun.source.tree.CaseTree;
import com.sun.source.tree.ExpressionTree;
import com.sun.source.tree.IdentifierTree;
import com.sun.source.tree.MemberSelectTree;
import com.sun.source.tree.MethodInvocationTree;
import com.sun.source.tree.StatementTree;
import com.sun.source.tree.SwitchTree;
import com.sun.source.tree.Tree;
import com.sun.source.util.TreePath;
import com.sun.tools.javac.code.Symbol;
import java.util.HashSet;
import java.util.List;
import java.util.Optional;
import java.util.Set;

@BugPattern(name="WrongOneof", severity=BugPattern.SeverityLevel.ERROR, summary="This field is guaranteed not to be set given it's within a switch over a one_of.")
public final class WrongOneof
extends BugChecker
implements BugChecker.SwitchTreeMatcher {
    private static final TypePredicate ONE_OF_ENUM = TypePredicates.isDescendantOf((String)"com.google.protobuf.AbstractMessageLite.InternalOneOfEnum");
    private static final Matcher<ExpressionTree> PROTO_METHOD = MethodMatchers.instanceMethod().onDescendantOf("com.google.protobuf.MessageLite");

    public Description matchSwitch(SwitchTree tree, VisitorState state) {
        if (!ONE_OF_ENUM.apply(ASTHelpers.getType((Tree)tree.getExpression()), state)) {
            return Description.NO_MATCH;
        }
        ExpressionTree expression = ASTHelpers.stripParentheses((ExpressionTree)tree.getExpression());
        if (!(expression instanceof MethodInvocationTree)) {
            return Description.NO_MATCH;
        }
        ExpressionTree receiver = ASTHelpers.getReceiver((ExpressionTree)expression);
        if (receiver == null) {
            return Description.NO_MATCH;
        }
        Optional<ImmutableList<Symbol>> receiverSymbolChain = WrongOneof.symbolizeImmutableExpression(receiver, state);
        if (!receiverSymbolChain.isPresent()) {
            return Description.NO_MATCH;
        }
        ImmutableSet getters = (ImmutableSet)ASTHelpers.enumValues((Symbol.TypeSymbol)ASTHelpers.getType((Tree)tree.getExpression()).tsym).stream().map(WrongOneof::getter).collect(ImmutableSet.toImmutableSet());
        HashSet<String> allowableGetters = new HashSet<String>();
        for (CaseTree caseTree : tree.getCases()) {
            if (caseTree.getExpression() == null) break;
            allowableGetters.add(WrongOneof.getter(((IdentifierTree)caseTree.getExpression()).getName().toString()));
            this.scanForInvalidGetters((Set<String>)getters, allowableGetters, caseTree, receiverSymbolChain.get(), state);
            List<? extends StatementTree> statements = caseTree.getStatements();
            if (statements == null || statements.isEmpty() || Reachability.canCompleteNormally((StatementTree)((StatementTree)Iterables.getLast(statements)))) continue;
            allowableGetters.clear();
        }
        return Description.NO_MATCH;
    }

    private static Optional<ImmutableList<Symbol>> symbolizeImmutableExpression(ExpressionTree tree, VisitorState state) {
        ImmutableList.Builder symbolized = ImmutableList.builder();
        ExpressionTree receiver = tree;
        while (true) {
            if (!WrongOneof.isPure(receiver, state)) {
                return Optional.empty();
            }
            symbolized.add((Object)ASTHelpers.getSymbol((Tree)receiver));
            if (!(receiver instanceof MethodInvocationTree) && !(receiver instanceof MemberSelectTree)) break;
            receiver = ASTHelpers.getReceiver((ExpressionTree)receiver);
        }
        return Optional.of(symbolized.build());
    }

    private static boolean isPure(ExpressionTree receiver, VisitorState state) {
        if (receiver instanceof IdentifierTree) {
            Symbol symbol = ASTHelpers.getSymbol((Tree)receiver);
            return symbol instanceof Symbol.VarSymbol && ASTHelpers.isConsideredFinal((Symbol)symbol);
        }
        if (PROTO_METHOD.matches((Tree)receiver, state)) {
            return ((MethodInvocationTree)receiver).getArguments().isEmpty();
        }
        return false;
    }

    private void scanForInvalidGetters(final Set<String> getters, final Set<String> allowableGetters, CaseTree caseTree, final ImmutableList<Symbol> receiverSymbolChain, final VisitorState state) {
        new BugChecker.SuppressibleTreePathScanner<Void, Void>(){

            public Void visitMethodInvocation(MethodInvocationTree methodInvocationTree, Void unused) {
                ExpressionTree receiver = ASTHelpers.getReceiver((ExpressionTree)methodInvocationTree);
                if (receiver == null) {
                    return (Void)super.visitMethodInvocation(methodInvocationTree, null);
                }
                if (!WrongOneof.symbolizeImmutableExpression(receiver, state).map(arg_0 -> ((ImmutableList)receiverSymbolChain).equals(arg_0)).orElse(false).booleanValue()) {
                    return (Void)super.visitMethodInvocation(methodInvocationTree, null);
                }
                String methodName = ((MemberSelectTree)methodInvocationTree.getMethodSelect()).getIdentifier().toString();
                if (!allowableGetters.contains(methodName) && getters.contains(methodName)) {
                    state.reportMatch(WrongOneof.this.buildDescription(methodInvocationTree).setMessage(String.format("%s is guaranteed to return the default instance, given this is within a switch over a one_of.", methodName)).build());
                }
                return (Void)super.visitMethodInvocation(methodInvocationTree, null);
            }
        }.scan(new TreePath(state.getPath(), caseTree), null);
    }

    private static String getter(String enumCase) {
        return "get" + CaseFormat.UPPER_UNDERSCORE.to(CaseFormat.UPPER_CAMEL, enumCase);
    }
}

